# Skill Optimizer - Claude Skill

This directory contains the **meta-skill** that enables Claude to optimize other Claude skills.

## Installation

Run the install script from the parent directory:

```bash
cd ..
chmod +x install-skill.sh
./install-skill.sh
```

This will copy the skill to `~/.claude/skills/skill-optimizer/`.

## What's Included

| File | Description |
|------|-------------|
| `SKILL.md` | Complete skill instructions for Claude |

## Usage

After installation, you can ask Claude Code to optimize any skill:

```
"Optimize my PPTX skill"
"Why does my docx skill fail on edge cases?"
"Improve my skill's error handling"
"Test my custom skill thoroughly"
```

## How It Works

The meta-skill provides Claude with:

1. **Skill Loading** - Instructions for finding and loading any Claude skill
2. **Test Generation** - How to create comprehensive test cases
3. **GEPA Optimization** - The optimization loop workflow
4. **Evaluation** - Built-in metrics and custom evaluator support
5. **Application** - Safely applying improvements

## Skill Locations

The meta-skill can work with skills in any standard location:

| Environment | Path |
|-------------|------|
| Claude Code (User) | `~/.claude/skills/{name}/` |
| Claude Code (Project) | `./.claude/skills/{name}/` |
| Claude.ai (Public) | `/mnt/skills/public/{name}/` |
| Claude.ai (User) | `/mnt/skills/user/{name}/` |

## License

MIT License - See [LICENSE](../../LICENSE)

## More Information

See the [main documentation](../README.md) for complete details.
