---

# === CORE IDENTITY ===
name: cto-advisor
title: CTO Advisor Skill Package
description: Technical leadership guidance for engineering teams, architecture decisions, and technology strategy. Includes tech debt analyzer, team scaling calculator, engineering metrics frameworks, technology evaluation tools, and ADR templates. Use when assessing technical debt, scaling engineering teams, evaluating technologies, making architecture decisions, establishing engineering metrics, or when user mentions CTO, tech debt, technical debt, team scaling, architecture decisions, technology evaluation, engineering metrics, DORA metrics, or technology strategy.
domain: engineering
subdomain: cto-general

# === WEBSITE DISPLAY ===
difficulty: advanced
time-saved: "TODO: Quantify time savings"
frequency: "TODO: Estimate usage frequency"
use-cases:
  - Primary workflow for Cto Advisor
  - Analysis and recommendations for cto advisor tasks
  - Best practices implementation for cto advisor
  - Integration with related skills and workflows

# === RELATIONSHIPS ===
related-agents: []
related-skills: []
related-commands: []
orchestrated-by: []

# === TECHNICAL ===
dependencies:
  scripts: []
  references: []
  assets: []
compatibility:
  python-version: 3.8+
  platforms: [macos, linux, windows]
tech-stack:
  - architecture tools
  - metrics platforms
  - monitoring systems
  - CI/CD systems
  - project management tools
  - development platforms
  - engineering dashboards

# === EXAMPLES ===
examples:
  -
    title: Example Usage
    input: "TODO: Add example input for cto-advisor"
    output: "TODO: Add expected output"

# === ANALYTICS ===
stats:
  downloads: 0
  stars: 0
  rating: 0.0
  reviews: 0

# === VERSIONING ===
version: v1.0.0
author: Claude Skills Team
contributors: []
created: 2025-10-19
updated: 2025-11-08
license: MIT

# === DISCOVERABILITY ===
tags: [advisor, architecture, cto, engineering]
featured: false
verified: true
---

# CTO Advisor

## Key Workflows

### Workflow 1: Comprehensive Technical Debt Assessment

**Time:** 3-4 hours (data gathering and analysis)

**Steps:**
1. **Gather system data across 5 categories** - Collect metrics from engineering systems
   - Code metrics: Test coverage, cyclomatic complexity, code duplication percentage
   - Infrastructure: Deployment frequency, change lead time, incident rate, uptime
   - Architecture: Service coupling, deprecated patterns, monolith vs microservices assessment
   - Team velocity: 5-sprint trend, bug rate trend, refactoring time allocation
   - Technical: Outdated dependencies, security vulnerabilities, scalability assessment
   - Source data from: CI/CD dashboards, incident management systems, code analysis tools, sprint metrics
2. **Run tech debt analyzer Python tool** - Execute comprehensive analysis
   ```bash
   python scripts/tech_debt_analyzer.py system_data.json
   ```
   - Scores each category 0-100 (100=excellent, 0=critical)
   - Produces prioritized reduction plan with estimated effort
   - Identifies which debt is blocking velocity, reliability, or hiring
3. **Interpret results and identify root causes** - Understand debt landscape
   - Critical debt (score <40): Must address immediately (blocking scaling/reliability)
   - High debt (40-60): Needs attention next quarter (affecting efficiency)
   - Medium debt (60-80): Tactical improvements (quality enhancements)
   - Emerging debt (80+): Well-managed, preventive focus
   - Root cause analysis: Why did debt accumulate? Speed over quality, architectural limitation, team growth?
4. **Develop quarterly reduction strategy** - Create actionable paydown plan
   - Tier 1 (Critical): Allocate 10-15% engineering capacity, target 2-sprint completion
   - Tier 2 (High): Allocate 5-10% engineering capacity, target next quarter
   - Tier 3 (Medium): Allocate 2-5% engineering capacity, target next half year
   - Balance: Don't allocate >20% to debt without impacting feature delivery
5. **Create executive business case** - Present with impact analysis
   - Current impact: How is debt affecting velocity, reliability, hiring, or product?
   - Financial impact: Cost of incidents, developer productivity loss, hiring difficulty?
   - Paydown investment: How many engineer-months and cost?
   - Expected benefits: Faster deployments, fewer bugs, easier hiring, better retention?
   - Timeline: How many quarters to address critical debt?
   - See [references/templates.md](references/templates.md) for executive presentation template
6. **Get leadership approval and allocation** - Secure commitment to plan
   - Present to CTO, VP Engineering, and CFO
   - Get committed budget and engineer allocation
   - Set quarterly targets and review cadence

**Expected Output:** Quantified technical debt landscape with severity scores, prioritized reduction roadmap, business case for investment, and leadership-approved engineering allocation for debt paydown. Engineering team has clear guidance on what to fix first.

See [references/tools.md](references/tools.md) for detailed tech debt analyzer documentation, scoring methodology, and reduction planning.

### Workflow 2: Plan Engineering Team Scaling

**Time:** 3-4 hours (analysis and planning)

**Steps:**
1. **Assess current team state** - Establish baseline for scaling decisions
   - Headcount by discipline: Frontend, backend, QA, DevOps, data engineers, etc.
   - Seniority distribution: % junior, mid, senior, staff engineers
   - Current velocity and throughput (story points/sprint)
   - Attrition rate and retention trends (% turnover annually)
   - Skill gaps: Missing expertise, bottleneck persons, weak areas
   - Geographic distribution and time zone coverage
   - Current hiring velocity (people hired per month)
2. **Define business-driven scaling needs** - Understand what growth requires
   - Revenue growth targets: How much larger is business in 12-24 months?
   - Feature roadmap: How many new products, features, or services?
   - Platform initiatives: Architecture changes, tech debt paydown, infrastructure modernization?
   - Capability expansion: New skills needed (AI/ML, security, data, mobile)?
   - Quality improvements: Need for QA, DevOps, site reliability engineers?
3. **Run team scaling calculator** - Calculate optimal hiring plan
   ```bash
   python scripts/team_scaling_calculator.py team_data.json
   ```
   - Outputs: Recommended team size, hiring plan by quarter, budget projections
   - Models: Conservative (10% growth/quarter), Steady (20% growth/quarter), Aggressive (40% growth/quarter)
   - Factors: Historical hiring velocity, onboarding ramp time, market competition, budget constraints
4. **Evaluate scenarios and pick growth strategy** - Make informed choice
   - Conservative (slow scale): Low hiring risk, easier onboarding, may constrain growth
   - Steady (moderate scale): Balanced growth and risk, sustainable long-term
   - Aggressive (fast scale): Enables rapid growth but high coordination/onboarding overhead
   - Trade-offs: Speed to market vs quality vs team stability
   - Review budget impact, cash runway, and hiring market feasibility
5. **Design team organization structure** - Plan the team for growth
   - Squad/team count: 1 squad (10 people), 2 squads (20 people), etc.
   - Leadership model: Engineering manager per squad, tech lead structure
   - Team missions: Backend squad, frontend squad, infrastructure squad, etc.
   - Cross-functional dependencies: Shared platforms, data, or services?
   - Onboarding infrastructure: Mentoring, bootcamps, documentation needed?
6. **Create hiring and budget plan** - Execute scaled growth
   - Quarterly hiring targets (Q1: 2 engineers, Q2: 3 engineers, Q3: 4 engineers)
   - Roles to recruit: Mix of junior, mid, senior by team need
   - Compensation bands and budget total
   - Sourcing strategy: Referrals, agencies, direct recruitment, universities?
   - Onboarding plan: Bootcamp, buddy system, ramp-up timeline
   - Retention strategy: Career development, promotion paths, compensation reviews
7. **Present to board and secure approval** - Get executive buy-in
   - Show connection between team growth and business impact
   - Budget approved: Total cost of planned hiring
   - Hiring authority: Authority to approve hires per role/quarter
   - Runway impact: Does hiring fit with cash constraints?

**Expected Output:** Detailed engineering hiring plan with quarterly targets by role, team organization design, budget projections, and board-approved hiring authority. Organization can execute growth strategy with clear goals and constraints.

See [references/tools.md](references/tools.md) for team scaling calculator documentation, scenario analysis examples, budget modeling, and risk assessment.

### Workflow 3: Make Architecture Decisions Using ADR Process

**Time:** 1-2 weeks from proposal to decision

**Steps:**
1. **Identify architecture decision point** - When to formally decide
   - New system/service design: Microservice vs monolith vs serverless?
   - Technology selection: Database (PostgreSQL vs MongoDB), language, framework
   - Integration approach: API-first, event-driven, batch processing, real-time streaming?
   - Data strategy: Schema design, replication, backup, disaster recovery?
   - Migration initiative: Cloud migration, platform changes, major refactoring?
2. **Research and evaluate options** - Systematic evaluation of alternatives
   - List 2-3 viable options (always include status quo)
   - For each option: Pros/cons, effort to implement, long-term maintenance, cost, risk
   - Prototype or spike if decision is critical and uncertain
   - Gather input: Team technical discussion, stakeholder concerns, security/compliance review
3. **Create Architecture Decision Record (ADR)** - Document using template
   - Status: Proposed (being evaluated), Accepted (decided), Deprecated (no longer used), Superseded (replaced)
   - Context: What problem are we solving? Business drivers? Technical constraints?
   - Decision: Which option did we choose and why?
   - Consequences: Positive and negative trade-offs of chosen approach
   - Alternatives considered: Why we didn't choose other options
   - See [references/templates.md](references/templates.md) for ADR template
4. **Get stakeholder buy-in** - Review and approval process
   - Architecture review board: Senior engineers discuss, challenge assumptions, approve
   - Engineering team: Broader discussion, concerns, implementation questions
   - Security/compliance: Ensure meets standards, no vulnerabilities introduced
   - Executive review: If impacts budget, timeline, or strategy
   - Document approvals and who signed off
5. **Communicate decision widely** - Announce and build shared understanding
   - Share ADR with full engineering organization
   - Update architecture documentation (diagrams, decision log, runbooks)
   - Conduct tech talk or workshop explaining decision
   - Q&A session for concerns or questions
6. **Execute and monitor implementation** - Track decision outcome
   - Project team implements architecture per ADR
   - Validate: Is the system performing as expected? Trade-offs real?
   - Adjust: If assumptions were wrong, document lessons and potential revisions
   - Review periodically (quarterly or at 6 month mark)
   - Maintain ADR as living document

**Expected Output:** Formalized architecture decision with clear rationale, stakeholder consensus, and implementation plan. Organization learns from decisions, documentation becomes reference for future similar decisions.

See [references/frameworks.md](references/frameworks.md) for architecture governance patterns, design review checklists, and technology evaluation frameworks.

### Workflow 4: Establish DORA Metrics and Engineering Excellence

**Time:** 4-6 weeks for implementation, ongoing monitoring

**Steps:**
1. **Understand DORA metrics framework** - The 4 key engineering performance indicators
   - **Deployment Frequency:** How often do we deploy to production? (Target: Daily or on-demand, Elite: >1/day, High: 1/week, Medium: 1/month)
   - **Lead Time for Changes:** From code commit to production deploy? (Target: <1 day, Elite: <1 day, High: <1 week, Medium: <1 month)
   - **Mean Time to Recovery (MTTR):** How fast do we recover from production incidents? (Target: <1 hour, Elite: <1 hour, High: <4 hours, Medium: <1 day)
   - **Change Failure Rate:** What % of production changes cause incidents? (Target: <15%, Elite: <15%, High: 15-30%, Medium: 30-45%)
2. **Baseline current state** - Measure where we are today
   - Deployment frequency: Review last 3-6 months of Git commits, releases, deployments
   - Lead time: Measure time from commit to production using Git/CI/CD pipeline
   - Recovery time: Review incident data (PagerDuty, on-call logs) for MTTR
   - Failure rate: Incidents caused by deployments vs total incidents
   - Tools: Git logs, CI/CD pipeline data, incident tracking, APM/monitoring
3. **Set ambitious targets** - Define where we want to be
   - Elite level: Daily deployments, <1 day lead time, <1 hour recovery, <15% failure rate
   - High level: Weekly+ deployments, <1 week lead time, <4 hour recovery, <30% failure rate
   - Current state + 20-30% quarterly improvement targets
   - Tailor to business criticality (SaaS = higher availability, B2B = more conservative)
4. **Identify improvement initiatives** - What changes will move metrics?
   - If lead time is long → Continuous integration bottlenecks, review process slow, complex builds
   - If deployment frequency is low → Manual processes, complex releases, fear of deploying (test/quality gaps)
   - If recovery time is slow → Lack of runbooks, slow diagnosis, manual rollback processes
   - If failure rate is high → Insufficient testing, staging gaps, lack of monitoring/alerts
5. **Implement improvements** - Execute concrete changes
   - CI/CD: Faster builds (parallelization, caching), automated testing gates, progressive deployment
   - Testing: Better test coverage (unit, integration, E2E), automated quality gates, staging environment parity
   - Process: Trunk-based development, feature flags for safe deployments, automated rollback capability
   - Monitoring: Better observability (logs, traces, metrics), alert tuning, incident playbooks
   - Culture: On-call training, blameless post-mortems, learning from incidents
6. **Measure and report progress** - Track metrics monthly
   - Dashboard: Real-time DORA metrics visible to team
   - Monthly review: Are metrics trending toward targets? Which initiatives are working?
   - Root cause analysis: If metric regressed, what happened? (Incident spike, team changes, new complexity)
   - Report to leadership: Show correlation between metrics and business outcomes (delivery speed, reliability, customer satisfaction)
   - Celebrate wins: Highlight improvements, acknowledge effort
7. **Maintain and evolve continuously** - Ongoing improvement cycle
   - Quarterly review: Adjust targets as we improve, new baseline setting
   - Major initiatives: Cloud migration, architecture change, new product may temporarily impact metrics
   - New practices: Incorporate learnings, improve processes
   - Benchmark: Compare against industry standards, peer companies, historical trends
   - Iterate: Continuous improvement mindset, test changes, measure impact

**Expected Output:** Defined DORA metrics with baseline measurements, improvement initiatives underway, automated dashboards for visibility, and clear targets. Engineering team focused on operational excellence. Leadership sees correlation between engineering metrics and business outcomes.

See [references/frameworks.md](references/frameworks.md) for detailed DORA implementation guide, improvement patterns, industry benchmarks, and red flag indicators.

## Overview

The CTO Advisor skill provides comprehensive frameworks, tools, and templates for technical leadership excellence. It combines technology strategy methodologies, team scaling frameworks, architecture governance patterns, and engineering metrics to support CTOs in building world-class engineering organizations.

This skill addresses the full scope of CTO responsibilities: defining technology vision and roadmap, scaling engineering teams effectively, establishing architecture standards, managing vendor relationships, and driving engineering excellence through metrics and culture. All content is designed for immediate application in quarterly planning, architecture reviews, hiring initiatives, and engineering transformation programs.

## Core Capabilities

**Technology Strategy & Planning**
- 3-5 year technology vision development
- Quarterly roadmap planning and execution
- Innovation management frameworks
- Technical debt assessment and reduction
- Python-based tech debt analyzer tool

**Team Scaling & Development**
- Engineering team scaling strategies
- Hiring velocity and pipeline planning
- Performance management frameworks
- Engineering culture building
- Python-based team scaling calculator

**Architecture Governance**
- Architecture Decision Records (ADR) templates
- Technology standards and guidelines
- System design review processes
- Vendor evaluation frameworks
- Build vs buy analysis

**Engineering Excellence**
- DORA metrics implementation
- Quality metrics tracking
- Team health indicators
- Incident management processes
- Post-mortem frameworks

**Stakeholder Management**
- Board and executive reporting
- Cross-functional partnerships
- Strategic initiative planning
- Crisis management playbooks
- Communication templates

## Quick Start

### Technical Debt Assessment

```bash
# Analyze technical debt across 5 categories with prioritized reduction plan
python scripts/tech_debt_analyzer.py system_data.json

# Generate JSON output for executive dashboards
python scripts/tech_debt_analyzer.py system_data.json --output json -f debt_report.json

# View help and input schema
python scripts/tech_debt_analyzer.py --help
```

See [references/tools.md](references/tools.md) for detailed tool documentation, scoring guidelines, and reduction planning.

### Team Scaling Planning

```bash
# Calculate optimal hiring plan, team structure, and budget projections
python scripts/team_scaling_calculator.py team_data.json

# Generate JSON output for board planning
python scripts/team_scaling_calculator.py team_data.json --output json -f scaling_plan.json

# View help and input schema
python scripts/team_scaling_calculator.py --help
```

See [references/tools.md](references/tools.md) for scenario examples, budget estimation, and risk assessment guidance.

## Key Workflows

### 1. Conduct Technical Debt Assessment

**Time:** 2-4 hours for comprehensive analysis

1. **Gather System Data** - Collect technical debt across all categories
   - Code quality metrics (test coverage, complexity, duplication)
   - Infrastructure issues (outdated dependencies, security vulnerabilities)
   - Architecture debt (tight coupling, missing abstractions)
   - Documentation gaps (missing or outdated docs)
   - Testing coverage (unit, integration, E2E test gaps)

2. **Run Tech Debt Analyzer** - Generate prioritized reduction plan
   ```bash
   python scripts/tech_debt_analyzer.py system_data.json
   ```

3. **Review Analysis** - Examine debt categorization and severity scores
   - Critical debt (blocks features or causes incidents)
   - High priority (impacts velocity or quality)
   - Medium priority (technical quality improvements)
   - Low priority (nice-to-have improvements)

4. **Create Reduction Roadmap** - Plan quarterly debt paydown
   - Allocate 10-20% of engineering capacity to debt reduction
   - Prioritize by risk and business impact
   - Set measurable targets (test coverage, incident reduction)

**Expected Output:** Prioritized technical debt inventory with quarterly reduction plan and capacity allocation recommendations.

### 2. Plan Engineering Team Scaling

**Time:** 3-5 hours for comprehensive planning

1. **Assess Current State** - Analyze team structure and capacity
   - Current headcount by role and seniority
   - Team velocity and throughput metrics
   - Skills gaps and hiring needs
   - Budget constraints and runway

2. **Run Team Scaling Calculator** - Generate hiring plan and budget projections
   ```bash
   python scripts/team_scaling_calculator.py team_data.json
   ```

3. **Evaluate Recommendations** - Review optimal team structure
   - Hiring velocity and pipeline requirements
   - Team composition (IC vs. leadership ratios)
   - Budget impact and runway implications
   - Risk assessment (key person dependencies, burnout indicators)

4. **Build Execution Plan** - Create quarterly hiring roadmap
   - Prioritize critical roles (engineering managers, senior ICs)
   - Establish hiring pipelines and sourcing strategies
   - Plan onboarding and ramp-up timelines
   - Set retention and culture preservation strategies

**Expected Output:** Data-driven hiring plan with budget projections, team structure recommendations, and execution timeline.

### 3. Make Architecture Decision (ADR Process)

**Time:** 1-2 weeks from proposal to decision

1. **Identify Decision Point** - Define architecture challenge or technology choice
   - Business context and requirements
   - Technical constraints and trade-offs
   - Stakeholder needs and concerns
   - Timeline and urgency

2. **Research Options** - Evaluate alternatives systematically
   - List all viable options (including status quo)
   - Assess pros/cons for each option
   - Prototype or spike if needed
   - Gather team and stakeholder input

3. **Create ADR** - Document decision using template from [references/templates.md](references/templates.md)
   - Status: Proposed/Accepted/Deprecated/Superseded
   - Context: Problem statement and business drivers
   - Decision: Chosen approach and rationale
   - Consequences: Positive and negative impacts

4. **Review and Approve** - Get stakeholder buy-in
   - Architecture review board discussion
   - Engineering team feedback
   - Security and compliance review
   - Executive approval if budget/strategy impact

5. **Communicate and Execute** - Announce decision and track implementation
   - Share ADR with engineering organization
   - Update architecture documentation
   - Track implementation progress
   - Review decision after 6-12 months

**Expected Output:** Formalized ADR with clear rationale, stakeholder alignment, and implementation plan.

### 4. Establish Engineering Metrics (DORA Implementation)

**Time:** 2-4 weeks for initial setup, ongoing monitoring

1. **Select Metrics Framework** - Choose appropriate metrics for org maturity
   - DORA metrics (deployment frequency, lead time, MTTR, change fail rate)
   - Quality metrics (test coverage, bug rates, technical debt)
   - Team health (satisfaction, retention, velocity)
   - Business impact (feature adoption, customer satisfaction)

2. **Instrument Data Collection** - Set up automated tracking
   - CI/CD pipeline metrics (GitHub Actions, CircleCI)
   - Incident management data (PagerDuty, Opsgenie)
   - Code quality tools (SonarQube, CodeClimate)
   - Survey tools for team health (Culture Amp, Officevibe)

3. **Build Dashboards** - Create executive and team-level views
   - Real-time DORA metrics dashboard
   - Quarterly trend analysis
   - Team-specific performance views
   - Benchmarking against industry standards

4. **Establish Targets** - Set improvement goals
   - Elite performers: Deploy frequency >1/day, lead time <1 day, MTTR <1 hour, change fail rate <15%
   - High performers: Deploy frequency 1/week, lead time <1 week, MTTR <1 day, change fail rate <30%
   - Current state baseline and quarterly improvement targets

5. **Review and Iterate** - Monthly metric reviews with leadership
   - Identify trends and anomalies
   - Celebrate wins and improvements
   - Address regression areas
   - Refine metrics based on learnings

**Expected Output:** Automated DORA metrics dashboard with quarterly improvement targets and executive reporting cadence.

## Python Tools

### tech_debt_analyzer.py

Analyzes technical debt across 5 categories with severity scoring and prioritized reduction recommendations.

**Key Features:**
- Multi-category debt assessment (code quality, infrastructure, architecture, documentation, testing)
- Severity scoring (0-100 scale with critical/high/medium/low classification)
- Impact analysis (velocity, quality, incident risk)
- Prioritized reduction roadmap with effort estimates
- JSON and human-readable output formats
- Capacity planning recommendations (10-20% allocation guidance)

**Common Usage:**
```bash
# Basic analysis
python scripts/tech_debt_analyzer.py system_data.json

# Generate JSON output for executive dashboards
python scripts/tech_debt_analyzer.py system_data.json --output json -f debt_report.json

# View input schema and examples
python scripts/tech_debt_analyzer.py --help
```

**Use Cases:**
- Quarterly technical debt assessments for executive planning
- Budget justification for engineering quality initiatives
- Risk assessment before major product launches
- New CTO onboarding to understand inherited debt

See [references/tools.md](references/tools.md) for input format specifications, scoring algorithms, and integration examples.

### team_scaling_calculator.py

Calculates optimal hiring plans, team structure recommendations, and budget projections for engineering organizations.

**Key Features:**
- Hiring velocity modeling based on growth targets
- Team composition recommendations (IC vs. manager ratios by org size)
- Budget projections with salary bands by role and location
- Risk assessment (key person dependencies, burnout indicators)
- Scenario planning (conservative, moderate, aggressive growth)
- JSON and human-readable output formats
- Runway impact analysis

**Common Usage:**
```bash
# Basic team scaling analysis
python scripts/team_scaling_calculator.py team_data.json

# Generate JSON output for board planning
python scripts/team_scaling_calculator.py team_data.json --output json -f scaling_plan.json

# View input schema and examples
python scripts/team_scaling_calculator.py --help
```

**Use Cases:**
- Annual and quarterly hiring planning
- Board-level budget discussions
- Fundraising planning (runway and hiring velocity modeling)
- Organization design and restructuring initiatives
- New CTO transition planning (understanding team structure needs)

See [references/tools.md](references/tools.md) for input format specifications, calculation methodologies, and scenario examples.

## Reference Materials

All detailed frameworks, templates, and tool documentation have been organized into focused reference files:

### [Technical Leadership Frameworks](references/frameworks.md)
- Technology strategy and roadmap development
- Innovation management frameworks
- Technical debt assessment strategies
- Team scaling and structure patterns
- Performance management systems
- Architecture governance (ADRs)
- Technology evaluation frameworks
- Vendor relationship management
- DORA and quality metrics
- Crisis management playbooks
- Stakeholder reporting frameworks
- Strategic initiatives (cloud, AI/ML, platform)

### [Communication Templates](references/templates.md)
- Weekly CTO schedule template
- Technology strategy presentation
- Team all-hands structure
- Board update email format
- ADR (Architecture Decision Record) template
- Incident post-mortem template
- Technology evaluation scorecard
- Engineering team OKR template
- Hiring scorecard template
- 1-on-1 meeting template

### [Python Tools Guide](references/tools.md)
- Tech debt analyzer comprehensive documentation
- Team scaling calculator detailed guide
- Input format specifications and examples
- Output interpretation guidelines
- Integration workflow examples
- Best practices and troubleshooting
- Real-world scenario examples
- Data privacy and security notes

## Success Indicators

**Technical Excellence**
- System uptime >99.9%
- Deploy frequency >1 per day
- Technical debt <10% capacity allocation
- Zero critical security incidents
- Lead time for changes <1 day

**Team Success**
- Team satisfaction score >8/10
- Voluntary attrition <10% annually
- Key positions filled >90%
- Diversity metrics improving
- Internal promotion rate >30%

**Business Impact**
- Features delivered on-time >80%
- Engineering enables revenue growth
- Cost per transaction decreasing
- Innovation driving competitive advantage
- Customer-reported issues declining

## Red Flags

- Technical debt increasing quarter-over-quarter
- Attrition rate rising above 15%
- Sprint velocity declining consistently
- Production incidents increasing
- Team morale scores dropping
- Budget overruns (>10% variance)
- Vendor lock-in concerns growing
- Security vulnerabilities accumulating
