# How to Use the Senior Ml Engineer Skill

## Quick Start

Hey Claude—I just added the "senior-ml-engineer" skill. Can you analyze my current codebase?

## Example Invocations

### Example 1: Basic Usage
```
Hey Claude—I just added the "senior-ml-engineer" skill. Can you analyze my current codebase?
```

### Example 2: Specific Workflow
```
Hey Claude—I just added the "senior-ml-engineer" skill. Can you help me with ml model deployment to production?
```

### Example 3: Integration with Other Skills
```
Hey Claude—I just added the "senior-ml-engineer" skill. Can you use it together with related skills to deliver a complete solution?
```

## What to Provide

When using this skill, provide:

- **Problem Statement**: What you want to achieve with ML/AI
- **Dataset** (optional): Available data or data collection approach
- **Constraints** (optional): Compute resources, latency requirements

## What You'll Get

This skill will provide:

- **Model Recommendations**: Suggested algorithms and architectures
- **Implementation Plan**: Step-by-step development approach
- **Evaluation Strategy**: Metrics and validation approaches
- **Automated Tools**: 3 Python scripts for data processing and analysis

## Python Tools Available

This skill includes the following Python tools:

- **ml_monitoring_suite.py**: Ml Monitoring Suite
- **model_deployment_pipeline.py**: Model Deployment Pipeline
- **rag_system_builder.py**: Rag System Builder

You can run these tools directly:

```bash
python skills/engineering-team/senior-ml-engineer/scripts/ml_monitoring_suite.py --help
```

## Tips for Best Results

1. **Be Specific**: Provide clear, detailed requirements for better results
2. **Provide Context**: Include relevant background information about your project
3. **Iterate**: Start with a focused request, then refine based on initial results
4. **Combine Skills**: This skill works well with other engineering skills for comprehensive solutions

## Related Skills

Consider using these skills together:

- **[Senior Security](../../engineering-team/senior-security/)**: Complementary expertise for senior security tasks
- **[Senior Frontend](../../engineering-team/senior-frontend/)**: Complementary expertise for senior frontend tasks
- **[Senior Secops](../../engineering-team/senior-secops/)**: Complementary expertise for senior secops tasks

---

**Skill**: senior-ml-engineer
**Domain**: engineering-team
**Version**: 1.0.0
**Last Updated**: 2025-11-23
