# How to Use the Content Creator Skill

## Quick Start

Hey Claude—I just added the "content-creator" skill. Can you create SEO-optimized content?

## Example Invocations

### Example 1: Basic Usage
```
Hey Claude—I just added the "content-creator" skill. Can you create SEO-optimized content?
```

### Example 2: Specific Workflow
```
Hey Claude—I just added the "content-creator" skill. Can you help me with establish brand voice?
```

### Example 3: Integration with Other Skills
```
Hey Claude—I just added the "content-creator" skill. Can you use it together with related skills to deliver a complete solution?
```

## What to Provide

When using this skill, provide:

- **Content Brief**: Topic, audience, goals
- **Brand Context** (optional): Brand voice, messaging guidelines
- **Requirements** (optional): Length, format, SEO keywords

## What You'll Get

This skill will provide:

- **Content**: Polished copy aligned with brand voice
- **SEO Optimization**: Keyword integration, meta descriptions
- **Performance Metrics**: Analytics setup and tracking recommendations
- **Automated Tools**: 2 Python scripts for data processing and analysis

## Python Tools Available

This skill includes the following Python tools:

- **brand_voice_analyzer.py**: Brand Voice Analyzer - Analyzes content to establish and maintain brand voice consistency
- **seo_optimizer.py**: SEO Content Optimizer - Analyzes and optimizes content for SEO

You can run these tools directly:

```bash
python skills/marketing-team/content-creator/scripts/brand_voice_analyzer.py --help
```

## Tips for Best Results

1. **Be Specific**: Provide clear, detailed requirements for better results
2. **Provide Context**: Include relevant background information about your project
3. **Iterate**: Start with a focused request, then refine based on initial results
4. **Combine Skills**: This skill works well with other marketing skills for comprehensive solutions

## Related Skills

Consider using these skills together:

- **[Marketing Strategy Pmm](../../marketing-team/marketing-strategy-pmm/)**: Complementary expertise for marketing strategy pmm tasks
- **[Marketing Demand Acquisition](../../marketing-team/marketing-demand-acquisition/)**: Complementary expertise for marketing demand acquisition tasks
- **[Scrum Master](../../delivery-team/scrum-master/)**: Complementary expertise for scrum master tasks

---

**Skill**: content-creator
**Domain**: marketing-team
**Version**: 1.0.0
**Last Updated**: 2025-11-08
