# How to Use the Marketing Strategy Pmm Skill

## Quick Start

Hey Claude—I just added the "marketing-strategy-pmm" skill. Can you plan a demand generation campaign?

## Example Invocations

### Example 1: Basic Usage
```
Hey Claude—I just added the "marketing-strategy-pmm" skill. Can you plan a demand generation campaign?
```

### Example 2: Specific Workflow
```
Hey Claude—I just added the "marketing-strategy-pmm" skill. Can you help me with define product positioning?
```

### Example 3: Integration with Other Skills
```
Hey Claude—I just added the "marketing-strategy-pmm" skill. Can you use it together with related skills to deliver a complete solution?
```

## What to Provide

When using this skill, provide:

- **Product Context**: Product vision, target users
- **Goals** (optional): What you want to achieve
- **Constraints** (optional): Timeline, resources, market conditions

## What You'll Get

This skill will provide:

- **Content**: Polished copy aligned with brand voice
- **SEO Optimization**: Keyword integration, meta descriptions
- **Performance Metrics**: Analytics setup and tracking recommendations
- **Automated Tools**: 2 Python scripts for data processing and analysis

## Python Tools Available

This skill includes the following Python tools:

- **competitor_tracker.py**: Competitor Tracker - Competitive Intelligence Analysis
- **win_loss_analyzer.py**: Win/Loss Analyzer - Deal Analysis and Insights

You can run these tools directly:

```bash
python skills/marketing-team/marketing-strategy-pmm/scripts/competitor_tracker.py --help
```

## Tips for Best Results

1. **Be Specific**: Provide clear, detailed requirements for better results
2. **Provide Context**: Include relevant background information about your project
3. **Iterate**: Start with a focused request, then refine based on initial results
4. **Combine Skills**: This skill works well with other marketing skills for comprehensive solutions

## Related Skills

Consider using these skills together:

- **[Content Creator](../../marketing-team/content-creator/)**: Complementary expertise for content creator tasks
- **[Marketing Demand Acquisition](../../marketing-team/marketing-demand-acquisition/)**: Complementary expertise for marketing demand acquisition tasks
- **[Scrum Master](../../delivery-team/scrum-master/)**: Complementary expertise for scrum master tasks

---

**Skill**: marketing-strategy-pmm
**Domain**: marketing-team
**Version**: 1.0.0
**Last Updated**: 2025-11-08
