---

# === CORE IDENTITY ===
name: marketing-strategy-pmm
title: Marketing Strategy Pmm Skill Package
description: Product marketing, positioning, GTM strategy, and competitive intelligence. Includes ICP definition, April Dunford positioning methodology, launch playbooks, competitive battlecards, and international market entry guides. Use when developing positioning, planning product launches, creating messaging, analyzing competitors, entering new markets, enabling sales, or when user mentions product marketing, positioning, GTM, go-to-market, competitive analysis, market entry, or sales enablement.
domain: marketing
subdomain: product-marketing-general

# === WEBSITE DISPLAY ===
difficulty: intermediate
time-saved: "TODO: Quantify time savings"
frequency: "TODO: Estimate usage frequency"
use-cases:
  - Primary workflow for Marketing Strategy Pmm
  - Analysis and recommendations for marketing strategy pmm tasks
  - Best practices implementation for marketing strategy pmm
  - Integration with related skills and workflows

# === RELATIONSHIPS ===
related-agents: []
related-skills: []
related-commands: []
orchestrated-by: []

# === TECHNICAL ===
dependencies:
  scripts: []
  references: []
  assets: []
compatibility:
  python-version: 3.8+
  platforms: [macos, linux, windows]
tech-stack:
  - HubSpot CRM
  - Google Analytics
  - Gong/Chorus
  - Productboard
  - Notion
  - Confluence
  - Competitive intelligence tools
  - Python 3.8+

# === EXAMPLES ===
examples:
  -
    title: Example Usage
    input: "TODO: Add example input for marketing-strategy-pmm"
    output: "TODO: Add expected output"

# === ANALYTICS ===
stats:
  downloads: 0
  stars: 0
  rating: 0.0
  reviews: 0

# === VERSIONING ===
version: v1.0.0
author: Claude Skills Team
contributors: []
created: 2025-10-20
updated: 2025-11-08
license: MIT

# === DISCOVERABILITY ===
tags: [analysis, marketing, pmm, product, strategy]
featured: false
verified: true
---

# Marketing Strategy & Product Marketing

Expert Product Marketing playbook for Series A+ startups expanding internationally with hybrid PLG/Sales-Led motion.

## Overview

This skill provides comprehensive frameworks for positioning, messaging, competitive intelligence, and go-to-market strategy. Built for product marketers and marketing leaders at B2B SaaS companies, it includes the April Dunford positioning methodology, battle-tested launch playbooks, and international expansion guides.

**Core Value:** Define clear positioning, enable sales teams, and execute launches that generate 3:1 ROMI while scaling across international markets.

## Core Capabilities

- **Positioning & Messaging** - April Dunford methodology, value proposition development, persona-specific messaging
- **ICP Definition** - Ideal customer profile framework with firmographics, technographics, psychographics
- **Competitive Intelligence** - Battlecard creation, win/loss analysis, competitive tracking
- **Go-To-Market Strategy** - PLG, Sales-Led, and Hybrid motion frameworks
- **Product Launches** - Tier 1/2/3 launch playbooks with 8-week timelines
- **Sales Enablement** - Sales decks, demo scripts, battlecards, ROI calculators
- **International Expansion** - Market-specific GTM tactics for US, UK, DACH, France, Canada
- **Market Segmentation** - By company size, vertical, use case, and geography

## Role Coverage

This skill serves:
- **Product Marketing Manager (PMM)** - Positioning, messaging, competitive intel, launches
- **Head of Marketing** - Strategy, budget, org design, pipeline targets
- **Head of Growth** - Experimentation, activation, retention, growth loops
- **CMO/VP Marketing** - Executive strategy, board reporting, team leadership

## Core KPIs by Role

**PMM**: Product adoption rate, win rate vs. competitors, sales velocity, launch impact metrics, competitive win rate, deal size growth

**Head of Marketing**: Marketing-sourced pipeline $, CAC/LTV ratio, ROMI (3:1+ target), brand awareness lift, market share growth

**Head of Growth**: Activation rate, WAU/MAU, conversion rates across funnel, payback period, viral coefficient (PLG)

**CMO**: Revenue growth %, pipeline coverage (3-4x), team productivity, budget efficiency, NPS/brand health

## Quick Start

### Access Frameworks
- Positioning & strategy: [frameworks.md](references/frameworks.md)
- Launch templates & battlecards: [templates.md](references/templates.md)

## Key Workflows

### 1. Define Product Positioning

**Time:** 4-6 weeks

1. **Research (Week 1)** - Gather customer and market insights
   - Conduct 10-15 customer interviews
   - Analyze competitive landscape
   - Identify market trends

2. **Apply Framework (Week 2)** - Use April Dunford methodology
   - List competitive alternatives (direct + indirect + status quo)
   - Isolate unique attributes (what you have that others don't)
   - Map attributes to customer value
   - Define best-fit customers (who cares most)
   - Nail market category (head-to-head vs. niche vs. new)
   - Layer on market trends

3. **Build Messaging (Week 3)** - Create messaging hierarchy
   - Craft value proposition one-liner
   - Define 3-5 key benefits
   - Map features to benefits to outcomes
   - Develop proof points (logos, stats, case studies)

4. **Validate (Week 4)** - Test messaging with audiences
   - Test with sales team
   - A/B test on landing pages
   - Gather customer feedback
   - Refine based on results

5. **Rollout (Week 5-6)** - Deploy across organization
   - Update website and sales materials
   - Train sales and customer success teams
   - Launch campaigns with new messaging
   - Monitor performance metrics

See [frameworks.md](references/frameworks.md) for the complete April Dunford positioning framework.

### 2. Create Competitive Battlecards

**Time:** 2-3 hours per competitor

1. **Research Competitor** - Gather intelligence
   - Sign up for product trial and test features
   - Monitor website, pricing, messaging changes
   - Review G2/Capterra reviews (pros/cons)
   - Analyze sales call recordings (Gong/Chorus)
   - Track hiring and partnerships

2. **Build Battlecard** - Use template from [templates.md](references/templates.md)
   - Overview (funding, size, customers, pricing)
   - Positioning (their messaging vs. reality)
   - Key strengths (what they do well)
   - Key weaknesses (where they fall short)
   - Our advantages (why customers choose us)
   - When to win/lose scenarios
   - Talk tracks for common objections
   - Proof points (case studies, reviews, win rate)

3. **Distribute & Train** - Enable sales team
   - Store in Notion, Confluence, or sales platform
   - Host monthly competitive update calls
   - Update whenever competitor launches major feature

4. **Track Effectiveness** - Monitor competitive win rate
   - Win/loss analysis by competitor
   - Update battlecard based on learnings

See [templates.md](references/templates.md) for complete battlecard template.

### 3. Launch New Product or Feature

**Time:** 8 weeks for Tier 1 launch

1. **Planning (Week -8 to -5)** - Define strategy and create assets
   - Week -8: Kickoff, goals, positioning, messaging
   - Week -7: GTM strategy, sales enablement, content plan
   - Week -6: Landing pages, HubSpot setup, press release
   - Week -5: Beta testing, sales training, case studies

2. **Pre-Launch (Week -4 to -1)** - Build momentum
   - Week -4: Launch paid campaigns, teaser content
   - Week -3: A/B testing, content production, prospecting
   - Week -2: Email reminders, scale ads, final testing
   - Week -1: Final approval, VIP preview, team readiness

3. **Launch (Week 1)** - Execute launch day and monitor
   - Day 1: Press release, email blast, social media, ads live
   - Days 2-5: Daily monitoring, optimization, sales follow-up
   - Week 2: Analyze results, post-launch content, scale winners

4. **Post-Launch (Week 2-4)** - Optimize and iterate
   - Week 2: Deep funnel analysis, retargeting launch
   - Week 3: Mid-campaign report, budget reallocation
   - Week 4: Final report, win/loss analysis, plan next launch

See [templates.md](references/templates.md) for complete 8-week launch playbook and metrics dashboard.

### 4. Conduct Win/Loss Analysis

**Time:** 30-45 min per interview, monthly reporting

1. **Identify Deals** - Select closed won/lost from last 30 days
   - Prioritize competitive deals
   - Mix of wins and losses
   - Target 10-20 interviews per month

2. **Request Interview** - Send email via HubSpot workflow
   - Thank them for their time
   - Request 30-minute feedback call
   - Offer incentive if needed ($50 gift card)

3. **Conduct Interview** - Ask open-ended questions
   - For wins: Why us? What alternatives? What almost prevented you?
   - For losses: Why them? What could we have done differently?
   - Record with permission, take detailed notes

4. **Analyze Themes** - Track patterns across interviews
   - Use tracking spreadsheet (deal, outcome, reason, competitor)
   - Identify top win reasons (double down)
   - Identify top loss reasons (address in product/positioning)

5. **Share Insights** - Monthly report to stakeholders
   - Win rate and trends
   - Top win/loss reasons
   - Action items (product, sales, marketing)
   - Update battlecards based on learnings

See [frameworks.md](references/frameworks.md) for win/loss analysis framework and interview questions.

### 5. Enter New International Market

**Time:** 6-12 months per market

1. **Prioritize Market (Month 1)** - Choose entry order
   - US first (largest TAM, fastest cycles)
   - UK second (English-speaking, EU gateway)
   - DACH third (largest EU economy)
   - France fourth (requires full localization)
   - Canada fifth (similar to US, smaller market)

2. **Localize (Month 1-3)** - Adapt for market
   - Translate website and product
   - Localize pricing (currency, VAT)
   - Adapt messaging (cultural nuances)
   - Ensure legal compliance (GDPR, data privacy)

3. **Build GTM Motion (Month 2-4)** - Set up market infrastructure
   - Hire local sales reps or partner with agency
   - Set up local payment methods
   - Create local case studies and testimonials
   - Establish local partnerships

4. **Launch & Scale (Month 4-12)** - Execute and optimize
   - Launch paid ads targeting market
   - Content marketing in local language
   - Co-marketing with local partners
   - Monthly performance reviews
   - Scale budget based on CAC and pipeline

See [frameworks.md](references/frameworks.md) for complete international expansion framework with market-specific tactics.

## Python Tools

This skill currently has no Python automation tools. All capabilities are delivered through strategic frameworks, templates, and reference guides designed for product marketing and go-to-market planning.

**Why No Tools?**
Product marketing is primarily a strategic and creative discipline that relies on market insights, competitive intelligence, and stakeholder collaboration rather than algorithmic analysis. The frameworks and templates provided offer more value than automated tools for positioning, messaging, and GTM strategy work.

**Available Resources Instead:**
- Strategic frameworks in `references/frameworks.md`
- Ready-to-use templates in `references/templates.md`
- Integration with HubSpot, Gong, and other PMM tools

## Best Practices

### Positioning Strategy
- Start with customer interviews (10-15 minimum)
- Use April Dunford methodology (proven framework)
- Test messaging before full rollout
- Refresh quarterly based on market feedback
- Keep one-liner under 15 words

### Competitive Intelligence
- Update battlecards monthly (or when competitor launches)
- Review 5-10 G2/Capterra reviews per month per competitor
- Listen to competitive sales calls (Gong/Chorus)
- Sign up for competitor trials quarterly
- Track win rate by competitor in HubSpot

### Launch Execution
- Start planning 8 weeks before (Tier 1 launches)
- Set clear success metrics before launch
- Monitor daily for first week post-launch
- Conduct win/loss analysis 30 days after
- Document learnings for next launch

### Sales Enablement
- Monthly enablement calls with sales team
- Quarterly deep-dive training workshops
- Keep sales decks under 20 slides
- Demo scripts should be 30-45 minutes
- Update battlecards before every major competitive deal

See [frameworks.md](references/frameworks.md) for detailed frameworks and [templates.md](references/templates.md) for ready-to-use assets.

## Performance Benchmarks

**PMM Success Metrics:**
- Product adoption: >40% within 90 days of launch
- Sales velocity: Decrease by 20% YoY
- Competitive win rate: >30% (35%+ excellent)
- Deal size growth: +25% YoY
- Launch impact: 3:1 ROMI (pipeline $ : marketing spend)

**Launch Metrics (Tier 1):**
- MQLs: 200-500 within 30 days
- SQLs: 50-100 within 30 days
- Pipeline: $1M-$3M within 90 days
- Press coverage: 5-10 publications
- Customer adoption: 40%+ within 90 days

See [templates.md](references/templates.md) for launch metrics dashboard template.

## Reference Guides

### When to Use Each Reference

**[frameworks.md](references/frameworks.md)** - Strategic methodologies
- Positioning framework (April Dunford 6-step method)
- Messaging architecture (hierarchy, personas)
- ICP definition framework
- Market segmentation strategy
- Competitive intelligence sources and tracking
- Win/loss analysis process
- GTM motion types (PLG, Sales-Led, Hybrid)
- International market entry priorities
- Product launch tiers (1/2/3)
- Messaging testing approaches
- PMM metrics and KPIs

**[templates.md](references/templates.md)** - Ready-to-use assets
- Competitive battlecard template
- Sales enablement assets (deck, one-pagers, demo script)
- Product launch playbooks (8-week timeline)
- Launch metrics dashboard
- GTM 90-day plan
- Sales training templates
- Quarterly business review template
- PMM monthly checklist
- Positioning development timeline
- Team handoff protocols
- HubSpot reporting templates

## Integration

This skill works best with:
- HubSpot CRM (deal tracking, competitive loss analysis, sales enablement)
- Google Analytics (product usage, activation funnels, feature adoption)
- Gong/Chorus (sales call analysis, competitive intelligence, objection tracking)
- Productboard (feature requests, customer feedback, roadmap prioritization)
- Notion/Confluence (internal wiki, positioning docs, competitive battlecards)
- G2/Capterra (review monitoring, competitive analysis)

See [templates.md](references/templates.md) for HubSpot reporting setup and sales enablement workflows.

## Additional Resources

- **Frameworks:** [frameworks.md](references/frameworks.md)
- **Templates:** [templates.md](references/templates.md)
- **Assets:** `assets/` directory (sales decks, battlecards, calculators)

---

**Last Updated**: November 2025 | **Version**: 1.0
