# Product Marketing Frameworks

## 1. Positioning Framework (April Dunford Method)

### Step 1: List Your True Competitive Alternatives

Not just direct competitors - what would customers do if your product didn't exist?

```
Alternatives:
1. Competitor A (direct)
2. Competitor B (direct)
3. Spreadsheets + email (status quo)
4. Build in-house (DIY)
5. Do nothing (ignore problem)
```

### Step 2: Isolate Your Unique Attributes

What do you have that alternatives don't?

```
Unique Attributes:
1. [Feature X that no one else has]
2. [Integration Y that's exclusive]
3. [Approach Z that's differentiated]
4. [Performance metric better than all]
```

### Step 3: Map Attributes to Value

What value do these attributes provide to customers?

```
Attribute: [Real-time collaboration]
→ Value: Teams can work together simultaneously
→ Outcome: 50% faster project completion

Attribute: [AI-powered automation]
→ Value: Eliminates manual data entry
→ Outcome: Save 10 hours/week per user
```

### Step 4: Define Your Best-Fit Customers

Who cares most about this value?

```
Best-Fit: Mid-market SaaS companies (200-1000 employees)
Why: They have distributed teams, need real-time collaboration
Evidence: Fastest sales cycles, lowest churn, highest NPS
```

### Step 5: Nail Your Market Category

What market do you dominate?

```
Options:
- Head-to-head: Compete in existing category (e.g., "CRM")
- Big fish, small pond: Own a niche (e.g., "CRM for agencies")
- Create new: Define new category (risky, expensive)

Decision: [Choose based on competitive strength and budget]
```

### Step 6: Layer on Trends

What trends make this the right time to buy?

```
Trends:
- Remote work explosion (2020-2025)
- AI/ML adoption in enterprise (2024-2025)
- Data privacy regulations (GDPR, CCPA)
```

## 2. Messaging Architecture Framework

### Value Proposition (One-Liner)

Template: `[Product] helps [Target Customer] [Achieve Goal] by [Unique Approach]`

Example: "Acme helps mid-market SaaS teams ship 2x faster by automating project workflows with AI"

### Messaging Hierarchy

```
LEVEL 1: Value Proposition (one-liner)
[Your one-liner here]

LEVEL 2: Key Benefits (3-5 bullet points)
- Benefit 1: [Speed] → Ship products 2x faster
- Benefit 2: [Quality] → Reduce bugs by 50%
- Benefit 3: [Collaboration] → Align teams in real-time
- Benefit 4: [Cost] → Save $100k/year on tools

LEVEL 3: Features (supporting evidence)
- Feature → Benefit → Outcome
- AI automation → Eliminates manual work → Save 10 hrs/week
- Real-time sync → No version conflicts → 50% fewer errors
- Integrations → Connect existing tools → 80% faster onboarding

LEVEL 4: Proof Points
- Customer logos: [Microsoft, Shopify, Stripe]
- Stats: Used by 10,000+ teams, 4.8/5 G2 rating
- Case studies: How [Customer] achieved [Outcome]
```

### Messaging by Persona

**Economic Buyer** (VP/Director):
- Primary concern: ROI, business outcomes
- Tone: Professional, data-driven, results-focused
- Key message: "Increase revenue by 25% while reducing costs by $200k/year"
- Proof: ROI calculator, case studies with $ impact

**Technical Buyer** (Engineer/Architect):
- Primary concern: Technical fit, security, scalability
- Tone: Technical, detailed, objective
- Key message: "Enterprise-grade architecture with 99.99% uptime and SOC 2 compliance"
- Proof: Technical docs, security whitepaper, architecture diagram

**End User** (Manager/Individual Contributor):
- Primary concern: Ease of use, daily workflow
- Tone: Friendly, empathetic, practical
- Key message: "Spend less time on busywork, more time on what matters"
- Proof: Product demo, free trial, customer testimonials

## 3. ICP (Ideal Customer Profile) Framework

### B2B SaaS ICP Template

**Firmographics**:
- Company size: 50-5000 employees (Series A sweet spot)
- Industry: SaaS, Tech, Professional Services
- Geography: US, Canada, UK, Germany, France (prioritize by TAM)
- Revenue: $5M-$500M annual
- Funding stage: Seed to Growth (avoid pre-product)

**Technographics**:
- Tech stack: Modern (cloud-first, API-driven)
- Maturity: Growing fast, willing to adopt new tools
- Existing tools: [List competitors + complementary products]
- Integration needs: Must integrate with [Salesforce, Slack, etc.]

**Psychographics**:
- Pain level: 7-10/10 (acute pain, not nice-to-have)
- Buyer motivation: Efficiency, cost savings, revenue growth
- Decision process: 2-6 month sales cycle
- Risk tolerance: Early majority (not bleeding edge)

### Buyer Personas (3-5 personas max)

**Primary: Economic Buyer** (signs contract)
- Title: VP, Director, Head of [Department]
- Goals: ROI, team productivity, cost reduction
- Fears: Implementation failure, team resistance, budget waste
- Messaging: Business outcomes, ROI, case studies

**Secondary: Technical Buyer** (evaluates product)
- Title: Senior Engineer, Architect, Tech Lead
- Goals: Solves technical problem, easy integration
- Fears: Technical debt, vendor lock-in, poor support
- Messaging: Technical capabilities, architecture, security

**User/Champion** (advocates internally)
- Title: Manager, Team Lead, Power User
- Goals: Makes their job easier, team loves it
- Fears: Learning curve, change management
- Messaging: UX, ease of use, quick wins

### ICP Validation Checklist
- [ ] 5+ paying customers match this profile
- [ ] Fastest sales cycles (< median time to close)
- [ ] Highest LTV (> median customer value)
- [ ] Lowest churn (< 5% annual)
- [ ] Strong product engagement (daily/weekly usage)
- [ ] Referenceable (NPS 9-10, willing to do case studies)

### HubSpot ICP Tracking
- Create "ICP Fit" property: A (perfect), B (good), C (okay), D (poor)
- Score based on firmographics, engagement, product usage
- Report: Win rate by ICP score, pipeline by ICP score
- Action: Focus acquisition on ICP A/B, nurture C, disqualify D

## 4. Market Segmentation Framework

### Segmentation Dimensions

**By Company Size** (recommend starting with one):
- **SMB** (10-200 employees) - Self-serve PLG, low touch, $100-$2k ACV
- **Mid-Market** (200-2000 employees) - Hybrid, inside sales, $2k-$50k ACV
- **Enterprise** (2000+ employees) - Sales-led, field sales, $50k+ ACV

**By Vertical** (choose 2-3 focus verticals):
- Horizontal: Broad appeal (e.g., project management for any industry)
- Vertical: Industry-specific (e.g., healthcare CRM, fintech compliance)
- Approach: Start horizontal, add verticals as you scale

**By Use Case** (messaging varies):
- Use Case A: [e.g., Team collaboration]
- Use Case B: [e.g., Client management]
- Use Case C: [e.g., Project tracking]
- Each use case = different landing page, messaging, case studies

**By Geography** (Series A focus):
- **US/Canada**: Largest TAM, fastest sales cycles, highest willingness to pay
- **UK**: English-speaking, gateway to EU, similar buying behavior to US
- **Germany**: Largest EU economy, high data privacy standards (GDPR leader)
- **France**: Second largest EU market, localization critical
- **Nordics**: High tech adoption, English proficiency, smaller markets

### Segmentation Priority Matrix

```
Segment: US Mid-Market SaaS Companies (200-2000 employees)
Priority: 1 (Highest)
Rationale:
  - Largest TAM ($5B)
  - Fastest sales cycle (60 days avg)
  - Highest win rate (35%)
  - Strong product fit (use cases align)
  - Existing customer base (50% of customers)
Budget Allocation: 50% of marketing spend
```

## 5. Competitive Intelligence Framework

### Competitive Analysis Structure

**Tier 1: Direct Competitors** (head-to-head, same category)
- [Competitor A]: Market leader, $100M+ ARR
- [Competitor B]: Fast-growing challenger, Series B
- [Competitor C]: Open-source alternative

**Tier 2: Indirect Competitors** (adjacent solutions)
- [Alt Solution D]: Different approach, overlapping use case
- [Alt Solution E]: Broader platform, includes your feature

**Tier 3: Status Quo** (what customers do today)
- Spreadsheets + email
- Build in-house
- Do nothing

### Competitive Intelligence Sources

1. **Product trials**: Sign up for competitor products, use actively
2. **Website monitoring**: Track changes to pricing, messaging, features
3. **Customer interviews**: Ask "What alternatives did you consider?"
4. **Sales call recordings** (Gong/Chorus): Listen for competitor mentions
5. **Review sites** (G2, Capterra): Read competitor reviews (pros/cons)
6. **Job postings**: Competitor hiring = roadmap insights
7. **Financial filings** (if public): Revenue, growth, strategy
8. **Social media**: Follow competitor execs, product teams
9. **Partner channels**: Talk to shared implementation partners
10. **Industry reports**: Gartner, Forrester, IDC

## 6. Win/Loss Analysis Framework

### Win/Loss Interview Process

**Goals**:
- Understand why you won/lost
- Validate positioning and messaging
- Identify product gaps
- Track competitive trends

**Process**:
1. **Identify deals** (closed won or lost in last 30 days)
2. **Request interview** (email or HubSpot workflow)
3. **Conduct interview** (30-45 min, record with permission)
4. **Analyze data** (themes, patterns, trends)
5. **Share insights** (monthly report to product, sales, marketing)

### Interview Questions (pick 8-10)

**For Wins**:
- What problem were you trying to solve?
- What alternatives did you evaluate?
- Why did you choose us over [Competitor]?
- What almost made you choose someone else?
- What could we improve?

**For Losses**:
- What problem were you trying to solve?
- Who did you choose instead? Why?
- What did we do well in the sales process?
- What could we have done differently?
- Would you consider us in the future? When?

### Data Tracking (in HubSpot or spreadsheet)

| Deal | Outcome | Reason | Competitor | Price Factor | Product Gap | Messaging Issue |
|------|---------|--------|------------|--------------|-------------|-----------------|
| Acme Corp | Won | Best product fit | Competitor A | No | No | No |
| Beta Inc | Lost | Price | Competitor B | Yes | No | No |
| Gamma LLC | Lost | Missing feature X | Built in-house | No | Yes | No |

### Monthly Insights Report

```
Win/Loss Summary (March 2025):
- Total deals analyzed: 20 (12 wins, 8 losses)
- Win rate: 60%
- Top win reasons:
  1. Ease of use (8 mentions)
  2. Better support (6 mentions)
  3. Price (4 mentions)
- Top loss reasons:
  1. Missing feature X (4 mentions)
  2. Price (3 mentions)
  3. Competitor relationship (2 mentions)

Action Items:
- Product: Prioritize feature X (lost 4 deals)
- Sales: Update battlecard for Competitor A (won 5 competitive deals)
- Marketing: Create case study on "ease of use" theme
```

## 7. GTM (Go-To-Market) Motion Framework

### GTM Motion Types

**PLG (Product-Led Growth)**:
- Entry: Free trial or freemium
- Buyer: End user → Manager → VP
- Sales: Low touch or self-serve
- ACV: <$10k
- Example: Slack, Notion, Figma

**Sales-Led Growth**:
- Entry: Demo request → Sales qualification
- Buyer: VP → C-level
- Sales: High touch, consultative
- ACV: $25k+
- Example: Salesforce, Workday, SAP

**Hybrid (PLG + Sales)**:
- Entry: Free trial for SMB, demo for Enterprise
- Buyer: End user (PLG) or Executive (Sales-Led)
- Sales: Self-serve → Assisted → Enterprise
- ACV: $5k-$100k
- Example: HubSpot, Atlassian, Zoom

**Series A Recommendation**: Start with **Hybrid**
- Reason: Faster learning, broader TAM, efficient scaling
- Approach:
  - Bottom-up (PLG): Free trial → Paid team plan → Upgrade to Enterprise
  - Top-down (Sales): Outbound to Enterprise → Demo → POC → Close

## 8. International Market Entry Framework

### Market Entry Priority (Series A recommended order)

**Phase 1: US Market** (Months 1-6)
- Why: Largest TAM, fastest sales cycles, highest ACV
- Entry strategy:
  - Hire US-based SDRs/AEs (or partner with US sales agency)
  - Localize website (USD pricing, US phone number)
  - Paid ads (Google + LinkedIn) targeting US companies
  - Partnerships with US-based tech companies
- Budget: 50% of total marketing spend
- Target: $1M ARR from US by Month 6

**Phase 2: UK Market** (Months 4-9)
- Why: English-speaking, gateway to EU, similar to US
- Entry strategy:
  - Hire UK sales rep or partner with UK agency
  - Localize pricing (GBP), GDPR compliance
  - Content localization (British spelling, cultural nuances)
  - UK partnerships (local SaaS companies)
- Budget: 20% of marketing spend
- Target: $500k ARR from UK by Month 9

**Phase 3: DACH (Germany/Austria/Switzerland)** (Months 7-12)
- Why: Largest EU economy, high data privacy standards
- Entry strategy:
  - Translate website and product (German)
  - Hire German-speaking sales rep
  - GDPR compliance (critical for German market)
  - Partnerships with German tech companies
  - Local case studies and testimonials
- Budget: 15% of marketing spend
- Target: $300k ARR from DACH by Month 12

**Phase 4: France** (Months 10-15)
- Why: Second largest EU market, localization critical
- Entry strategy:
  - Full French translation (website, product, support)
  - Hire French-speaking sales and support
  - French partnerships and case studies
  - Comply with French data regulations
- Budget: 10% of marketing spend
- Target: $200k ARR from France by Month 15

**Phase 5: Canada** (Months 7-12)
- Why: Similar to US, easier entry, smaller market
- Entry strategy:
  - Minimal localization (CAD pricing)
  - Leverage US sales team (similar buying behavior)
  - Canadian partnerships
- Budget: 5% of marketing spend
- Target: $100k ARR from Canada by Month 12

### Localization Checklist (per market)

- [ ] **Website**: Translate, localize currency, phone number
- [ ] **Product**: UI translation (if needed for that market)
- [ ] **Pricing**: Local currency, VAT/taxes displayed
- [ ] **Support**: Local business hours, language support
- [ ] **Legal**: Data privacy compliance (GDPR, CCPA)
- [ ] **Sales**: Hire local reps or partner with local agency
- [ ] **Marketing**: Localized ads, content, case studies
- [ ] **Payments**: Local payment methods (SEPA, iDEAL, etc.)

### Budget Allocation (international expansion)

```
Year 1 (Series A):
- US: 50% ($200k)
- UK: 20% ($80k)
- DACH: 15% ($60k)
- France: 10% ($40k)
- Canada: 5% ($20k)

Total: $400k marketing spend (international)
Expected ROI: 3:1 (marketing-sourced pipeline : spend)
```

## 9. Product Launch Framework

### Launch Tiers (Effort vs. Impact)

**Tier 1: Major Launch** (quarterly, high impact)
- Scope: New product, major feature, platform expansion
- Audience: Existing customers + new prospects + press
- Effort: 6-8 weeks prep, full cross-functional launch
- Budget: $50k-$100k (Series A)
- Activities: Press release, webinar, email series, paid ads, sales blitz

**Tier 2: Standard Launch** (monthly, medium impact)
- Scope: Significant feature, integration, improvement
- Audience: Existing customers + select prospects
- Effort: 3-4 weeks prep, core team involvement
- Budget: $10k-$25k
- Activities: Blog post, email announcement, product update, sales enablement

**Tier 3: Minor Launch** (weekly, low impact)
- Scope: Small feature, bug fix, optimization
- Audience: Existing customers only
- Effort: 1 week prep, product + marketing only
- Budget: <$5k
- Activities: In-app notification, changelog, support docs

## 10. Messaging Testing Framework

### Message Testing Approaches

**1. Qualitative** (customer interviews):
- Ask 10-15 target customers:
- "How would you describe [Product] to a colleague?"
- "What's the main benefit you get from [Product]?"
- "Why did you choose us over [Competitor]?"

**2. Quantitative** (A/B testing):
- Test messaging variations on:
- Landing page headlines
- Ad copy (LinkedIn, Google)
- Email subject lines
- Measure: CTR, conversion rate, demo requests

**3. Sales Feedback** (win/loss analysis):
- Ask sales team monthly:
- "Which message resonates most with prospects?"
- "What objections are we hearing?"
- "How do we compare to [Competitor] in customer's eyes?"

### Iteration Cycle

- Test new messaging: 2-4 weeks
- Analyze results: 1 week
- Update messaging docs: 1 week
- Train sales team: 1 week
- Repeat quarterly

## 11. Strategic Foundation Framework

### Company Strategy (Series A Context)

**Current State Analysis**:
```
Stage: Series A
Funding: $5-15M raised
Team Size: 20-50 people
Revenue: $1-5M ARR
Market Position: Challenger/Niche leader
Growth Rate Target: 3-5x YoY

Key Challenges:
- Prove product-market fit at scale
- Expand from early adopters → mainstream
- Enter new markets (EU/US/Canada)
- Compete against incumbents
- Build repeatable sales motion
```

**Strategic Priorities** (in order):
1. **Nail positioning** - Clear, differentiated value prop
2. **Scale acquisition** - Repeatable, efficient channels
3. **Prove retention** - Product stickiness, expansion revenue
4. **Expand markets** - Geographic + vertical expansion
5. **Build brand** - Awareness, trust, category leadership

## 12. PMM Metrics Framework

### Core PMM KPIs (Track Monthly)

**Product Adoption**:
- % of customers using new feature (within 30 days of launch)
- Target: >40% adoption within 90 days

**Sales Velocity**:
- Days from SQL to closed won
- Target: Decrease by 20% YoY

**Win Rate**:
- % of opportunities won (vs. competitors)
- Target: >30% win rate (competitive deals)

**Deal Size**:
- Average contract value (ACV)
- Target: Increase by 25% YoY

**Launch Impact**:
- Pipeline $ generated from launch campaigns
- Target: 3:1 ROMI (pipeline $ : marketing spend)

**Competitive Win Rate**:
- % of deals won against Competitor A, B, C
- Target: >35% win rate vs. top competitor
