# Messaging Templates Reference Guide

## Overview
Comprehensive messaging frameworks and templates for translating product positioning into compelling customer-facing communications across all channels and buyer journey stages.

## Key Message Architecture

### Value Proposition Statement
**Template:**
[Product] helps [target customer] achieve [outcome] by [unique approach] unlike [alternative] which [shortcoming].

### Elevator Pitch (30 seconds)
**Structure:**
1. Hook (problem awareness): "You know how [pain point]?"
2. Solution (what you do): "We solve that by [approach]"
3. Proof (credibility): "[social proof or metric]"
4. CTA: "Let me show you how..."

### One-Liner (10 words or less)
Formula: [Outcome] for [who] via [differentiation]

## Messaging Framework by Persona

### Executive Buyer (C-Level)
**What they care about:** ROI, risk, strategic alignment
**Message focus:** Business outcomes, not features
**Proof points:** Revenue impact, efficiency gains, competitor wins

**Template:**
"[Product] helps [role] increase [business metric] by [%] through [key capability]. [Similar company] achieved [specific result] in [timeframe]."

### End User (Day-to-Day User)
**What they care about:** Ease of use, time savings, job performance
**Message focus:** Workflow improvements, daily benefits
**Proof points:** Time saved, tasks automated, user testimonials

**Template:**
"Spend less time on [tedious task] and more time on [valuable work]. [Product] automates [process] so you can [desired outcome]."

### Technical Buyer (IT/Security)
**What they care about:** Integration, security, scalability
**Message focus:** Technical capabilities, compliance
**Proof points:** Certifications, integrations, architecture

**Template:**
"[Product] integrates with [key systems] and meets [compliance standards]. Built on [architecture] to scale with your organization."

## Messaging by Funnel Stage

### TOFU (Awareness)
**Goal:** Generate interest, educate on problem
**Tone:** Educational, helpful, not sales-y
**CTA:** Download guide, read article, watch video

**Template:**
"[X%] of [role] struggle with [problem]. Here's what top performers do differently: [approach]. [Link to resource]"

### MOFU (Consideration)
**Goal:** Position solution, build trust
**Tone:** Consultative, comparison-friendly
**CTA:** See demo, compare solutions, read case study

**Template:**
"Evaluating [category] solutions? Here's what sets [Product] apart: [3 key differentiators]. See how [customer] chose us over [competitor]."

### BOFU (Decision)
**Goal:** Close the deal, remove objections
**Tone:** Direct, confident, ROI-focused
**CTA:** Start trial, request quote, talk to sales

**Template:**
"Join [#] companies using [Product] to [outcome]. Start your 14-day free trial (no credit card required) and see [benefit] in [timeframe]."

## Channel-Specific Messaging

### Website Homepage
**Above fold:** Problem + solution in 10 words
**Below fold:** 3 key benefits, social proof, CTA

**Hero headline formula:**
[Desired outcome] without [anxiety]

**Examples:**
- "Launch products 2x faster without endless meetings"
- "Scale revenue without scaling headcount"
- "Enterprise security without enterprise complexity"

### Email Subject Lines
**Best practices:**
- 6-10 words (50 characters)
- Personalize with name/company
- Create curiosity or urgency
- Avoid spam triggers

**Formulas:**
1. Question: "Is [pain point] costing you [cost]?"
2. Stat: "[X%] of [role] are missing this opportunity"
3. Benefit: "How to [achieve outcome] in [timeframe]"
4. Social proof: "[Company] increased [metric] by [%]"
5. Urgency: "Last chance: [offer] ends [date]"

### LinkedIn Ads
**Headline (70 chars):**
- Start with outcome, not product
- Include role/industry specificity
- Use numbers when possible

**Description (150 chars):**
- Expand on benefit
- Include social proof
- Clear CTA

**Example:**
Headline: "For CFOs: Cut Month-End Close Time by 50%"
Description: "Automate reconciliations and consolidations. Trusted by 200+ finance teams at companies like [logo]. See how."

### Google Search Ads
**Headline approach:**
- Match search intent exactly
- Include target keyword
- Highlight unique differentiator

**Formula (15 headline variants):**
H1-3: Keywords + benefit
H4-6: Social proof + stats
H7-9: Features + differentiators
H10-12: CTAs + offers
H13-15: Brand + unique angle

### Case Study Messaging
**Structure:**
1. Customer intro: [Company] is [description]
2. Challenge: They struggled with [problem] resulting in [cost]
3. Solution: They chose [Product] because [reason]
4. Results: Achieved [metric improvement] in [timeframe]
5. Quote: "[Testimonial from title at company]"

**Metrics to highlight:**
- Time saved (hours per week)
- Revenue impact ($ increased)
- Efficiency (% faster)
- Scale (users, volume, growth)

## Competitive Messaging

### Head-to-Head Comparison
**Rules:**
- Never name competitors in public materials (use "Alternative A")
- Focus on your strengths, not their weaknesses
- Use objective comparison criteria
- Include independent third-party validation (G2, Gartner)

**Template:**
"When evaluating [category], compare these key criteria: [criterion 1, 2, 3]. [Product] is the only solution that [unique capability]."

### Objection Handling Messages
**"Too expensive":**
"[Product] pays for itself in [timeframe] through [specific ROI]. [Customer] saved [$X] in the first [period]."

**"Too complex":**
"Teams are up and running in [timeframe]. Our average user needs [X hours] of training vs [competitor's X weeks]."

**"Happy with current solution":**
"[X%] of customers switched from [competitor] to gain [benefit]. See side-by-side comparison."

**"Need to see ROI first":**
"Start with free [trial/pilot] and measure impact before committing. Track [metric] from day one."

## Resources
- Positioning documentation
- Customer interview insights
- Competitive intelligence reports
- Win/loss analysis data

---
**Last Updated:** November 23, 2025
**Related:** positioning-frameworks.md, launch-checklists.md
