# Product Marketing Templates & Assets

## 1. Competitive Battlecard Template

**Battlecard Template** (create one per competitor):

```
COMPETITOR: [Competitor A]

OVERVIEW:
- Founded: 2015
- Funding: Series C, $75M raised
- HQ: San Francisco
- Size: 200 employees
- Customers: 5,000+ companies
- Pricing: $50-$500/user/month

POSITIONING:
- They say: "All-in-one platform for modern teams"
- Reality: Broad but shallow, not deep in any use case

KEY STRENGTHS (What They Do Well):
1. Strong brand recognition (category leader)
2. Large feature set (breadth over depth)
3. Extensive integrations (2,000+ apps)

KEY WEAKNESSES (Where They Fall Short):
1. Complex UI (steep learning curve)
2. Expensive (2x our price at scale)
3. Poor support (low NPS in reviews)
4. Legacy architecture (slow performance)

OUR ADVANTAGES:
1. 10x easier to use (time-to-value in minutes vs. days)
2. 50% lower cost at 100+ users
3. Superior performance (2x faster load times)
4. White-glove onboarding (dedicated CSM)

WHEN TO WIN:
- Customer values ease of use over features
- Budget-conscious (not enterprise)
- Need fast time-to-value (<1 week)
- Poor experience with competitor (switching)

WHEN TO LOSE:
- Enterprise (>5000 employees) with complex requirements
- Need feature X that we don't have yet
- Deep integration with competitor's ecosystem
- Already invested heavily in competitor (sunk cost)

TALK TRACKS:

Objection: "We're already using [Competitor A]"
Response: "That's great - many of our customers came from [Competitor A]. What prompted you to explore alternatives? [Listen for pain points] Typically teams switch to us because [ease of use / cost / performance]. Would it be helpful to see a side-by-side comparison?"

Objection: "[Competitor A] has more features"
Response: "You're right - they've been around longer and have a broader feature set. Here's what we found: most teams only use 20% of those features. Our customers love that we focus on doing [core use case] exceptionally well rather than trying to do everything. What features are most critical for your team?"

PROOF POINTS:
- Case study: "[Customer] switched from [Competitor A], reduced costs by 60%"
- Review comparison: "[4.8 vs. 4.2 G2 rating in 'Ease of Use']"
- Win rate: "35% win rate in competitive deals"

COMPETITIVE LANDSCAPE:
[Link to competitive positioning map]
[Link to feature comparison matrix]
```

**Battlecard Distribution**:
- Store in: Notion, Confluence, or sales enablement platform
- Update frequency: Monthly (or when competitor launches major feature)
- Access: Sales, CS, Product, Marketing teams
- Training: Monthly competitive update calls with sales

## 2. Sales Enablement Assets

### Sales Deck Template (15-20 slides)

```
Slide 1: Title slide (logo, tagline)
Slide 2: Agenda
Slide 3: Company intro (mission, vision, traction)
Slide 4: Problem statement (customer pain points)
Slide 5: Solution overview (your product)
Slide 6: Key benefits (3-5 bullets)
Slide 7: Product demo (screenshots or video)
Slide 8: Differentiation (vs. competitors)
Slide 9: Customer logos (social proof)
Slide 10: Case study (results-focused)
Slide 11: Pricing and plans
Slide 12: Implementation timeline
Slide 13: Support and success
Slide 14: Next steps (CTA)
Slide 15: Q&A

Guidelines:
- Visual-first (minimal text, large images)
- Customer-centric (benefits > features)
- Modular (easy to skip/reorder slides)
- Updated quarterly (or after major product changes)
```

### One-Pager Templates (1-page PDF)

**Product Overview**
- What it is, who it's for, key features
- Use case: First call with prospects

**Competitive Comparison**
- vs. Competitor A, B, C
- Use case: Competitive deals

**Case Study**
- Customer story with metrics
- Use case: Social proof in sales process

**Pricing Sheet**
- Plans, features, add-ons
- Use case: Pricing discussions

### Demo Script Template (30-45 min)

```
Demo Flow:
1. Intro (2 min) - Who we are, what we'll cover
2. Discovery (5 min) - Ask about their needs, pain points
3. Demo (20 min) - Show product (focus on their use case)
4. Q&A (10 min) - Address objections, questions
5. Next steps (3 min) - Define trial or POC plan

Demo Tips:
- Show, don't tell (product in action > slides)
- Use customer data (not "Company XYZ" examples)
- Focus on outcomes (not features)
- Address objections proactively (price, competition)
- Always drive to next step (trial, POC, proposal)
```

### Email Templates (HubSpot sequences)

**Cold outreach** (prospecting)
**Demo follow-up**
**Trial conversion**
**Proposal sent**
**Closing sequence**

### ROI Calculator Template (spreadsheet or web tool)

- Input: Customer's current costs, time spent, team size
- Output: Savings with your product, payback period, 3-year ROI
- Example: "Save $150k/year, 6-month payback, 500% ROI"

## 3. Product Launch Templates

### Major Launch Playbook (8-Week Timeline)

**8 Weeks Before Launch**:

Week -8:
- [ ] Kickoff meeting (Product, Marketing, Sales, CS)
- [ ] Define launch goals (pipeline $, MQLs, press coverage)
- [ ] Identify target audience (ICP, personas)
- [ ] Create positioning and messaging
- [ ] Assign roles and responsibilities

Week -7:
- [ ] Develop GTM strategy (channels, tactics, budget)
- [ ] Create sales enablement (deck, demo script, FAQs)
- [ ] Plan content (blog posts, case studies, videos)
- [ ] Design creative assets (ads, social graphics, emails)

Week -6:
- [ ] Build landing pages (product page, demo request)
- [ ] Set up HubSpot campaigns and tracking
- [ ] Write press release and pitch media
- [ ] Create email nurture sequences
- [ ] Produce demo video

Week -5:
- [ ] Beta test with select customers (feedback)
- [ ] Train sales team (positioning, demo, objection handling)
- [ ] Train CS team (onboarding, support docs)
- [ ] Finalize launch timeline and channel mix
- [ ] Prepare customer case studies

**4 Weeks Before Launch**:

Week -4:
- [ ] Launch paid ad campaigns (LinkedIn, Google)
- [ ] Publish teaser content (blog, social)
- [ ] Send pre-launch email to customer base
- [ ] Pitch press and influencers
- [ ] Set up webinar registration

Week -3:
- [ ] A/B test landing pages and ad copy
- [ ] Ramp up content production (blog posts, videos)
- [ ] Sales prospecting (outbound to target accounts)
- [ ] Finalize webinar content and speakers
- [ ] Prepare launch day checklist

Week -2:
- [ ] Send reminder emails (webinar, launch countdown)
- [ ] Increase paid ad spend (ramp up)
- [ ] Sales follow-up on warmed leads
- [ ] Dry run: Test all systems (website, forms, CRM)
- [ ] Prepare launch day assets (social posts, emails)

Week -1:
- [ ] Final review: All assets approved
- [ ] Pre-launch email to VIP customers and partners
- [ ] Sales team ready (trained, motivated, quotas set)
- [ ] CS team ready (docs updated, chat support staffed)
- [ ] Press embargo lifts (if applicable)

**Launch Week**:

Day 1 (Launch Day):
- [ ] Press release goes live (distribute to media)
- [ ] Email announcement to full database
- [ ] Social media blitz (LinkedIn, Twitter, Facebook)
- [ ] Paid ads at full budget
- [ ] Sales outbound campaign (top 500 accounts)
- [ ] Product update in-app (notify existing users)
- [ ] Monitor metrics (signups, demos, press pickup)

Days 2-5:
- [ ] Daily monitoring (conversion rates, funnel drop-offs)
- [ ] A/B test optimizations (headlines, CTAs)
- [ ] Sales follow-up (4-hour SLA on inbound leads)
- [ ] Respond to press inquiries
- [ ] Post customer testimonials and early wins
- [ ] Webinar (Day 3 or 4)

Week 2:
- [ ] Analyze launch results (vs. goals)
- [ ] Publish post-launch content (case studies, how-to guides)
- [ ] Sales continue outbound (sustained momentum)
- [ ] Optimize underperforming channels
- [ ] Scale winning channels (increase budget)

Week 3-4:
- [ ] Post-launch report (metrics, learnings, next steps)
- [ ] Customer feedback interviews (product improvements)
- [ ] Win/loss analysis (why did we win/lose deals?)
- [ ] Adjust messaging and positioning (based on feedback)
- [ ] Plan next launch (apply learnings)

### Launch Metrics Dashboard Template

**Leading Indicators** (track daily):
- Landing page visitors
- Demo requests
- Free trial signups
- MQLs generated
- Sales pipeline created ($)

**Lagging Indicators** (track weekly/monthly):
- SQLs generated
- Deals closed (count + $)
- Win rate (vs. pre-launch)
- Customer adoption rate (% of customers using feature)
- NPS score (feature-specific)

**HubSpot Dashboard**:
```
Launch Campaign: [Q2-2025-Product-X-Launch]

WEEK 1 RESULTS:
Traffic: 10,000 visitors (goal: 8,000) ✅
MQLs: 250 (goal: 200) ✅
SQLs: 40 (goal: 50) ⚠️
Pipeline: $800k (goal: $1M) ⚠️
Demos: 80 (goal: 100) ⚠️

TOP CHANNELS:
1. LinkedIn Ads: 120 MQLs, $150 CPL
2. Email: 80 MQLs, $25 CPL
3. Organic: 40 MQLs, $0 CPL

UNDERPERFORMING:
- Google Search: 10 MQLs, $400 CPL (pause and optimize)
- Webinar: 50 registrants, 20% show rate (improve email reminders)

NEXT ACTIONS:
- Increase LinkedIn Ads budget by 30%
- A/B test new landing page headline
- Sales follow-up blitz on 40 SQLs
```

## 4. GTM Launch Playbook (90-Day Plan)

**Pre-Launch (Days -90 to -30)**:

Week 1-4: Foundation
- [ ] Define ICP and buyer personas
- [ ] Develop positioning and messaging
- [ ] Create competitive battlecards
- [ ] Set success metrics (pipeline $, MQLs, win rate)

Week 5-8: Content & Enablement
- [ ] Build website pages (homepage, product, pricing)
- [ ] Create sales deck and demo script
- [ ] Produce launch assets (one-pager, case studies, FAQs)
- [ ] Develop email nurture sequences
- [ ] Train sales team on positioning and talk tracks

Week 9-12: Channel Setup
- [ ] Launch paid campaigns (LinkedIn, Google)
- [ ] Set up HubSpot tracking and attribution
- [ ] Publish SEO content (blog posts, guides)
- [ ] Activate partnerships (co-marketing plans)
- [ ] Test conversion funnels (landing page → signup)

**Launch (Days 1-30)**:

Week 1: Awareness
- [ ] Press release distribution
- [ ] Email announcement to existing database
- [ ] Social media campaign (LinkedIn, Twitter)
- [ ] Paid ads go live (awareness campaigns)
- [ ] Outbound sales blitz (top 100 accounts)

Week 2-4: Activation
- [ ] Monitor conversion rates (daily)
- [ ] A/B test landing pages and ad copy
- [ ] Sales follow-up on inbound leads (<4 hour SLA)
- [ ] Customer interviews (feedback on positioning)
- [ ] Adjust messaging based on early signals

**Post-Launch (Days 31-90)**:

Week 5-8: Optimization
- [ ] Analyze win/loss data (why did we win/lose?)
- [ ] Optimize underperforming channels (pause or pivot)
- [ ] Scale winning channels (20% weekly budget increase)
- [ ] Publish post-launch case studies
- [ ] Expand content (SEO, demand gen)

Week 9-12: Scale
- [ ] Enter new market segments (vertical or geo)
- [ ] Launch partnerships (co-marketing campaigns)
- [ ] Build PLG loops (referral program, viral features)
- [ ] Sales team expansion (hire based on pipeline)
- [ ] Iterate positioning (quarterly messaging refresh)

## 5. Sales Training Templates

### Monthly Sales Enablement Call (60 min)

- Product updates (new features, roadmap)
- Competitive landscape (new competitors, battlecard updates)
- Win/loss insights (why we're winning/losing)
- Best practices (top performer shares tips)
- Q&A (open forum for questions)

### Quarterly Sales Training (half-day workshop)

- Deep dive: Positioning and messaging refresh
- Role-playing: Objection handling, competitive demos
- Product training: New features, advanced use cases
- Customer panel: Hear directly from customers (why they bought)

### Sales Onboarding (new hires)

- Week 1: Company, product, market overview
- Week 2: ICP, personas, messaging
- Week 3: Competitive intelligence, battlecards
- Week 4: Demo certification (must pass to sell)

## 6. Quarterly Business Review Template

**QBR Template** (present to executive team):

**Slide 1: Executive Summary**
```
Q2 2025 Highlights:
- Launched Product X (pipeline: $2M, 500 MQLs)
- Entered UK market (20 new customers, $400k ARR)
- Improved win rate by 15% (competitive positioning)
- Published 3 case studies (2x sales usage vs. Q1)
```

**Slide 2: Metrics Dashboard**
```
KPI             Q2 Target   Q2 Actual   Status
─────────────────────────────────────────────
MQLs            800         950         ✅ +19%
SQLs            150         140         ⚠️ -7%
Pipeline $      $4M         $3.8M       ⚠️ -5%
Win Rate        30%         35%         ✅ +17%
Deal Size       $45k        $52k        ✅ +16%
Sales Velocity  75 days     68 days     ✅ -9%
```

**Slide 3: Key Insights**
```
What Worked:
1. Product X launch exceeded MQL target by 19%
2. Improved competitive positioning → 35% win rate
3. UK market entry on track ($400k ARR in 3 months)

What Didn't Work:
1. SQL conversion rate dropped from 20% to 15%
2. Google Ads underperformed (paused and optimizing)
3. Competitor A launched aggressive pricing (5 lost deals)

Action Items:
1. Improve SQL qualification criteria (work with sales)
2. Update battlecard for Competitor A (new pricing)
3. Double down on UK market (hire local AE)
```

**Slide 4: Next Quarter Plan**
```
Q3 2025 Priorities:
1. Launch Product Y (pipeline target: $3M)
2. Enter DACH market (Germany, Austria, Switzerland)
3. Refresh messaging and website (new positioning)
4. Scale partnerships (3 new strategic partners)
5. Build customer advocacy program (10 case studies)

Budget: $150k (up from $120k in Q2)
Headcount: +1 PMM, +1 Content Marketer
```

## 7. PMM Monthly Checklist

**Week 1** (Strategy & Planning):
- [ ] Review previous month metrics (win rate, deal size, pipeline)
- [ ] Analyze win/loss interviews (competitive trends)
- [ ] Update competitive battlecards (if needed)
- [ ] Plan next month campaigns and content

**Week 2** (Content & Enablement):
- [ ] Create new sales assets (1-pager, case study, deck update)
- [ ] Publish content (blog post, video, webinar)
- [ ] Train sales on new positioning or product updates
- [ ] Review sales asset usage (what's working?)

**Week 3** (Launches & Campaigns):
- [ ] Support product launches (if any)
- [ ] Monitor campaign performance (MQLs, SQLs, pipeline)
- [ ] Optimize underperforming channels
- [ ] Customer interviews (feedback on positioning)

**Week 4** (Reporting & Iteration):
- [ ] Monthly metrics report (for exec team)
- [ ] Sales enablement call (updates, Q&A)
- [ ] Win/loss analysis (themes, trends)
- [ ] Plan next quarter launches and strategy

## 8. Positioning Development Timeline

**Week 1**: Research
- Customer interviews (10-15)
- Competitive analysis
- Market trends

**Week 2**: Framework
- April Dunford positioning exercise
- Define unique value
- Identify best-fit customers

**Week 3**: Messaging
- Craft value proposition
- Build messaging hierarchy
- Create persona-specific messaging

**Week 4**: Validation
- Test with sales team
- A/B test on landing pages
- Customer feedback

**Week 5-6**: Rollout
- Update website, sales decks
- Train sales and CS teams
- Launch campaigns with new messaging

## 9. Team Handoff Protocols

**PMM → Demand Gen**:
- Deliver: Positioning, messaging, competitive intel, launch plans
- Frequency: Monthly sync + ad-hoc for launches
- SLA: 2-week lead time for major campaigns

**PMM → Sales**:
- Deliver: Battlecards, sales decks, demo scripts, objection handling
- Frequency: Monthly enablement call + weekly Slack updates
- SLA: 48 hours for urgent competitive questions

**PMM → Product**:
- Deliver: Customer feedback, competitive feature gaps, win/loss insights
- Frequency: Weekly product sync
- SLA: Quarterly roadmap input (feature prioritization)

**PMM → Customer Success**:
- Deliver: Product positioning, adoption tactics, customer education content
- Frequency: Monthly sync
- SLA: 1 week for new product launch enablement

## 10. HubSpot Reporting Templates

### Custom Reports

**1. Product Launch Impact**
```
Metrics: Leads, MQLs, SQLs, Pipeline $, Closed Won $
Dimensions: Campaign, Channel, Region
Filters: Campaign = "Q2-2025-Product-X-Launch"
Time period: 90 days post-launch
```

**2. Competitive Win Rate**
```
Metrics: Opportunities, Closed Won, Win Rate %
Dimensions: Competitor (property)
Filters: Deal stage = Closed Won or Closed Lost
Segment by: Competitor A, B, C, Other
```

**3. Sales Enablement Usage**
```
Metrics: Asset downloads, views, shares
Dimensions: Asset type (deck, battlecard, case study)
Filters: User = Sales team
Insight: Which assets are most used by sales
```
