# OKR Methodology Reference Guide

## Overview
Comprehensive guide to Objectives and Key Results (OKRs) framework for product strategy, goal setting, and alignment. Covers OKR structure, cascading, tracking, and best practices.

## OKR Fundamentals

### Definition
**Objective:** Qualitative, inspiring goal (WHERE you want to go)
**Key Results:** Quantitative, measurable outcomes (HOW you'll know you got there)

### Formula
```
Objective: [Qualitative, aspirational statement]
└─ Key Result 1: [Metric] from [X] to [Y] by [date]
└─ Key Result 2: [Metric] from [X] to [Y] by [date]
└─ Key Result 3: [Metric] from [X] to [Y] by [date]
```

**Example:**
```
Objective: Become the #1 choice for remote teams
└─ KR1: Increase NPS from 45 to 65
└─ KR2: Grow active teams from 1,000 to 5,000
└─ KR3: Achieve 50% market share in 10k+ employee companies
```

## OKR Structure

### Good Objectives
**Characteristics:**
- Inspirational and memorable
- Qualitative (not measured directly)
- Time-bound (quarterly or annual)
- Actionable by the team
- Aligned with strategy

**Template:**
- "[Action verb] + [what] + [why/impact]"
- Examples: "Dominate the SMB market", "Deliver world-class customer experience"

### Good Key Results
**Characteristics:**
- Quantitative and measurable
- Outcome-focused (not activity)
- Ambitious but achievable (70% confidence)
- 3-5 per objective (not more)
- Leading indicators of success

**Template:**
- "[Metric] from [X] to [Y]"
- Examples: "Increase MRR from $100k to $150k", "Reduce churn from 5% to 3%"

## OKR Cascading

### Company → Team → Individual

**Company Level (Annual):**
```
Objective: Become profitable while maintaining growth
└─ KR1: Reach $10M ARR (from $5M)
└─ KR2: Improve gross margin from 70% to 80%
└─ KR3: Reduce CAC payback from 18 to 12 months
```

**Product Team (Quarterly):**
```
Objective: Drive product-led growth
└─ KR1: Increase trial-to-paid from 10% to 20%
└─ KR2: Reduce time-to-value from 7 to 3 days
└─ KR3: Achieve 80% product qualified lead (PQL) accuracy
```

**Individual IC (Quarterly):**
```
Objective: Improve onboarding conversion
└─ KR1: Launch guided product tour (adoption by 50% of trials)
└─ KR2: Reduce onboarding drop-off from 60% to 40%
└─ KR3: Increase activation rate (complete setup) from 30% to 50%
```

## OKR Best Practices

### Writing Effective OKRs
1. **Objectives should inspire** - Team excited to achieve them
2. **Key Results should be ambitious** - 70% confidence, not 100%
3. **Focus on outcomes, not outputs** - "Increase retention" not "Ship feature X"
4. **Limit quantity** - 3-5 OKRs per level max
5. **Make them measurable** - Clear success criteria

### Common Mistakes
**Mistake 1: Output-based Key Results**
```
Bad: "Launch 3 new features"
Good: "Increase feature adoption from 30% to 60%"
```

**Mistake 2: Business-as-usual work**
```
Bad: "Maintain 99% uptime"
Good: "Improve system reliability from 99% to 99.9%"
```

**Mistake 3: Too many OKRs**
```
Bad: 10 objectives with 50 key results
Good: 3-5 objectives with 3-5 KRs each
```

## OKR Cycle

### Quarterly Rhythm
**Week 1: Planning**
- Review previous quarter results
- Set new quarter OKRs
- Align with stakeholders

**Week 2-11: Execution**
- Weekly check-ins on progress
- Monthly reviews with leadership
- Adjust tactics as needed

**Week 12: Review**
- Score OKRs (0.0-1.0)
- Retrospective (what worked, what didn't)
- Carry forward incomplete OKRs (if still relevant)

### Scoring
```
0.0-0.3: Red (significant miss)
0.4-0.6: Yellow (made progress but fell short)
0.7-0.9: Green (achieved, stretch goal hit)
1.0: Exceeded (too easy, raise bar next time)
```

**Target:** 70% average score (0.7) across all OKRs

## Resources
- OKR templates and examples
- Cascade alignment tool
- Tracking dashboard

---
**Last Updated:** November 23, 2025
**Related:** frameworks.md, tools.md
