# Strategic Planning Framework Reference Guide

## Overview
Comprehensive frameworks for product strategy development, including vision, positioning, market analysis, and strategic planning methodologies.

## Vision & Mission

### Product Vision
**Template:**
```
For [target customer]
Who [customer need]
The [product name] is a [product category]
That [key benefit/differentiator]
Unlike [competitive alternatives]
Our product [unique value proposition]
```

**Example:**
```
For product teams at high-growth SaaS companies
Who need to prioritize features based on customer impact
ProductOS is a product analytics platform
That connects user behavior directly to revenue outcomes
Unlike traditional analytics tools
Our product shows which features drive expansion and retention
```

### Product Mission
**One-sentence statement of purpose**

**Formula:** "We help [who] achieve [what] through [how]"

**Example:** "We help product teams build features customers love by connecting usage data to business outcomes."

## Strategy Frameworks

### Playing to Win Strategy
**5 Questions:**
1. What is our winning aspiration? (Vision)
2. Where will we play? (Target market)
3. How will we win? (Differentiators)
4. What capabilities must we have? (Core competencies)
5. What management systems are required? (Execution)

### SWOT Analysis
```
Internal:
Strengths: What advantages do we have?
Weaknesses: What disadvantages?

External:
Opportunities: What market trends can we exploit?
Threats: What could harm us?
```

**Strategic Actions:**
- Strengths + Opportunities = Offensive strategy
- Strengths + Threats = Defensive strategy
- Weaknesses + Opportunities = Developmental strategy
- Weaknesses + Threats = Avoidance strategy

### Porter's Five Forces
1. **Competitive Rivalry:** How intense is competition?
2. **Supplier Power:** How much leverage do suppliers have?
3. **Buyer Power:** How price-sensitive are customers?
4. **Threat of Substitution:** What alternatives exist?
5. **Threat of New Entry:** How easy for new competitors?

**Application:** Identify where to compete and how to win

## Market Analysis

### TAM/SAM/SOM
```
TAM (Total Addressable Market): Global market size
SAM (Serviceable Addressable Market): Realistic target
SOM (Serviceable Obtainable Market): What you can capture

Example:
TAM: $50B (global project management software)
SAM: $5B (B2B SaaS, 50-5000 employees)
SOM: $500M (realistic 10% capture in 5 years)
```

### Market Segmentation
**Dimensions:**
- Firmographics: Company size, industry, geography
- Technographics: Tech stack, cloud usage, tools
- Behavioral: Usage patterns, buying process
- Needs-based: Pain points, desired outcomes

**Segment Prioritization:**
- Size: Large enough to matter
- Growth: Growing vs shrinking
- Accessibility: Can you reach them?
- Willingness to pay: High ACV potential

## Strategic Planning Process

### Annual Planning Cycle
**Phase 1: Analysis (Month 1-2)**
- Review previous year performance
- Market/competitive analysis
- Customer feedback synthesis
- SWOT analysis

**Phase 2: Strategy (Month 2-3)**
- Define vision and strategic pillars
- Set annual OKRs
- Identify key initiatives
- Resource planning

**Phase 3: Roadmap (Month 3)**
- Translate strategy into roadmap
- Prioritize initiatives (RICE score)
- Quarterly breakdown
- Stakeholder alignment

**Phase 4: Execution (Month 4-12)**
- Quarterly OKR check-ins
- Monthly roadmap reviews
- Continuous adjustment

## Resources
- Vision/mission templates
- SWOT analysis tool
- Market sizing calculator
- Strategic planning templates

---
**Last Updated:** November 23, 2025
**Related:** okr_methodology.md, roadmap_frameworks.md
