---
name: reframe
description: This skill should be used when the user is stuck, obvious solutions aren't working, constraints feel impossible, or they keep circling back to bad options. Use when designs keep getting rejected or the user is solving symptoms instead of root causes.
---

# Reframe the Problem

## When This Activates

User describes being stuck like:
- "I've tried everything"
- "Nothing feels right"
- "The constraints are impossible"
- "Stakeholders keep rejecting solutions"
- "We're going in circles"
- "This feels like the wrong approach"

## Instructions

### Step 1: State the Current Problem

First, get clarity on the trap the user is in:

```
CURRENT FRAMING:
Problem: [What are they trying to solve?]
Constraints: [What limitations are they working within?]
Failed attempts: [What has already not worked?]
```

### Step 2: Reframe by Changing WHO

Consider alternative users:

```
REFRAME PROMPTS:
- What if this was for a complete beginner vs expert?
- Someone in a rush vs unlimited time?
- A group vs individual?
- Someone who HATES this task vs loves it?
- Internal user vs external customer?
```

Design the solution for the alternate user. Identify revealed insights.

### Step 3: Reframe by Changing WHERE

Explore different contexts:

```
REFRAME PROMPTS:
- On a phone while walking?
- On a massive monitor with full attention?
- In a loud, distracting environment?
- With no internet connection?
- While doing something else simultaneously?
- In public where others can see their screen?
```

Identify what simplifications the constraint forces.

### Step 4: Reframe by Changing WHAT

Consider if it wasn't a [current solution type] at all:

```
REFRAME PROMPTS:
- What if it was a daily email instead?
- A conversation with a person?
- A physical object?
- An automated system needing no UI?
- A single button?
- Something someone else prepares for them?
```

Identify which reframe makes the core job easier.

### Step 5: Try Inversion

Flip the question entirely:

```
INVERSIONS:
Instead of: "How do we get users to [do thing]?"
Ask: "How do we make [thing] unnecessary?"

Instead of: "How do we make this easier?"
Ask: "What would make users WANT to do this?"

Instead of: "How do we add this feature?"
Ask: "What problem are we avoiding by adding features?"
```

## Output Format

**IMPORTANT:** Always use this exact format:

```
REFRAME ANALYSIS

ORIGINAL FRAMING:
Problem: [statement]
Constraints: [list]
Failed approaches: [list]

REFRAMES EXPLORED:
WHO shift: [insight from changing the user]
WHERE shift: [insight from changing context]
WHAT shift: [insight from changing solution type]
INVERSION: [insight from flipping the question]

REFRAMED PROBLEM:
[New way of seeing the problem]

NEW DIRECTIONS:
1. [Concrete direction to explore]
2. [Concrete direction to explore]
3. [Concrete direction to explore]
```

The "Reframe Analysis" with WHO/WHERE/WHAT shifts is the signature of this methodology.

## When to Use

- Early in a project when the problem isn't well-defined
- When you've hit a wall with conventional approaches
- When constraints feel too tight
- When stakeholder feedback keeps killing solutions

## When to Skip

- The solution is obvious and you just need to execute
- You're optimizing something that already works
- The problem is purely technical, not conceptual
