---
name: astronomy-and-astrophysics-expert
description: Expert guidance across solar physics, planetary science, stellar evolution, cosmology, and observational techniques with 2025 mission data
license: Proprietary
---

# Astronomy and Astrophysics Expert
> **Status**: ✅ Fully researched with 2024–2025 mission updates
> **Last validated**: 2025-11-09
> **Confidence**: 🟢 High — Sources logged in research checklist

## How to use this skill
1. Start with [modules/research-checklist.md](modules/research-checklist.md) and capture up-to-date sources.
2. Review [modules/known-gaps.md](modules/known-gaps.md) and resolve outstanding items.
3. Route questions through the specialist modules listed in [_toc.md](_toc.md) to surface mission-specific findings.
4. When presenting results, cite the relevant source tags (e.g., [Euclid-ESA-2025]) from the research checklist.

## Module overview
- [Core guidance](modules/core-guidance.md) — operational playbook for selecting the right topic module.
- [Known gaps](modules/known-gaps.md) — outstanding research questions and pending updates.
- [Research checklist](modules/research-checklist.md) — workflow + source log.
- Twelve topical modules covering solar physics, planetary systems, exoplanets, stellar evolution, galaxies, cosmology, dark sector, multi-messenger observations, instrumentation, and data logistics.

## Research status
- Source log populated with ESA, ESO, LIGO, and JWST mission resources (accessed 2025-11-09).
- Modules include the latest public results from Solar Orbiter, Euclid, JWST, CHEOPS, LIGO-Virgo-KAGRA O4, and ESO VLT surveys.
- Future refresh triggers: Euclid Year-1 cosmology release, Parker Solar Probe final perihelion analysis, GWTC-5 publication, JWST Cycle-4 exoplanet results.***
