# Module Guide

| Module | Purpose |
| --- | --- |
| [modules/core-guidance.md](modules/core-guidance.md) | How to navigate the skill and route questions to specialised modules. |
| [modules/solar-physics.md](modules/solar-physics.md) | Solar structure, activity cycles, and heliospheric dynamics (Solar Orbiter, Parker data). |
| [modules/space-weather-operations.md](modules/space-weather-operations.md) | Translating solar events into operational risk mitigation guidance. |
| [modules/planetary-science.md](modules/planetary-science.md) | Comparative planetology, mission status across the solar system. |
| [modules/moons-small-bodies.md](modules/moons-small-bodies.md) | Icy moons, astrobiology potential, asteroids/comets, impact mitigation. |
| [modules/exoplanets-habitability.md](modules/exoplanets-habitability.md) | Detection techniques, atmospheric characterisation, habitability metrics. |
| [modules/stellar-evolution.md](modules/stellar-evolution.md) | Stellar lifecycles, transients, black holes, and merger rates. |
| [modules/galactic-structure.md](modules/galactic-structure.md) | Milky Way structure, galaxy evolution, Euclid/JWST insights. |
| [modules/multi-messenger-astronomy.md](modules/multi-messenger-astronomy.md) | Gravitational waves, neutrinos, electromagnetic counterparts, alert handling. |
| [modules/cosmology-cmb.md](modules/cosmology-cmb.md) | ΛCDM parameters, CMB physics, cosmic expansion history. |
| [modules/dark-matter-energy.md](modules/dark-matter-energy.md) | Evidence and constraints on the dark sector, future surveys. |
| [modules/observational-techniques.md](modules/observational-techniques.md) | Instrument selection, resolution requirements, adaptive optics/interferometry. |
| [modules/data-products-and-missions.md](modules/data-products-and-missions.md) | Archives, proposal planning, data pipelines, and mission logistics. |
| [modules/known-gaps.md](modules/known-gaps.md) | Open questions, validation tasks, and future research leads. |
| [modules/research-checklist.md](modules/research-checklist.md) | Maintained source log and validation workflow. |
