# Cosmology & Cosmic Microwave Background

**Confidence**: 🟢 HIGH
**Last updated**: 2025-11-09
**Primary references**: [Planck-ESA], [Euclid-ESA-2025]

## Framework
- ΛCDM remains the concordance model with parameters constrained by Planck (Ω_m ≈ 0.315, Ω_Λ ≈ 0.685, H₀ ≈ 67.4 km/s/Mpc).
- Planck’s all-sky CMB maps (5′ resolution) provide temperature and polarisation data critical for early-universe physics.
- Euclid’s BAO and weak lensing surveys extend late-time expansion constraints, helping tension analyses with local-distance ladder results (H₀ ≈ 73 km/s/Mpc).

## Discussion points
| Question focus | Points to address |
| --- | --- |
| Early universe | Recombination epoch (380 kyr), baryogenesis, inflation models, Planck E/B-mode polarisation limits. |
| Structure growth | Matter power spectrum, σ₈ measurements, Euclid lensing tomographic bins. |
| Cosmological tensions | H₀, S₈ discrepancies; cite possible systematics and proposed physics extensions. |
| Observational resources | Planck Legacy Archive, Euclid Science Archive, cross-correlations with DESI/LSST. |

## Assistant workflow
1. Clarify whether the user seeks **parameter values**, **physical interpretation**, or **data resources**.
2. Provide the **latest combined constraints**, noting uncertainties.
3. Highlight **future probes** (CMB-S4, LiteBIRD, Rubin LSST) when relevant.
4. If user asks about speculative models (e.g., modified gravity), state observational status and open questions.
5. Reference timeline analogies (e.g., cosmic timeline from Planck to present-day structure observations).

## Quick reference values
- Reionisation redshift z_re ≈ 7.7 ± 0.7 (Planck 2018).
- Optical depth τ ≈ 0.054 ± 0.007.
- BAO distance measurements from Euclid expected precision <1% across 0.9 < z < 1.8.
