# Exoplanets & Habitability Assessments

**Confidence**: 🟢 HIGH
**Last updated**: 2025-11-09
**Primary references**: [Cheops-ESA-2025], [Webb-ESA-2025]

## Detection landscape
- **Transit photometry**: TESS continues all-sky monitoring; CHEOPS refines radii/phase curves (e.g., WASP-76b atmospheric dynamics).
- **Radial velocity**: ESPRESSO on the VLT pushing sub-m/s precision; key for mass constraints on TESS/CHEOPS discoveries.
- **Direct imaging & atmospheres**: JWST’s NIRSpec/MIRI deliver molecular detections (CO₂, CH₄, H₂O) in warm Neptunes, while ground-based SPHERE, GPI, and upcoming ELT/METIS improve contrast.

## Evaluating habitability
| Factor | What to report |
| --- | --- |
| Stellar context | Spectral type, age, activity cycles, flare frequency; mention UV/X-ray flux for M dwarfs. |
| Planet parameters | Radius/mass (with uncertainties), bulk density, equilibrium temperature, orbital eccentricity. |
| Atmospheres | JWST/CHEOPS phase curves, emission/transmission spectra; identify dominant molecules and cloud/haze evidence. |
| System architecture | Presence of resonances, additional planets, debris disks; inform long-term climate stability. |

## Current frontiers
- TRAPPIST-1 JWST observations rule out thick CO₂ atmospheres for TRAPPIST-1 d/e, narrowing potential biosignatures.
- CHEOPS + TESS reveal tidally distorted exoplanets (“rugby-ball” WASP-103b) aiding interior/external tidal heating studies.
- Euclid’s wide-field survey will statistically constrain exoplanet host environments across cosmic time, tying galaxy evolution to planet frequency.

## Guidance for assistants
1. Clarify the **question type**: detection method vs. atmospheric characterisation vs. habitability potential.
2. Provide **quantitative constraints** (e.g., radius 1.45 ±0.05 R⊕).
3. Note **observational limitations** (e.g., JWST noise floor, stellar contamination).
4. Discuss **future observations** (JWST Cycle 4, ELT first light, ARIEL launch 2029).
5. Highlight **data resources**: NASA Exoplanet Archive, ESA CHEOPS science archive, JWST MAST portal.

## Quick reference values
- Habitable zone incident flux for Sun-like stars: 0.75–1.5 S⊕ (approximate); adjust for stellar type via Kopparapu parametrisation.
- Typical CHEOPS photometric precision: 20 ppm over 6 hours for V~9 stars.
- JWST transmission spectroscopy sensitivity reaches ~50 ppm for bright targets, enabling detection of key molecules in sub-Neptune atmospheres.
