# Moons & Small Bodies

**Confidence**: 🟢 HIGH
**Last updated**: 2025-11-09
**Primary references**: [ESO-PlanetDiscs-2024], [Cheops-ESA-2025]

## Highlights
- **Icy moons**:
  - Europa Clipper en route (launch 2024, arrival 2030) with ice-penetrating radar and mass spectrometer to characterise ocean composition.
  - JUICE will perform 35 flybys (Ganymede focus) with magnetometer + laser altimeter for interior ocean mapping.
  - Enceladus plume activity monitored via JWST mid-infrared spectroscopy showing water vapour outflow >300 kg/s.
- **Titan**: Dragonfly launch locked for 2028; incorporate lesson learnt from Huygens descent data and Cassini radar topography.
- **Asteroids/comets**:
  - DART/Hera system provides empirical kinetic impact benchmark; note pre- and post-impact orbital period change (~33 minutes).
  - Lucy flybys of Trojan asteroids continuing (Donaldjohanson 2025) delivering surface composition diversity.
  - Comet activity studies leverage ALMA and JWST to map volatiles and dust jets with high temporal cadence.

## Guidance cues
| Scenario | Response focus |
| --- | --- |
| Resource assessment | Provide volatile inventory, regolith properties, and mission data references (OSIRIS-REx, Hayabusa2, upcoming MMX). |
| Astrobiology | Discuss biosignature potential (salinity, energy gradients) for Europa/Enceladus; cite plume composition findings. |
| Impact mitigation | Summarise DART kinetic results, Hera follow-up, and NEO survey completeness; mention LSST/Vera Rubin contributions. |

## Recent findings
- SPHERE survey (ESO VLT) reveals disk substructures around young stars consistent with early moon/planet formation stages, implying migration and resonant sculpting relevant to moon systems.
- CHEOPS “First glory” detection hints at atmospheric aerosols on exoplanets, informing comparative studies with solar-system hazes.
- Water-ice detections on main-belt comets challenge traditional volatile distribution assumptions—highlight interplay with planetesimal formation models.

## Checklist for responses
1. Clarify the user’s time horizon (current missions vs. planning for 2030s).
2. Quote measurement precision where available (e.g., gravity coefficients for Ganymede).
3. Note radiation environments and operational constraints.
4. Cross-link to planetary formation module when discussing moons as tracers of disk evolution.
5. Provide data archive links (PDS Small Bodies Node, ESA PSA) if users request raw datasets.

## Quick numbers
- Ganymede intrinsic magnetic field dipole ~719 nT at equator; key for magnetosphere studies.
- DART impact momentum enhancement factor β ≈ 3.6 ± 0.3 (pending Hera refinement).
- Typical Trojan asteroid densities 1.0–1.5 g/cm³ (Lucy mission estimates), implying porous, icy-rich interiors.
