# Solar Physics & Heliospheric Dynamics

**Confidence**: 🟢 HIGH
**Last updated**: 2025-11-09
**Primary references**: [SO-ESA-2025], [Webb-ESA-2025]

## Mission snapshot
- **Solar Orbiter (ESA/NASA)** is now routinely imaging the Sun from <0.3 AU, providing the first high-latitude magnetograms and linking solar wind streams to their surface origin. Perihelia down to 42 million km and orbital plane shifts toward ±33° enable unprecedented polar coverage.
- **Parker Solar Probe** complements high-resolution imaging with in situ plasma and field measurements inside 9.3 solar radii, resolving Alfvénic switchbacks and energy deposition that heats the corona.
- Coordinated campaigns (Solar Orbiter + Parker + ground observatories) allow multi-point mapping of the same eruptive event, tightening timing estimates for CME arrival and geomagnetic storm forecasting.

## What to surface in answers
- **Solar cycle phase**: We are tracking a strong Solar Cycle 25 peak (2024–2025) with elevated sunspot number, sustained M/X-class flare rates, and extended polar coronal holes.
- **Coronal heating & solar wind drivers**: Mention jets and nano-flare activity resolved by Solar Orbiter’s Extreme Ultraviolet Imager, and the statistical presence of switchbacks measured by Parker as evidence for interchange reconnection.
- **Space weather readiness**: Link user questions to actionable indices (F10.7, Kp, Dst), and highlight lead times provided by L1 monitors versus extended forecasts from helioseismology and far-side imaging.

## Applied guidance
| Scenario | Recommended approach |
| --- | --- |
| Forecasting CME arrival | Reference Solar Orbiter coronagraph data to extract propagation speed; combine with ENLIL or drag-based models. Provide uncertainty (±6–12 hours typical). |
| Explaining auroral risk to operators | Translate CME speed & IMF orientation into operational steps (e.g., satellite safe-mode thresholds, aviation polar route rerouting). |
| Investigating coronal temperature | Summarise current theories (wave dissipation vs. reconnection) and cite recent Solar Orbiter jet detections; note remaining open questions in `known-gaps.md`. |

## Quick facts
- Solar Orbiter’s 10-instrument payload includes the Polarimetric and Helioseismic Imager (PHI) for magnetic mapping and the Solar Wind Analyser (SWA) suite for composition tracking.
- Perihelion cadence: ~every 6 months, with perihelia gradually moving toward higher heliographic latitudes after 2025.
- Typical high-speed solar wind stream velocity during current cycle: 600–800 km/s; CME shock arrivals can exceed 1 500 km/s.

## Response checklist
1. Identify whether the user needs **forecasting**, **historical context**, or **physical mechanism**.
2. Cite recent Solar Orbiter or Parker results when describing high-resolution findings.
3. Provide time frames (e.g., “data released March 2025”) to show currency.
4. Flag outstanding research gaps (e.g., precise energy partitioning in polar coronal holes) if the question touches speculative territory.
5. Link to mission data portals when the user requests raw or calibrated observations (Solar Orbiter Science Archive, Parker Science Gateway).
