# Stellar Evolution & Transient Phenomena

**Confidence**: 🟢 HIGH
**Last updated**: 2025-11-09
**Primary references**: [ESO-Quasar-2024], [Webb-ESA-2025]

## Lifecycle overview
- **Star formation**: JWST deep imaging of molecular clouds (e.g., Tarantula Nebula) resolves protostars down to sub-solar masses, refining the initial mass function (IMF) in high-pressure environments.
- **Main sequence & beyond**: Gaia DR3 + asteroseismology (TESS/PLATO-prep) deliver precise ages and interior rotation profiles.
- **End states**: JWST mid-infrared spectra of planetary nebulae reveal complex molecular chemistry; LIGO/Virgo/KAGRA provide merger rates for neutron stars/black holes informing massive star evolution.

## Transient sky
| Event | Key takeaways |
| --- | --- |
| Supernovae | Shock breakout captured by space-based UV telescopes constrains progenitor radii; LSST pre-ops already identifying early light curve bumps. |
| Gamma-ray bursts | Multi-wavelength follow-up links long GRBs to collapsars, short GRBs to neutron-star mergers; gravitational-wave triggers accelerate localisation. |
| Tidal disruption events | High-redshift quasar surveys (ESO VLT) show rapid feeding episodes; highlight role in SMBH growth. |

## Black holes & quasars
- ESO VLT discovery of quasar J0529-4351 (luminosity >5×10^14 L☉) demonstrates rapid SMBH growth ~1 Gyr after Big Bang, challenging accretion models.
- LIGO-Virgo-KAGRA detections (O4) include >100 M☉ black hole mergers, pushing hierarchical merger scenarios.
- JWST spectroscopy resolves broad/narrow line regions in AGN at z>6, allowing metallicity estimates in early Universe.

## Response guidance
1. Determine whether the question requires **evolutionary pathways**, **observational signatures**, or **rate estimates**.
2. Provide **timescales** (e.g., massive stars <10 Myr, Sun-like stars ~10 Gyr).
3. Connect theoretical predictions (stellar structure equations, mass-loss rates) with observational constraints (Gaia, JWST, LIGO).
4. Note major uncertainties (e.g., binary fraction impacts, common-envelope efficiency).
5. Cite survey or mission delivering the data, including observation epochs.

## Quick facts
- Upper-mass IMF slope consistent with Salpeter at high masses but shows regional variation (JWST, 2024).
- Binary fraction for O-type stars >70%, critical for interpreting LIGO merger rates.
- Typical Type Ia supernova standardisation scatter now ~0.1 mag with improved calibration, essential for cosmology modules.
