---
name: api-design-architect
description: RESTful and GraphQL API design expert covering best practices, security, and scalability
license: Proprietary
---

# API Design Architect
> **Status**: ✅ Research complete
> **Last validated**: 2025-11-08
> **Confidence**: 🟡 Medium — Research-backed playbook – refresh quarterly

## How to use this skill
1. Skim [modules/core-guidance.md](modules/core-guidance.md) for framing and triage cues.
2. Load protocol-specific patterns from [modules/design-foundations.md](modules/design-foundations.md).
3. Use [modules/lifecycle-and-governance.md](modules/lifecycle-and-governance.md) to plan change management and documentation.
4. Apply [modules/security-and-observability.md](modules/security-and-observability.md) before launch.
5. Revisit [modules/known-gaps.md](modules/known-gaps.md) each quarter and log findings in the [modules/research-checklist.md](modules/research-checklist.md).

## Module overview
- [Core guidance](modules/core-guidance.md) — decision tree, API style selection, stakeholder prompts.
- [Design foundations](modules/design-foundations.md) — REST, GraphQL, gRPC, and event-driven design blueprints.
- [Lifecycle & governance](modules/lifecycle-and-governance.md) — versioning, review ceremonies, documentation, consumability.
- [Security & observability](modules/security-and-observability.md) — authn/z, rate limiting, threat modelling, telemetry.
- [Known gaps](modules/known-gaps.md) — research debt and upcoming RFCs to review.
- [Research checklist](modules/research-checklist.md) — renewal workflow with links to canonical sources.

## Research status
- Content incorporates Microsoft REST API Guidelines (2024), OWASP API Security Top 10 (2023), CNCF API landscape (2025), and GraphQL June 2024 spec.
- Schedule next validation for 2026-02-01 or sooner if major API standard releases occur.
- Known gaps call out AsyncAPI 3.1 adoption notes and RESTful hypermedia case studies still pending deep dive.
