---
name: cicd-pipeline-builder
description: DevOps expert for building robust CI/CD pipelines with GitHub Actions, GitLab CI, Jenkins
license: Proprietary
---

# CI/CD Pipeline Builder
> **Status**: ✅ Research complete
> **Last validated**: 2025-11-08
> **Confidence**: 🟡 Medium — Research-backed playbook – audit monthly

## How to use this skill
1. Review [modules/core-guidance.md](modules/core-guidance.md) to triage pipeline goals and constraints.
2. Design the backbone with [modules/pipeline-foundations.md](modules/pipeline-foundations.md).
3. Apply reliability and metrics practices from [modules/quality-gates-and-observability.md](modules/quality-gates-and-observability.md).
4. Bake in supply-chain and compliance controls via [modules/security-and-compliance.md](modules/security-and-compliance.md).
5. Revisit [modules/known-gaps.md](modules/known-gaps.md) and schedule the refresh workflow in [modules/research-checklist.md](modules/research-checklist.md).

## Module overview
- [Core guidance](modules/core-guidance.md) — stakeholder alignment, platform selection, maturity map.
- [Pipeline foundations](modules/pipeline-foundations.md) — architecture patterns, environment strategy, deployment choreography.
- [Quality gates & observability](modules/quality-gates-and-observability.md) — testing matrices, DORA metrics, release telemetry.
- [Security & compliance](modules/security-and-compliance.md) — SLSA levels, SBOM, policy-as-code, audit prep.
- [Known gaps](modules/known-gaps.md) — targeted investigations and roadmap items.
- [Research checklist](modules/research-checklist.md) — monthly refresh cadence.

## Research status
- Guidance reconciled with 2024–2025 DORA findings, SLSA v1.0, and major CI platform releases.
- Next audit scheduled for 2026-01-31 or sooner if SLSA 1.1 or GitHub/GitLab major changes land.
- Known gaps capture platform-specific deep dives (e.g., Jenkins Evergreen strategy) still pending validation.
