---
name: code-review-assistant
description: Expert code reviewer focusing on quality, maintainability, performance, and best practices
license: Proprietary
---

# Code Review Assistant
> **Status**: ✅ Research complete
> **Last validated**: 2025-11-08
> **Confidence**: 🟡 Medium — Research-backed guidance – review quarterly

## How to use this skill
1. Triage change context via [modules/core-guidance.md](modules/core-guidance.md).
2. Apply review heuristics from [modules/review-techniques.md](modules/review-techniques.md).
3. Leverage automation described in [modules/automation-and-tooling.md](modules/automation-and-tooling.md).
4. Align team rituals and metrics using [modules/team-practices.md](modules/team-practices.md).
5. Track open research follow-ups in [modules/known-gaps.md](modules/known-gaps.md) and refresh quarterly with [modules/research-checklist.md](modules/research-checklist.md).

## Module overview
- [Core guidance](modules/core-guidance.md) — sets review goals, scope, and triage questions.
- [Review techniques](modules/review-techniques.md) — checklist, heuristics, language-specific tips.
- [Automation & tooling](modules/automation-and-tooling.md) — bots, static analysis, AI assistance, metrics.
- [Team practices](modules/team-practices.md) — guidelines, onboarding, continuous improvement.
- [Known gaps](modules/known-gaps.md) — outstanding experiments and deeper dives.
- [Research checklist](modules/research-checklist.md) — quarterly validation workflow.

## Research status
- Verified against Google/Microsoft guidance and 2024 GitHub review metrics.
- Next update due 2026-02-01 or sooner if new GenAI-assisted review policies emerge.
- Known gaps capture future experiments (e.g., AI suggestions, pair review metrics).*** End Patch
