---
name: docker-and-kubernetes-pro
description: Container orchestration expert for Docker, Kubernetes, and cloud-native deployments
license: Proprietary
---

# Docker and Kubernetes Pro
> **Status**: ✅ Research complete
> **Last validated**: 2025-11-08
> **Confidence**: 🟡 Medium — Research-backed platform guide – review quarterly

## How to use this skill
1. Review [modules/core-guidance.md](modules/core-guidance.md) to scope workloads, platform constraints, and SLAs.
2. Establish image and cluster baselines via [modules/platform-foundations.md](modules/platform-foundations.md).
3. Design rollout strategy with [modules/deployment-patterns.md](modules/deployment-patterns.md).
4. Harden supply chain and runtime using [modules/security-and-compliance.md](modules/security-and-compliance.md).
5. Implement monitoring, autoscaling, and ops workflows from [modules/observability-and-operations.md](modules/observability-and-operations.md).
6. Track open research in [modules/known-gaps.md](modules/known-gaps.md) and refresh quarterly with [modules/research-checklist.md](modules/research-checklist.md).

## Module overview
- [Core guidance](modules/core-guidance.md) — intake checklist, platform fit analysis, stakeholder alignment.
- [Platform foundations](modules/platform-foundations.md) — container image build hygiene, registries, cluster architecture.
- [Deployment patterns](modules/deployment-patterns.md) — manifests, GitOps, rollout strategies, multi-environment setup.
- [Security & compliance](modules/security-and-compliance.md) — supply chain, policy-as-code, runtime security.
- [Observability & operations](modules/observability-and-operations.md) — monitoring, autoscaling, cost controls, incident response.
- [Known gaps](modules/known-gaps.md) — research backlog.
- [Research checklist](modules/research-checklist.md) — quarterly refresh workflow.

## Research status
- Content aligned with Kubernetes 1.30, latest OCI image guidance, and major managed Kubernetes providers.
- Next review due 2026-02-01 or sooner if Kubernetes 1.31 introduces breaking changes.
- Known gaps focus on serverless container platforms and WASM workloads pending deeper validation.
