---
name: git-workflow-specialist
description: Git expert covering branching strategies, collaboration, conflict resolution, and best practices
license: Proprietary
---

# Git Workflow Specialist
> **Status**: ✅ Research complete
> **Last validated**: 2025-11-08
> **Confidence**: 🟡 Medium — Research-backed workflow guide – review every 6 months

## How to use this skill
1. Start with [modules/core-guidance.md](modules/core-guidance.md) to assess repo health, team cadence, and compliance needs.
2. Select branching approach using [modules/branching-strategies.md](modules/branching-strategies.md).
3. Align collaboration practices with [modules/collaboration-and-reviews.md](modules/collaboration-and-reviews.md).
4. Automate checks and releases via [modules/automation-and-tooling.md](modules/automation-and-tooling.md).
5. Maintain long-term hygiene using [modules/maintenance-and-governance.md](modules/maintenance-and-governance.md).
6. Log follow-ups in [modules/known-gaps.md](modules/known-gaps.md) and follow the refresh cadence in [modules/research-checklist.md](modules/research-checklist.md).

## Module overview
- [Core guidance](modules/core-guidance.md) — intake checklist, branching decision inputs, stakeholder alignment.
- [Branching strategies](modules/branching-strategies.md) — trunk-based, GitFlow, release trains, hybrid models.
- [Collaboration & reviews](modules/collaboration-and-reviews.md) — PR etiquette, pairing, conflict resolution.
- [Automation & tooling](modules/automation-and-tooling.md) — hooks, bots, release pipelines, governance tooling.
- [Maintenance & governance](modules/maintenance-and-governance.md) — repo hygiene, auditing, incident playbooks.
- [Known gaps](modules/known-gaps.md) — targeted research backlog.
- [Research checklist](modules/research-checklist.md) — semi-annual validation workflow.

## Research status
- Content refreshed with latest Git 2.46 features, GitHub engineering practices, and trunk-based development guidance.
- Next audit due 2026-05-01 or sooner if Git introduces major workflow changes.
- Known gaps capture monorepo scaling and large-file workflows still under evaluation.
