---
name: mcp-server-developer
description: Build, harden, document, and ship MCP servers to Claude standards with FastMCP 2.13+ architecture, disciplined tooling, and release-ready workflows.
license: Proprietary
---

# MCP Server Developer
> **Status**: ✅ Research complete
> **Last validated**: 2025-11-11
> **Confidence**: 🟢 High — Comprehensive MCP server development playbook – refresh quarterly or after major Anthropic updates

## How to use this skill
1. Ground yourself with [modules/core-guidance.md](modules/core-guidance.md).
2. For architecture decisions, jump to [modules/architecture-and-standards.md](modules/architecture-and-standards.md).
3. To set up a working dev loop, follow [modules/development-workflow.md](modules/development-workflow.md).
4. Use [modules/tooling-strategy.md](modules/tooling-strategy.md) to keep tool counts manageable.
5. Spin up a runnable template using [modules/minimal-mcp-server.md](modules/minimal-mcp-server.md).
6. Tailor AI IDE experiences (Cursor) via [modules/ai-ide-development.md](modules/ai-ide-development.md).
7. Understand the ecosystem trajectory via [modules/mcp-history-and-outlook.md](modules/mcp-history-and-outlook.md).
8. Choose install/distribution paths and cross-platform validation steps via [modules/distribution-and-installation.md](modules/distribution-and-installation.md).
9. Learn how to get noticed at marketplaces with [modules/ecosystem-and-publishing.md](modules/ecosystem-and-publishing.md).
10. Ideate standout server concepts (e.g., AirBnB planner) via [modules/innovation-playbook.md](modules/innovation-playbook.md).
11. Close out releases with [modules/release-readiness.md](modules/release-readiness.md).
12. Track remaining gaps in [modules/known-gaps.md](modules/known-gaps.md); schedule reviews via [modules/research-checklist.md](modules/research-checklist.md).***

## Research status
- Content cross-referenced with FastMCP 2.13+ docs, Anthropic skill-creator patterns, Advanced Memory standards, Cursor IDE documentation, community adoption threads, and current marketplaces (skillsmp.com, mcp.cool).
- Next review due 2026-02-15, or immediately if Anthropic ships FastMCP 2.14, updates MCPB packaging, or alters marketplace submission rules.
- Known gaps now center on automating parity test runs and collecting marketplace analytics snapshots.***
