# Ecosystem & Publishing

**Confidence**: 🟢 High
**Last validated**: 2025-11-11
**Primary sources**: skillsmp.com marketplace research, mcp.cool registry, Anthropic community announcements, personal outreach logs

---

## 1. Key Directories & Marketplaces

| Platform | Focus | Submission Process |
| --- | --- | --- |
| **skillsmp.com** | Claude skill & MCP server marketplace | Create account → submit listing with description, install instructions, GitHub link, icon. Admin review within 3–5 days. |
| **mcp.cool** | Curated list of MCP servers | Open GitHub PR adding entry to `servers.json`; include repo, description, categories. |
| **Anthropic Community Forum** | Announcements, feedback | Post in MCP release thread with screenshot, features, install steps, support link. |
| **Twitter / Bluesky / Mastodon** | Awareness | Share release notes, highlight unique capabilities or partnership use cases. |

Keep listings synchronized—users check multiple sources.

---

## 2. Listing Checklist

- Concise tagline (`Elevates travel planning with live AirBnB availability`).
- Feature bullets (3–5) with clear outcomes.
- Installation commands for both MCPB and npx/npm.
- Screenshot or GIF demonstrating tool usage in Claude Desktop.
- Support link (Issues tab, Discord, email).
- Privacy statement if handling user data.
- Version badge & update cadence.

---

## 3. Getting Noticed

- **Launch playbook**:
  1. Publish release notes & tag on GitHub.
  2. Update marketplaces (skillsmp, mcp.cool).
  3. Announce on Anthropic forum & social media.
  4. Offer office hours or demo session.
- **SEO tips**: include keywords (“Claude”, “MCP”, “FastMCP 2.13”, “Cursor install”) in descriptions.
- **Partnerships**: reach out to other MCP developers for cross-promotion or integration bundles.

---

## 4. Support & Maintenance

- Publish SLA (e.g., respond to issues within 48 hours).
- Maintain FAQ or troubleshooting guide (`docs/FAQ.md`).
- Collect telemetry (anonymous usage counts, error rates) to prioritize fixes.
- Encourage users to file feature requests; triage monthly.

---

## 5. Compliance & Branding

- Respect marketplace branding guidelines (icons, code of conduct).
- Ensure licensing is clear (MIT, Apache, proprietary).
- Provide disclaimers if aggregating third-party data (e.g., AirBnB API terms).
- If monetizing, clarify pricing and payment flow.

---

### Ecosystem Checklist
- [ ] Marketplace listings live and synchronized (skillsmp, mcp.cool).
- [ ] Announcements posted with visuals and install instructions.
- [ ] Support channels and SLA communicated.
- [ ] Telemetry or feedback loop established to guide roadmap.
- [ ] Compliance, branding, and licensing requirements met.

Cultivating a strong ecosystem presence accelerates adoption and distinguishes your MCP server in a growing marketplace.***
