---
name: microservices-architect
description: Microservices design expert covering service decomposition, communication patterns, and distributed systems
license: Proprietary
---

# Microservices Architect
> **Status**: ✅ Research complete
> **Last validated**: 2025-11-08
> **Confidence**: 🟡 Medium — Research-backed architecture playbook – review semi-annually

## How to use this skill
1. Begin with [modules/core-guidance.md](modules/core-guidance.md) to evaluate drivers, constraints, and team readiness.
2. Design service topology using [modules/architecture-foundations.md](modules/architecture-foundations.md).
3. Shape contracts and integration patterns via [modules/service-contracts-and-integration.md](modules/service-contracts-and-integration.md).
4. Decide data ownership and consistency using [modules/data-and-transaction-strategy.md](modules/data-and-transaction-strategy.md).
5. Implement platform operations with [modules/platform-operations.md](modules/platform-operations.md).
6. Enforce governance from [modules/security-and-compliance.md](modules/security-and-compliance.md).
7. Track follow-ups in [modules/known-gaps.md](modules/known-gaps.md) and revisit [modules/research-checklist.md](modules/research-checklist.md) every six months.

## Module overview
- [Core guidance](modules/core-guidance.md) — intake checklist, success metrics, anti-pattern signals.
- [Architecture foundations](modules/architecture-foundations.md) — service boundaries, team topology, deployment models.
- [Service contracts & integration](modules/service-contracts-and-integration.md) — REST/gRPC/eventing strategies, schema governance.
- [Data & transaction strategy](modules/data-and-transaction-strategy.md) — data ownership, consistency, saga/outbox patterns.
- [Platform operations](modules/platform-operations.md) — observability, resilience, scalability, cost.
- [Security & compliance](modules/security-and-compliance.md) — zero trust, policy-as-code, auditing.
- [Known gaps](modules/known-gaps.md) — active research backlog.
- [Research checklist](modules/research-checklist.md) — semi-annual refresh plan.

## Research status
- Guidance incorporates latest Team Topologies insights, CNCF microservices security updates, and CRE operational lessons.
- Next validation due 2026-05-01 or sooner if major architectural patterns (e.g., WASM services) mature.
- Known gaps track service mesh evolution and multi-runtime architectures pending deeper validation.
