---
name: performance-tuning-expert
description: Application performance specialist for profiling, optimization, and scaling strategies
license: Proprietary
---

# Performance Tuning Expert
> **Status**: ✅ Research complete
> **Last validated**: 2025-11-08
> **Confidence**: 🟡 Medium — Research-backed tuning playbook – review semi-annually

## How to use this skill
1. Triage performance goals via [modules/core-guidance.md](modules/core-guidance.md).
2. Instrument and profile using [modules/profiling-and-metrics.md](modules/profiling-and-metrics.md).
3. Apply backend optimizations from [modules/backend-optimization.md](modules/backend-optimization.md).
4. Improve user-facing performance using [modules/frontend-and-client.md](modules/frontend-and-client.md).
5. Tune runtime and infrastructure with [modules/infrastructure-and-runtime.md](modules/infrastructure-and-runtime.md).
6. Lock improvements through [modules/regression-testing-and-guardrails.md](modules/regression-testing-and-guardrails.md).
7. Track additional research in [modules/known-gaps.md](modules/known-gaps.md) and follow the cadence in [modules/research-checklist.md](modules/research-checklist.md).

## Module overview
- [Core guidance](modules/core-guidance.md) — intake checklist, prioritization criteria, ROI framing.
- [Profiling & metrics](modules/profiling-and-metrics.md) — observability setup, profiling stacks, benchmarking.
- [Backend optimization](modules/backend-optimization.md) — language/runtime tuning, data access improvements.
- [Frontend & client](modules/frontend-and-client.md) — Core Web Vitals, mobile optimization, offline strategies.
- [Infrastructure & runtime](modules/infrastructure-and-runtime.md) — caching, autoscaling, hardware selection.
- [Regression testing & guardrails](modules/regression-testing-and-guardrails.md) — load testing, CI integration, alerting.
- [Known gaps](modules/known-gaps.md) — ongoing research backlog.
- [Research checklist](modules/research-checklist.md) — semi-annual review plan.

## Research status
- Material incorporates latest Web Vitals, Netflix/AWS performance engineering guidance, and mechanical sympathy insights.
- Next validation due 2026-05-01 or earlier if significant runtime updates land (e.g., JVM, Node, Rust).
- Known gaps cover ML/AI workloads and eBPF observability patterns pending deeper study.
