---
name: security-best-practices-expert
description: Application security specialist covering OWASP top 10, secure coding, and vulnerability prevention
license: Proprietary
---

# Security Best Practices Expert
> **Status**: ✅ Research complete
> **Last validated**: 2025-11-11
> **Confidence**: 🟢 High — Research backed with Nov 2025 sources – track quarterly updates

## How to use this skill
1. Establish context using [modules/core-guidance.md](modules/core-guidance.md).
2. Embed security into delivery via [modules/secure-sdlc.md](modules/secure-sdlc.md).
3. Harden application layer using [modules/application-security.md](modules/application-security.md).
4. Protect cloud and infrastructure through [modules/cloud-and-infrastructure.md](modules/cloud-and-infrastructure.md).
5. Enhance detection & response with [modules/detection-and-response.md](modules/detection-and-response.md).
6. Maintain regulatory posture via [modules/compliance-and-governance.md](modules/compliance-and-governance.md).
7. Log improvement items in [modules/known-gaps.md](modules/known-gaps.md) and revisit [modules/research-checklist.md](modules/research-checklist.md) quarterly.

## Module overview
- [Core guidance](modules/core-guidance.md) — risk intake, threat landscape alignment, stakeholder mapping.
- [Secure SDLC](modules/secure-sdlc.md) — shift-left, tooling, secure delivery pipelines.
- [Application security](modules/application-security.md) — OWASP mitigations, dependency management, secure coding guidelines.
- [Cloud & infrastructure](modules/cloud-and-infrastructure.md) — IaC scanning, secrets, zero trust networking.
- [Detection & response](modules/detection-and-response.md) — logging, SIEM, incident response.
- [Compliance & governance](modules/compliance-and-governance.md) — policy enforcement, audit readiness.
- [Known gaps](modules/known-gaps.md) — active research backlog.
- [Research checklist](modules/research-checklist.md) — quarterly refresh workflow.

## Research status
- Content aligns with latest OWASP, NIST SSDF, NCCoE guidance, CIS v8.1, CNCF security SIG advisories, and 2025 cloud vendor best-practice updates.
- Next targeted review: 2026-02-15 (or earlier if OWASP publishes Top 10 refresh or NIST finalizes SSDF Rev.1).
- Known gaps reduced to niche areas (SBOM automation workflows, post-quantum crypto roadmap, AI security playbooks).
