---
name: testing-strategy-guide
description: Test automation expert covering unit tests, integration tests, TDD, and testing best practices
license: Proprietary
---

# Testing Strategy Guide
> **Status**: ✅ Research complete
> **Last validated**: 2025-11-08
> **Confidence**: 🟡 Medium — Research-backed testing playbook – review semi-annually

## How to use this skill
1. Begin with [modules/core-guidance.md](modules/core-guidance.md) to capture context and risk profile.
2. Design test portfolio using [modules/test-pyramid-and-planning.md](modules/test-pyramid-and-planning.md).
3. Build sustainable automation with [modules/automation-frameworks.md](modules/automation-frameworks.md).
4. Cover non-functional requirements via [modules/non-functional-testing.md](modules/non-functional-testing.md).
5. Integrate into CI and monitor via [modules/ci-integration-and-observability.md](modules/ci-integration-and-observability.md).
6. Govern quality metrics through [modules/quality-metrics-and-governance.md](modules/quality-metrics-and-governance.md).
7. Record future improvements in [modules/known-gaps.md](modules/known-gaps.md) and revisit [modules/research-checklist.md](modules/research-checklist.md) twice a year.

## Module overview
- [Core guidance](modules/core-guidance.md) — intake, risk matrix, stakeholder alignment.
- [Test pyramid & planning](modules/test-pyramid-and-planning.md) — strategy, coverage, prioritization.
- [Automation frameworks](modules/automation-frameworks.md) — tooling, architecture, maintenance.
- [Non-functional testing](modules/non-functional-testing.md) — performance, security, accessibility, resilience.
- [CI integration & observability](modules/ci-integration-and-observability.md) — pipelines, flake reduction, analytics.
- [Quality metrics & governance](modules/quality-metrics-and-governance.md) — KPIs, dashboards, process control.
- [Known gaps](modules/known-gaps.md) — research backlog.
- [Research checklist](modules/research-checklist.md) — semi-annual refresh plan.

## Research status
- Testing strategy reflects Google/ThoughtWorks guidance plus recent automation standards.
- Next review due 2026-05-01 or earlier if major framework updates occur.
- Known gaps track AI-assisted testing and chaos engineering maturity tasks awaiting deeper research.
