# Inspira UI Components Quick Reference

Complete list of all 120+ components organized by category.

> **💡 Need complete implementation details?** For full props documentation, code examples, and installation instructions, fetch:
> https://inspira-ui.com/docs/llms-full.txt (LLM-optimized documentation)

## 🌌 Backgrounds (24)

| Component | Description | Dependencies |
|-----------|-------------|--------------|
| Aurora Background | Subtle Aurora/Southern Lights effect with radial gradients | motion-v |
| Black Hole Background | Canvas-driven warped tunnel with animated discs, radial lines | Canvas API |
| Bubbles Background | Three.js animated floating bubbles with gradient colors | three |
| Cosmic Portal | Animated 3D portal with glowing rings and floating crystals | three |
| Falling Stars | Animated starfield with glowing and sharp trail effects | Canvas API |
| Flickering Grid | Canvas-based flickering grid pattern | Canvas API |
| Interactive Grid Pattern | SVG-based interactive background grid | SVG |
| Lamp Effect | Captivating lamp lighting with conic gradients | CSS |
| Liquid Background | Reactive dynamic effect using OGL for WebGL visuals | ogl |
| Neural Background | Shader-powered animated background with fluid visuals | ogl, GLSL |
| Particle Whirlpool | Whirlpool particle animation effect | Canvas API |
| Particles Background | Classic particle background animation | Canvas API |
| Pattern Background | Reusable animated patterns (grid, dot variants) | SVG |
| Ripple | Ripple effect background animation | CSS |
| Silk Background | Smooth silk-like background effect | CSS |
| Snowfall Background | Animated falling snow particles | Canvas API |
| Sparkles | Sparkling animated background effect | Canvas API |
| Stars Background | Twinkling stars background | Canvas API |
| Stractium Background | Abstract stractium-style background | Canvas API |
| Tetris | Animated falling tetris blocks background | Canvas API |
| Video Text | Text with video background effect | Video API |
| Vortex | Swirling vortex background effect | Canvas API |
| Warp Background | Warp speed effect background | Canvas API |
| Wavy Background | Animated wavy pattern background | CSS |

## 🔘 Buttons (5)

| Component | Description | Dependencies |
|-----------|-------------|--------------|
| Gradient Button | Rotating conic gradient border with customizable properties | CSS |
| Interactive Hover Button | Dynamic transitions with light/dark mode adaptation | motion-v |
| Rainbow Button | Rainbow gradient effect on hover | CSS |
| Ripple Button | Ripple effect with customizable colors and duration | CSS |
| Shimmer Button | Shimmering animated gradient effect | CSS |

## 🃏 Cards (6)

| Component | Description | Dependencies |
|-----------|-------------|--------------|
| 3D Card Effect | Card perspective effect with element elevation on hover | motion-v |
| Apple Card Carousel | Apple-style carousel with blur-loading and modal expansion | motion-v |
| Card Spotlight | Dynamic spotlight effect following mouse cursor | CSS |
| Direction Aware Hover | Image card with directional hover effects | motion-v |
| Flip Card | Smooth 180-degree flipping animations | motion-v |
| Glare Card | Linear-website-style glare effect on hover | CSS |

## 🖱️ Cursors (5)

| Component | Description | Dependencies |
|-----------|-------------|--------------|
| Fluid Cursor | GPU-accelerated animated cursor trail simulating fluid motion | ogl |
| Image Trail Cursor | Dynamic trail of images following mouse movement | motion-v |
| Sleek Line Cursor | Reactive animated cursor trail with wave-like motion | motion-v |
| Smooth Cursor | Physics-based smooth cursor animation | motion-v |
| Tailed Cursor | Colorful ribbon cursor trail with WebGL and shaders | ogl |

## 📱 Device Mocks (2)

| Component | Description | Dependencies |
|-----------|-------------|--------------|
| iPhone Mockup | SVG mockup of iPhone with customizable content | SVG |
| Safari Mockup | SVG mockup of Safari browser with customizable content | SVG |

## ✏️ Input and Forms (5)

| Component | Description | Dependencies |
|-----------|-------------|--------------|
| Color Picker | Comprehensive color picker with multiple formats | @vueuse/core |
| File Upload | Modern file upload with 3D card effect and drag-and-drop | motion-v |
| Halo Search | Futuristic search input with glowing rings | CSS |
| Input | Versatile dynamic input field with radial hover effects | CSS |
| Placeholders and Vanish Input | Sliding placeholders with vanish effect on submit | motion-v |

## 🎨 Miscellaneous (24)

| Component | Description | Dependencies |
|-----------|-------------|--------------|
| Animate Grid | Skew animation grid with box shadow | motion-v |
| Animated Circular Progress Bar | Circular gauge with percentage value | motion-v |
| Animated List | Sequentially animated list with timed delays | motion-v |
| Animated Testimonials | Engaging animated testimonial component with auto-play | motion-v |
| Animated Tooltip | Tooltip that follows mouse pointer on hover | @vueuse/core |
| Balance Slider | Dynamic balance slider with adjustable colors and limits | @vueuse/core |
| Bento Grid | Grid layout with different child components | CSS |
| Book | 3D book component with customizable sizes and gradients | CSS |
| Compare | Slide to compare any two pieces of content | @vueuse/core |
| Container Scroll | Container scrolling effect with scaling and rotating | motion-v |
| Dock | macOS-style dock with magnifying icons on hover | motion-v |
| Expandable Gallery | Responsive image gallery with interactive hover expansion | CSS |
| Images Slider | Full-page slider with keyboard navigation | motion-v |
| Lens | Lens component to zoom into images or videos | @vueuse/core |
| Link Preview | Dynamic link previews for anchor tags | @vueuse/core |
| Marquee | Auto-scrolling marquee component | CSS |
| Morphing Tabs | Tabs with morphing transitions | motion-v |
| Multi-Step Loader | Loading animation for multi-step processes | motion-v |
| Photo Gallery | Responsive photo gallery layout | CSS |
| Scroll Island | Floating scroll-based navigation island | @vueuse/core |
| Shader Toy | Embed shader toy effects | GLSL |
| SVG Mask | SVG masking effects for images/content | SVG |
| Testimonial Slider | Slider for testimonials | motion-v |
| Timeline | Vertical timeline component | CSS |
| Tracing Beam | Animated beam that traces paths | SVG |

## ✨ Special Effects (12)

| Component | Description | Dependencies |
|-----------|-------------|--------------|
| Animated Beam | SVG beam connecting elements with animation | SVG |
| Border Beam | Animated border beam effect with customizable properties | CSS |
| Confetti | Confetti animations for celebrations | canvas-confetti |
| Glow Border | Animated glowing border effect | CSS |
| Glowing Effect | Proximity-based glow effect reacting to mouse and scroll | @vueuse/core |
| Meteors | Meteor shower animation with customizable meteor count | CSS |
| Neon Border | Neon border component with customizable animations | CSS |
| Particle Image | Particle animation applied to images | Canvas API |
| Scratch To Reveal | Interactive scratch-off effect revealing hidden content | Canvas API |
| Spring Calendar | Animated calendar widget with spring transitions | motion-v |

## 📝 Text Animations (24)

| Component | Description | Dependencies |
|-----------|-------------|--------------|
| 3D Text | Stylish 3D text with customizable colors and shadows | CSS |
| Blur Reveal | Smooth blur fade-in content animation | motion-v |
| Box Reveal | Animated box reveal effect | motion-v |
| Colorful Text | Text with various colors, filter, and scale effects | motion-v |
| Container Text Flip | Container that flips through words | motion-v |
| Flip Words | Component that flips through a list of words | motion-v |
| Focus | Highlight words with blurred effect and focus frame | motion-v |
| Hyper Text | Hyper changing text animation on hover | CSS |
| Letter Pullup | Staggered letter pull-up text animation | motion-v |
| Line Shadow Text | Text with line shadow effect | CSS |
| Morphing Text | Dynamic transitions between text strings | motion-v |
| Number Ticker | Animate numbers counting up or down | motion-v |
| Radiant Text | Glare effect on text | CSS |
| Sparkles Text | Dynamic text generating continuous sparkles | Canvas API |
| Spinning Text | Text animating in circular motion | CSS |
| Text Generate Effect | Text generation/typing effect | motion-v |
| Text Glitch | Glitch effect on text | CSS |
| Text Highlight | Highlight text with animated background | motion-v |
| Text Hover Effect | Custom hover effects for text | CSS |
| Text Reveal | Reveal text with animation | motion-v |
| Text Reveal Card | Card with text reveal animation | motion-v |
| Text Scroll Reveal | Reveal text on scroll | motion-v |

## 📊 Visualization (21)

| Component | Description | Dependencies |
|-----------|-------------|--------------|
| Bending Gallery | Curved, scrollable 3D gallery with WebGL | ogl |
| 3D Carousel | Dynamic interactive 3D carousel | three, motion-v |
| File Tree | Component showcasing folder and file structure | CSS |
| GitHub Globe | 3D interactive globe with arcs and points | three |
| Globe | Interactive rotating globe component | three |
| Icon Cloud | Interactive 3D tag cloud component | three |
| Infinite Grid | High-performance interactive 3D infinite grid | ogl |
| Light Speed | 3D highway speed visual effect | three |
| Liquid Glass Effect | Striking glassmorphism effect | SVG |
| Liquid Logo | WebGL-based dynamic liquid effect for logos | ogl |
| Logo Cloud | Animated company logo cloud | motion-v |
| Logo Origami | Animated flipping logo with origami effect | CSS |
| Orbit | Content animating in circular orbit | motion-v |
| Spline | Vue wrapper for Spline 3D tool | spline |
| World Map | Customizable world map with animated arcs | SVG |

## 🧱 Blocks (2)

| Block | Description | Components Used |
|-------|-------------|-----------------|
| Hero | Complete hero section blocks with various styles | Various |
| Testimonials | Complete testimonial section blocks | Animated Testimonials |

## Dependencies Summary

### Core (Required)
- `@vueuse/core` - Vue composition utilities
- `motion-v` - Vue animation library
- `clsx` - Class name utility
- `tailwind-merge` - Tailwind class merging
- `class-variance-authority` - Variant utilities
- `tw-animate-css` - Tailwind animation utilities

### Optional (Component-Specific)
- `three` & `@types/three` - For 3D components (Globe, Cosmic Portal, etc.)
- `ogl` - For WebGL/shader components (Fluid Cursor, Liquid Background, etc.)
- `gsap` - For advanced animations (select components)
- `canvas-confetti` - For Confetti component
- `spline` - For Spline component

## Usage Pattern

1. **Browse**: Visit https://inspira-ui.com/components
2. **Copy**: Copy the component code you need
3. **Paste**: Add to your `components/ui/` directory
4. **Install**: Install component-specific dependencies if needed
5. **Customize**: Modify colors, sizes, animations to fit your design

## Component Files Location

When copying components, typical structure:
```
your-project/
├── components/
│   └── ui/
│       ├── AuroraBackground.vue
│       ├── ShimmerButton.vue
│       ├── FlipCard.vue
│       └── ...
├── lib/
│   └── utils.ts (cn utility)
└── assets/
    └── main.css (CSS variables)
```

## Quick Links

- **Component Gallery**: https://inspira-ui.com/components
- **Installation Guide**: https://inspira-ui.com/docs/getting-started/installation
- **GitHub**: https://github.com/unovue/inspira-ui
- **Discord**: https://discord.gg/Xbh5DwJRc9

---

**Last Updated**: 2025-11-12
**Total Components**: 120+
**Blocks**: 2
