---
name: nano-banana-prompts
description: Generate optimized prompts for Gemini 2.5 Flash Image (Nano Banana). Use for image generation, crafting photo prompts, art styles, or multi-turn editing workflows with best practices.
license: MIT
---

# Nano Banana Image Prompt Generator

Generate high-quality prompts for Gemini 2.5 Flash Image using proven best practices from October 2025.

## Core Principle

**Describe scenes naturally, don't list keywords.**

❌ `woman, business suit, office, professional`
✅ `A professional businesswoman in navy suit stands confidently in modern glass-walled office overlooking city skyline. Warm afternoon light streams through windows.`

## Prompt Structure

### Basic Template

```
A [SHOT TYPE] of [SUBJECT] [ACTION] in [ENVIRONMENT]. 
[LIGHTING] creates [MOOD]. [CAMERA/STYLE DETAILS]. [ASPECT RATIO].
```

### Components

1. **Subject & Action** - Who/what and what they're doing
2. **Setting** - Where the scene takes place
3. **Lighting** - Natural/artificial light sources and quality
4. **Mood** - Emotional tone or atmosphere
5. **Technical Details** - Camera, lens, style specifics
6. **Format** - Aspect ratio or dimensions

## Prompt Length

- **Short (10-20 words)**: Quick generation, minimal control
- **Medium (50-100 words)**: ⭐ RECOMMENDED - balanced control
- **Long (100-200 words)**: Maximum control for complex scenes

## Photography Prompts

### Template
```
Photorealistic [SHOT TYPE] of [SUBJECT], [ACTION], in [ENVIRONMENT]. 
Illuminated by [LIGHTING], creating [MOOD]. Captured with [CAMERA/LENS], 
emphasizing [DETAILS]. [ASPECT RATIO] format.
```

### Camera Control

**Lenses:**
- 35mm, 50mm (standard)
- 85mm portrait (close-ups)
- 10-24mm wide (landscapes)
- 60-105mm macro (details)

**Lighting:**
- Golden hour (warm, soft)
- Blue hour (cool, atmospheric)
- Three-point (studio)
- Dramatic side (high contrast)
- Rembrandt (classic portrait)

**Settings:**
- Shallow DOF: f/1.4-2.8 (blurred background)
- Deep focus: f/11-22 (everything sharp)
- Motion blur for action

### Example
```
Professional corporate headshot of mid-30s woman with shoulder-length brown hair 
in charcoal blazer. She's smiling warmly at camera against soft gray backdrop. 
Shot with 85mm f/2.0, studio three-point lighting creates gentle shadows defining 
facial features. Ultra-high resolution, LinkedIn-ready quality. 1:1 format.
```

## Art & Illustration Prompts

### Template
```
[STYLE] illustration of [SUBJECT] [ACTION/POSE]. [COMPOSITION] with 
[COLOR PALETTE]. [TECHNIQUE/MEDIUM]. Inspired by [REFERENCE], 
emphasizing [QUALITIES].
```

### Common Styles
- Watercolor painting
- Digital art
- Oil painting
- Pencil sketch
- Ink drawing
- Anime/manga
- Pixel art
- Minimalist vector

### Example
```
Watercolor illustration of young girl reading book under oak tree. Seated 
cross-legged in sun-dappled clearing with wildflowers. Soft, loose brushstrokes 
with pastel color palette of greens, yellows, pinks. Transparent washes create 
dreamy, ethereal quality. Inspired by children's book illustration, emphasizing 
wonder and tranquility. 4:5 portrait format.
```

## Text Rendering

**Best Practices:**
- Keep under 25 characters total
- Maximum 2-3 phrases
- Specify font style (bold, script, sans-serif)
- Put exact text in quotes
- Describe position explicitly

**Example:**
```
Movie poster with bold red text "SUMMER" at top and "Adventure Awaits" 
in white script font at bottom. Ocean sunset background. Cinematic style.
```

## Multi-Turn Editing Workflow

Nano Banana excels at conversational editing. Make one change at a time.

**Example sequence:**
1. "Create professional headshot of woman in business attire"
2. "Change background to modern office"
3. "Make her wearing glasses"
4. "Add warmer lighting"

## Product Photography

### Template
```
High-resolution product photo of [PRODUCT] on [SURFACE]. [LIGHTING] 
to [PURPOSE]. Camera angle: [TYPE] to showcase [FEATURE]. Ultra-realistic, 
sharp focus on [DETAIL]. [ASPECT RATIO].
```

### Example
```
High-resolution product photo of stainless steel smartwatch on white marble 
surface. Soft diffused studio lighting from 45-degree angle to minimize 
reflections and show screen clearly. Camera angle: slight overhead to showcase 
circular face and metal band texture. Ultra-realistic, sharp focus on watch 
face display. 1:1 format for e-commerce.
```

## Landscape Photography

### Template
```
[TYPE] landscape of [LOCATION] at [TIME]. [WEATHER/ATMOSPHERE]. 
[FOREGROUND ELEMENTS]. Shot with [LENS] from [VANTAGE POINT]. 
[COMPOSITION]. Professional landscape photography with [GRADING]. [MOOD].
```

### Example
```
Dramatic landscape of mountain lake at golden hour. Wispy clouds catch 
warm orange light over snow-capped peaks. Weathered dock extends into 
mirror-still water as foreground. Shot with 16mm wide-angle from low 
lakeside vantage. Rule-of-thirds composition places horizon in upper third. 
Professional landscape photography with warm color grading. Serene yet majestic.
```

## Abstract Art

### Template
```
[MOVEMENT] abstract exploring [CONCEPT]. [COMPOSITION] with [COLORS/TEXTURES]. 
[MEDIUM] emphasizing [GOALS]. [CONTEXT].
```

### Example
```
Bold geometric abstract exploring tension and harmony. Overlapping angular 
shapes with vibrant primary colors against deep black. Digital art emphasizing 
sharp edges and color interaction. Large-scale wall art format, 16:9.
```

## Common Pitfalls

**Avoid:**
- Keyword lists without context
- Vague descriptions
- Conflicting style instructions
- Overly complex text rendering
- Too many simultaneous changes in edits

**Instead:**
- Use complete sentences
- Be specific about details
- Maintain style consistency
- Keep text simple
- Edit iteratively

## Style References

When requesting specific artistic styles, reference:
- Art movements (impressionism, art deco)
- Artists (in style of Van Gogh's brushwork)
- Media (watercolor, oil painting, digital art)
- Eras (1950s photography, modern minimalist)

## Aspect Ratios

- **1:1** - Square (social media, profile pics)
- **16:9** - Landscape (presentations, headers)
- **9:16** - Portrait (mobile, stories)
- **4:5** - Portrait (Instagram posts)
- **2:3** - Classic portrait
- **3:2** - Standard photo

## Quick Prompt Checklist

✅ Subject clearly described
✅ Action or pose specified
✅ Environment/setting detailed
✅ Lighting source and quality
✅ Mood or atmosphere
✅ Style or technical specs
✅ Aspect ratio chosen
✅ Complete sentences, not keywords

## Common Issues & Solutions

### Prompt Quality Issues

**Issue**: Generic or vague output
**Cause**: Prompt too short or lacks specificity
**Solution**: Expand to 50-100 words. Add lighting details, mood, and specific technical specs (lens, style, etc.).

**Example**:
- ❌ Too vague: "A woman in an office"
- ✅ Specific: "Professional businesswoman in navy suit stands confidently in modern glass-walled office overlooking city skyline at golden hour. Warm afternoon light streams through floor-to-ceiling windows creating soft rim lighting. Shot with 50mm f/2.0, shallow depth of field blurs cityscape background. Confident yet approachable mood. 4:5 portrait format."

**Issue**: Conflicting style instructions
**Cause**: Mixing incompatible styles (e.g., "photorealistic watercolor")
**Solution**: Choose one primary style. For photography, use camera terminology. For art, use medium/technique terminology.

**Issue**: Text rendering failures
**Cause**: Too much text, complex fonts, or unclear positioning
**Solution**:
- Limit to under 25 characters total
- Use simple, clear fonts (bold, script, sans-serif)
- Specify exact position ("at top", "centered", "bottom right")
- Put text in quotes: "SUMMER"

**Issue**: Unwanted elements in image
**Cause**: Ambiguous phrasing or conflicting descriptors
**Solution**: Be explicit about what should NOT appear. Use precise, unambiguous language.

### Generation Issues

**Issue**: Image doesn't match prompt
**Cause**: Prompt too complex or contradictory elements
**Solution**:
1. Simplify prompt to core concept
2. Use multi-turn editing workflow
3. Start basic, refine iteratively

**Issue**: Inconsistent results across generations
**Cause**: Vague descriptors allowing wide interpretation
**Solution**: Add specific details about colors, materials, lighting angles, camera settings, and composition rules (rule of thirds, golden ratio).

**Issue**: Poor composition
**Cause**: No compositional guidance in prompt
**Solution**: Explicitly mention composition rules:
- "Rule of thirds composition"
- "Centered subject with symmetrical framing"
- "Leading lines draw eye to focal point"
- "Foreground, mid-ground, background layers"

### Multi-Turn Editing Issues

**Issue**: Too many changes at once causing confusion
**Cause**: Requesting multiple edits simultaneously
**Solution**: Make one change per turn. Wait for result before next edit.

**Example sequence**:
1. ✅ "Change background to sunset"
2. ✅ "Make the lighting warmer"
3. ✅ "Add reflections on water"
vs.
4. ❌ "Change background to sunset with warmer lighting and add reflections"

**Issue**: Losing context from earlier turns
**Cause**: Vague references without reinforcing key details
**Solution**: Briefly reinforce context: "In this mountain landscape, add a hiking trail in the foreground"

## Prompt Validation

Before submitting a prompt, verify:

### Content Completeness
- [ ] Subject clearly identified (who/what)
- [ ] Action or state described (what subject is doing)
- [ ] Environment/setting specified (where)
- [ ] Lighting described (source, quality, direction)
- [ ] Mood or atmosphere indicated (emotional tone)
- [ ] Style or medium specified (photography, watercolor, etc.)
- [ ] Aspect ratio chosen (1:1, 16:9, 4:5, etc.)

### Technical Specifications

**For Photography:**
- [ ] Camera/lens mentioned (50mm, 85mm, wide-angle)
- [ ] Camera settings if relevant (f/2.8, shallow DOF)
- [ ] Lighting type (golden hour, studio three-point, dramatic side)
- [ ] Shot type (close-up, wide shot, overhead)

**For Art/Illustration:**
- [ ] Medium specified (watercolor, digital art, oil painting)
- [ ] Technique mentioned (loose brushstrokes, sharp vector)
- [ ] Color palette described (pastels, vibrant, monochrome)
- [ ] Style reference if applicable (children's book, manga, minimalist)

### Quality Checks
- [ ] Uses complete sentences, not keyword lists
- [ ] Specific rather than vague ("charcoal blazer" vs. "suit")
- [ ] No conflicting style instructions
- [ ] Text under 25 characters if included
- [ ] Length appropriate: 50-100 words for balanced control
- [ ] No contradictory elements (photorealistic watercolor)

### Text Rendering Validation

If prompt includes text:
- [ ] Total characters under 25
- [ ] Maximum 2-3 text phrases
- [ ] Text in quotes ("SUMMER")
- [ ] Font style specified (bold, script, sans-serif)
- [ ] Position explicitly stated (top, bottom, centered)
- [ ] Text color contrasts with background

## Testing Your Prompts

### Quick Test
Generate image and evaluate:
1. **Subject accuracy**: Is the main subject as described?
2. **Composition**: Does layout match prompt intent?
3. **Lighting**: Is lighting source and quality correct?
4. **Style**: Does aesthetic match requested style?
5. **Technical specs**: Are camera/art specs honored?
6. **Mood**: Does image convey intended atmosphere?

### Refinement Workflow

If image doesn't match expectations:

**Step 1: Identify the gap**
- What element is wrong/missing?
- Is it subject, lighting, style, composition, or mood?

**Step 2: Use multi-turn editing**
- Don't regenerate from scratch
- Make targeted edit: "Make the lighting softer"
- One change at a time

**Step 3: Refine prompt for future use**
- If you need to regenerate, add more specificity to weak areas
- Save successful prompts as templates

### Comparison Test

For critical images, generate 2-3 variations with slightly different prompts:

**Version A**: Medium detail (50-75 words)
**Version B**: High detail (100-150 words)
**Version C**: Different style/lighting approach

Compare results to find optimal prompt verbosity and approach.

## Example: Complete Validation

**Prompt**:
```
Photorealistic close-up portrait of elderly fisherman with weathered hands mending
fishing net at dawn. Seated on wooden dock with misty harbor in background. Soft
golden light from rising sun creates warm rim lighting on his profile. Shot with
85mm f/2.0 creating shallow depth of field, net and hands in sharp focus while
background gently blurs. Contemplative and peaceful mood. 4:5 portrait format.
```

**Validation**:
- ✅ Subject: elderly fisherman
- ✅ Action: mending fishing net
- ✅ Environment: wooden dock at harbor
- ✅ Lighting: golden hour, rim lighting
- ✅ Mood: contemplative, peaceful
- ✅ Technical: 85mm f/2.0, shallow DOF
- ✅ Aspect ratio: 4:5 portrait
- ✅ Complete sentences: yes
- ✅ Specific details: weathered hands, wooden dock, misty harbor
- ✅ Length: ~85 words (optimal range)
- ✅ Style consistency: photorealistic throughout

**Expected result**: High-quality, detailed image matching all specifications.

## Troubleshooting Guide

| Problem | Likely Cause | Fix |
|---------|--------------|-----|
| Blurry/low quality | Missing technical specs | Add camera, lens, "ultra-high resolution" |
| Wrong colors | Vague color description | Specify exact colors, hex codes if needed |
| Bad composition | No compositional guidance | Add "rule of thirds", "centered", etc. |
| Missing elements | Element mentioned too late | Put critical elements early in prompt |
| Generic look | Keyword listing | Rewrite as natural sentences |
| Text garbled | Too much text | Reduce to <25 chars, simplify font |
| Wrong style | Conflicting instructions | Choose one consistent style |
| Unexpected objects | Ambiguous phrasing | Be more explicit and specific |
