# Monaco Social Security Contribution Rates

**Last Updated**: October 27, 2025
**Effective Date**: October 1, 2025
**Source**: Caisses Sociales de Monaco - https://www.caisses-sociales.mc/

## Overview

Monaco's social security system requires contributions across three main institutions:
1. **CCSS** - Caisses de Compensation pour les Services Sociaux (Social Security)
2. **C.A.R.** - Caisse Autonome des Retraites (Retirement/Pension)
3. **CMRC** - Caisse Monégasque de Retraites Complémentaires (Supplementary Pension)

## Contribution Ceilings (Plafonds de Cotisation)

### Monthly Base (Base Mensuelle)
- **C.C.S.S.**: €9,800.00
- **C.A.R.**: €6,112.00

### Annual Base (Base Annuelle)
- **C.C.S.S.**: €117,600.00
- **C.A.R.**: €73,344.00

## CCSS - Social Security Contributions

### Rate and Calculation Method

**Rate**: 13.40% of the contribution base (as of October 1, 2025)

### Contribution Base Calculation

The contribution base varies depending on the employment situation:

**For household employees (employeurs de gens de maison):**
- For employers with 1 or 2 household employees
- For monthly global activity less than 254 hours
- **Base = 33% of gross salary**

**For medical care situations:**
- If presence of a sick caregiver or life auxiliary medically motivated for home maintenance
- **Base = 33% of gross salary**

**For all other cases:**
- **Base = 100% of declared salary**

### Ceiling
- Monthly ceiling: €9,800.00
- Annual ceiling: €117,600.00

### Payment
- **Employer pays 100%** of CCSS contributions
- No employee deduction for CCSS

## C.A.R. - Retirement/Pension Contributions

### Contribution Rates

| Party | Rate | Notes |
|-------|------|-------|
| **Employer** | 8.33% | Paid by employer |
| **Employee** | 6.85% | Deducted from gross salary |
| **Total** | 15.18% | Combined rate |

### Contribution Base
- Applied to gross salary up to the monthly ceiling

### Ceiling
- Monthly ceiling: €6,112.00
- Annual ceiling: €73,344.00

### Example Calculation (€3,500 gross salary)
- Employee contribution: €3,500 × 6.85% = €239.75
- Employer contribution: €3,500 × 8.33% = €291.55
- Total: €531.30

## CMRC - Supplementary Pension Contributions

The CMRC system uses a two-tier (tranche) structure with different rates.

### Tranche A - Up to €3,971

**Contribution Rates:**
- Rights-generating (d'acquisition des droits): 7.87%
- Non-rights-generating (non générateur de droits): 2.15%
- **Total**: 10.02%

**Distribution:**
- Employer: 60% = 6.01%
- Employee: 40% = 4.01%

**Ceiling**: €3,971 per month

### Tranche B - Above €3,971 up to 8x Tranche A Ceiling

**Contribution Rates:**
- Rights-generating (d'acquisition des droits): 21.59%
- Non-rights-generating (non générateur de droits): 2.70%
- **Total**: 24.29%

**Distribution:**
- Employer: 60% = 14.57%
- Employee: 40% = 9.72%

**Range**: From €3,971 to €31,768 (8 × €3,971)

### CMRC Calculation Examples

#### Example 1: Salary of €3,000 (below Tranche A ceiling)
- Base: €3,000 (all in Tranche A)
- Total CMRC: €3,000 × 10.02% = €300.60
- Employer: €300.60 × 60% = €180.36
- Employee: €300.60 × 40% = €120.24

#### Example 2: Salary of €5,000 (spans both tranches)
**Tranche A (€3,971):**
- Total: €3,971 × 10.02% = €397.89
- Employer: €397.89 × 60% = €238.73
- Employee: €397.89 × 40% = €159.16

**Tranche B (€1,029 = €5,000 - €3,971):**
- Total: €1,029 × 24.29% = €249.94
- Employer: €249.94 × 60% = €149.96
- Employee: €249.94 × 40% = €99.98

**Combined:**
- Employer: €238.73 + €149.96 = €388.69
- Employee: €159.16 + €99.98 = €259.14
- Total: €647.83

## Complete Contribution Summary

### For Household Employees (Gens de Maison)

#### Employee Contributions (Deducted from Gross Salary)
1. **C.A.R. (Retirement)**: 6.85% (up to €6,112 ceiling)
2. **CMRC (Supplementary Pension)**:
   - Tranche A: 4.01% (up to €3,971)
   - Tranche B: 9.72% (€3,971 to €31,768)

#### Employer Contributions (Added to Employment Cost)
1. **CCSS (Social Security)**: 13.40% of 33% of gross salary (for 1-2 employees, <254h)
2. **C.A.R. (Retirement)**: 8.33% (up to €6,112 ceiling)
3. **CMRC (Supplementary Pension)**:
   - Tranche A: 6.01% (up to €3,971)
   - Tranche B: 14.57% (€3,971 to €31,768)

### For Standard Employees

#### Employee Contributions
1. **C.A.R. (Retirement)**: 6.85% (up to €6,112 ceiling)
2. **CMRC (Supplementary Pension)**:
   - Tranche A: 4.01% (up to €3,971)
   - Tranche B: 9.72% (€3,971 to €31,768)

#### Employer Contributions
1. **CCSS (Social Security)**: 13.40% of full gross salary (up to €9,800 ceiling)
2. **C.A.R. (Retirement)**: 8.33% (up to €6,112 ceiling)
3. **CMRC (Supplementary Pension)**:
   - Tranche A: 6.01% (up to €3,971)
   - Tranche B: 14.57% (€3,971 to €31,768)

## Complete Payslip Examples

### Example 1: Household Employee - €2,500 Gross Monthly Salary

**Employee Contributions:**
- C.A.R.: €2,500 × 6.85% = €171.25
- CMRC Tranche A: €2,500 × 4.01% = €100.25
- **Total Employee**: €271.50 (10.86%)

**Net Salary**: €2,500 - €271.50 = **€2,228.50**

**Employer Contributions:**
- CCSS: (€2,500 × 33%) × 13.40% = €825 × 13.40% = €110.55
- C.A.R.: €2,500 × 8.33% = €208.25
- CMRC Tranche A: €2,500 × 6.01% = €150.25
- **Total Employer**: €469.05 (18.76% of gross)

**Total Employer Cost**: €2,500 + €469.05 = **€2,969.05**

### Example 2: Household Employee - €3,500 Gross Monthly Salary

**Employee Contributions:**
- C.A.R.: €3,500 × 6.85% = €239.75
- CMRC Tranche A: €3,500 × 4.01% = €140.35
- **Total Employee**: €380.10 (10.86%)

**Net Salary**: €3,500 - €380.10 = **€3,119.90**

**Employer Contributions:**
- CCSS: (€3,500 × 33%) × 13.40% = €1,155 × 13.40% = €154.77
- C.A.R.: €3,500 × 8.33% = €291.55
- CMRC Tranche A: €3,500 × 6.01% = €210.35
- **Total Employer**: €656.67 (18.76% of gross)

**Total Employer Cost**: €3,500 + €656.67 = **€4,156.67**

### Example 3: Standard Employee - €5,000 Gross Monthly Salary

**Employee Contributions:**
- C.A.R.: €5,000 × 6.85% = €342.50
- CMRC:
  - Tranche A (€3,971): €159.16
  - Tranche B (€1,029): €99.98
  - CMRC Total: €259.14
- **Total Employee**: €601.64 (12.03%)

**Net Salary**: €5,000 - €601.64 = **€4,398.36**

**Employer Contributions:**
- CCSS: €5,000 × 13.40% = €670.00
- C.A.R.: €5,000 × 8.33% = €416.50
- CMRC:
  - Tranche A (€3,971): €238.73
  - Tranche B (€1,029): €149.96
  - CMRC Total: €388.69
- **Total Employer**: €1,475.19 (29.50% of gross)

**Total Employer Cost**: €5,000 + €1,475.19 = **€6,475.19**

## Special Cases

### Part-Time Employees
The same rates and ceilings apply to part-time employees. Contributions are calculated on the actual gross salary earned.

### Multiple Jobs
If an employee works for multiple employers, each employer calculates contributions independently up to the respective ceilings. The employee may need to declare multiple employments to the Caisses Sociales.

### Expatriates
Special rules may apply for expatriate workers. Consult directly with Caisses Sociales de Monaco for specific situations.

## Rate Change History

### 2025 (Effective October 1, 2025) - Current Rates
- CCSS: 13.40%
- C.A.R.: Employee 6.85%, Employer 8.33%
- CMRC Tranche A: 10.02% (60/40 split)
- CMRC Tranche B: 24.29% (60/40 split)
- Ceilings: C.C.S.S. €9,800/month, C.A.R. €6,112/month, CMRC Tranche A €3,971

## Official Resources

### Primary Sources

**Caisses Sociales de Monaco**
- Website: https://www.caisses-sociales.mc/
- Employer portal: https://employeur.caisses-sociales.mc/
- Calculator: https://employeur.caisses-sociales.mc/RCDSDeclCITsZkHP/indexCalculBS.zul

**Monaco Government**
- Website: https://www.gouv.mc/

**Journal de Monaco**
- Official gazette for legal announcements and rate changes

### Contact Information

**Caisses Sociales de Monaco**
- Address: 22-24 Rue du Gabian, MC 98000 Monaco
- Phone: +377 97 98 58 00
- Email: info@caisses-sociales.mc

## Important Notes

1. **Contribution rates are subject to change** by Monaco authorities through official decrees

2. **Household employee special rate**: The 33% base for CCSS only applies to employers with 1-2 household employees with less than 254 hours of monthly activity

3. **Ceilings are annual limits** divided by 12 for monthly calculations. If an employee earns more in certain months, the annual ceiling still applies

4. **CMRC tranches are progressive**: Contributions in Tranche B only apply to the portion of salary above the Tranche A ceiling

5. **Tax is separate**: These contributions do not include income tax, which has different rules in Monaco based on nationality and residency

## Verification

These rates were extracted from official Monaco government documentation dated October 1, 2025. For critical payroll calculations:
- Verify current rates on the official website
- Use the official online calculator when available
- Consult with qualified Monaco payroll specialists for complex situations
- Keep documentation of rate changes for historical payslip verification

## How to Update the Calculator

When rates change:

1. **Update the Python script** (`scripts/payslip_calculator.py`):
   - CCSS_RATE (line 32)
   - CAR_EMPLOYEE_RATE and CAR_EMPLOYER_RATE (lines 37-38)
   - CMRC rates (lines 45, 50)
   - Ceilings (lines 34, 40, 44)
   - RATES_EFFECTIVE_DATE (line 56)

2. **Update this documentation** with new rates and effective date

3. **Test calculations** against official Monaco calculator

4. **Update examples** in this document and README

5. **Document previous rates** in the Rate Change History section

## Disclaimer

This document is based on official Monaco social security rates effective October 1, 2025. Rates and rules are subject to change by Monaco authorities. Always verify current rates with official sources before making actual payroll calculations. For critical or complex situations, consult with qualified Monaco payroll specialists or accountants.
