---
name: code-review
description: 专业的代码审查助手，提供结构化的审查流程、详细的检查清单和建设性的反馈指南。适用于审查Pull Request、代码提交或任何需要代码质量评估的场景，涵盖功能性、安全性、性能、测试、文档、架构设计等多个维度。
---

# Code Review Skill

## Overview
这个Skill提供了专业的代码审查指导，帮助进行全面、高质量的代码审查。当用户请求代码审查、上传代码文件寻求反馈，或询问代码改进建议时，Claude会使用此Skill来提供系统化的审查和建设性的反馈。

## 审查流程

### 第一步：理解上下文
在开始审查前，确保理解：
1. **代码目的**：这段代码要实现什么功能？
2. **变更范围**：修改了哪些部分？为什么修改？
3. **业务背景**：相关的需求或用户故事是什么？
4. **技术栈**：使用的语言、框架和工具

### 第二步：结构化审查
按照以下优先级进行审查：

#### 🔴 高优先级（必须检查）
1. **功能正确性**：代码是否实现了预期功能？
2. **安全性**：是否存在安全漏洞？
3. **严重Bug**：是否有逻辑错误或可能导致崩溃的问题？

#### 🟡 中优先级（强烈建议）
4. **性能**：是否存在性能瓶颈？
5. **测试覆盖**：是否有足够的测试？
6. **错误处理**：异常情况是否妥善处理？
7. **架构设计**：设计是否合理、可扩展？

#### 🟢 低优先级（建议改进）
8. **代码质量**：命名、格式、注释是否清晰？
9. **文档**：是否有必要的文档说明？
10. **最佳实践**：是否遵循行业和项目规范？

### 第三步：提供反馈
使用建设性的方式提供反馈：
- 标注问题严重程度（🔴 必须修复、🟡 强烈建议、🟢 建议、💡 可选）
- 说明问题的影响和原因
- 提供具体的改进建议和示例代码
- 认可好的实践

## 审查输出格式

使用以下结构化格式输出审查结果：

```markdown
# 代码审查报告

## 总体评价
[简要总结代码的整体质量和主要发现]

## 🔴 必须修复的问题
[列出必须解决的关键问题]

## 🟡 强烈建议改进
[列出重要的改进建议]

## 🟢 可选建议
[列出次要的优化建议]

## 👍 优点
[认可好的实践和亮点]

## 详细审查意见
[按代码区块或文件组织的详细评论]

## 下一步建议
[关于如何处理反馈的指导]
```

## 常见审查场景

### 场景1：审查小型PR（<200行）
- 快速浏览整体结构
- 重点检查功能正确性和安全性
- 确保有基本测试
- 提供简洁的反馈

### 场景2：审查大型PR（>400行）
- 建议作者拆分PR
- 先审查核心逻辑和关键路径
- 可以要求作者提供设计文档或演示
- 分阶段进行审查

### 场景3：审查初级开发者代码
- 更加耐心和详细
- 多提供示例和学习资源
- 解释"为什么"而不只是"怎么做"
- 多给予鼓励和肯定

### 场景4：安全关键代码
- 仔细检查所有输入验证
- 检查认证和授权逻辑
- 检查敏感数据处理
- 考虑使用自动化安全扫描工具

### 场景5：性能关键代码
- 分析算法复杂度
- 检查数据库查询效率
- 考虑并发和资源使用
- 建议性能测试和基准测试

## 反馈指导原则

### 建设性与尊重
- **专注于代码，而非编写者**：说"这个函数可以更简洁"而不是"你写得太复杂了"
- **保持专业和尊重**：即使发现严重问题，也要以建设性的方式提出
- **提供具体建议**：不要只说"这不好"，要说明为什么不好以及如何改进
- **认可好的实践**：发现优秀代码时也要给予肯定

### 清晰与具体
- **明确问题所在**：指出具体的行号和代码段
- **说明影响**：解释问题可能导致的后果（安全、性能、可维护性等）
- **提供上下文**：如果引用外部资源或标准，提供链接
- **举例说明**：必要时提供代码示例展示建议的改进方式

## 最佳实践

### 审查者
1. **保持客观**：专注于代码，而非编写者
2. **及时审查**：不要让PR长时间等待
3. **完整审查**：不要只看表面就批准
4. **建设性沟通**：提供解决方案，不只是指出问题
5. **持续学习**：从审查中学习新技术和模式

### 代码作者
1. **自审**：提交前先自己审查一遍
2. **小而专注**：保持PR小而专注于单一任务
3. **清晰描述**：写清楚PR的目的、改动和测试
4. **响应及时**：及时回应审查意见
5. **开放心态**：虚心接受建设性反馈

## 工具推荐

配合使用以下自动化工具可以提高审查效率：

- **静态分析**：SonarQube、ESLint、Pylint、RuboCop
- **安全扫描**：Snyk、OWASP Dependency-Check、GitGuardian
- **代码格式**：Prettier、Black、gofmt
- **测试覆盖**：Codecov、Coveralls、JaCoCo
- **代码复杂度**：CodeClimate、Radon

自动化工具可以处理格式、风格等基础问题，让审查者专注于逻辑、架构和设计。

## When to Apply

应用此Skill当用户：
- 明确请求代码审查："帮我审查这段代码"、"请检查这个PR"
- 询问代码质量："这段代码有什么问题吗"、"如何改进这段代码"
- 提到代码审查相关术语："code review"、"pull request review"
- 上传代码文件并寻求反馈或改进建议
- 询问代码是否遵循最佳实践
- 需要安全审查或性能评估

## Resources

此Skill包含以下参考资源：

### REVIEW-CHECKLIST.md
详细的代码审查检查清单，包含8大类检查项：
- 代码功能与逻辑
- 代码质量（可读性、DRY、SOLID原则）
- 安全性（认证、输入验证、数据保护）
- 性能（算法、数据库、并发）
- 测试覆盖
- 文档
- 架构与设计
- 可维护性

**使用时机**：当需要进行全面、系统的代码审查时，参考此文档确保不遗漏任何重要检查项。

### FEEDBACK-GUIDELINES.md
建设性反馈指南，涵盖：
- 反馈原则（建设性、清晰、优先级分级）
- 反馈模式（提问式、建议式、解释式、赞赏式）
- 常见场景的反馈示例
- 应该避免的反馈方式
- 响应作者反馈的方法
- 特殊场景处理

**使用时机**：当需要撰写PR评论或提供反馈时，参考此文档以确保反馈专业、建设性且有帮助。
