# 代码审查Skill - 使用说明

## 📦 文件说明

- **code-review.zip**: 代码审查Skill安装包（已修正为正确的YAML frontmatter格式）

## 🎯 简介

这是一个专业的代码审查Skill，帮助你进行全面、高质量的代码审查。基于2025年最新的代码审查最佳实践创建。

## ✅ 格式说明

此Skill使用正确的YAML frontmatter格式：
```yaml
---
name: code-review
description: ...
---
```

**重要**：
- Skill名称必须使用小写字母、数字和连字符
- 不能包含空格或大写字母
- 必须以YAML frontmatter格式开头（用 `---` 包围）

## ✨ 主要功能

### 1. 结构化审查流程
- **三步骤流程**：理解上下文 → 结构化审查 → 提供反馈
- **优先级分级**：🔴 必须修复、🟡 强烈建议、🟢 建议、💡 可选

### 2. 详细检查清单（8大维度）
- ✅ 代码功能与逻辑
- ✅ 代码质量（可读性、DRY、SOLID原则）
- ✅ 安全性（认证、输入验证、数据保护）
- ✅ 性能（算法效率、数据库查询、并发处理）
- ✅ 测试覆盖（单元测试、集成测试）
- ✅ 文档（代码注释、API文档）
- ✅ 架构与设计（设计模式、模块化、扩展性）
- ✅ 可维护性（代码复杂度、错误处理、日志）

### 3. 建设性反馈指南
- 多种反馈模式：提问式、建议式、解释式、赞赏式
- 常见场景的反馈示例
- 避免的反馈方式指导

## 🚀 安装方法

1. **下载文件**
   - 下载 `code-review.zip`

2. **安装到Claude**
   - 打开Claude设置（Settings）
   - 找到 Skills 或 Custom Instructions 部分
   - 选择上传/导入功能
   - 选择下载的 `code-review.zip` 文件
   - 等待安装完成

## 📝 使用方式

### 自动触发
当你说以下内容时，Claude会自动使用此Skill：

- "帮我审查这段代码"
- "请检查这个PR"
- "这段代码有什么问题吗"
- "代码审查" / "code review"
- "给我一些代码改进建议"
- 上传代码文件并寻求反馈

### 使用示例

#### 示例1：日常PR审查
```
请帮我审查这个PR，主要是添加了用户注册功能。

[粘贴代码或提供文件]
```

#### 示例2：安全审查
```
请从安全角度审查这段API代码，检查是否存在
SQL注入、XSS等安全隐患。

[粘贴代码]
```

#### 示例3：性能优化
```
这段代码处理大量数据时很慢，请帮我找出性能瓶颈。

[粘贴代码]
```

#### 示例4：学习改进
```
我是初级开发者，请审查我的代码并给出详细的改进建议。

[粘贴代码]
```

## 📊 审查报告格式

你会收到结构化的审查报告：

```markdown
# 代码审查报告

## 总体评价
[整体质量评估]

## 🔴 必须修复的问题
[关键问题列表]

## 🟡 强烈建议改进
[重要改进建议]

## 🟢 可选建议
[次要优化建议]

## 👍 优点
[好的实践和亮点]

## 详细审查意见
[详细评论]

## 下一步建议
[处理指导]
```

## 🎓 最佳实践

### 提交审查前
1. ✅ 先自己审查一遍代码
2. ✅ 确保代码可运行并通过基本测试
3. ✅ 准备好代码的上下文信息

### 接收反馈时
1. ✅ 仔细阅读每条反馈
2. ✅ 区分必须修复和建议性改进
3. ✅ 对不理解的反馈及时提问
4. ✅ 虚心接受建设性意见

### 持续改进
1. ✅ 从每次审查中学习
2. ✅ 记录常见问题和解决方案
3. ✅ 逐步提高代码质量标准

## 🛠️ 推荐配合工具

建议配合以下自动化工具使用：

- **静态分析**: SonarQube, ESLint, Pylint, RuboCop
- **安全扫描**: Snyk, OWASP Dependency-Check, GitGuardian
- **代码格式**: Prettier, Black, gofmt
- **测试覆盖**: Codecov, Coveralls, JaCoCo
- **代码复杂度**: CodeClimate, Radon

## 📚 包含的资源

此Skill包含两个详细的参考文档：

### REVIEW-CHECKLIST.md
- 完整的代码审查检查清单
- 覆盖8大类检查项
- 可用作审查checklist

### FEEDBACK-GUIDELINES.md
- 建设性反馈原则
- 多种反馈模式和示例
- 特殊场景处理指导

## ⚠️ 注意事项

- 代码审查的目的是提高质量，而非批评个人
- 审查意见应该建设性、具体、有帮助
- 不同优先级的问题应该区别对待
- 保持开放心态，欢迎讨论和改进

## 🔄 版本信息

- **版本**: 1.0.0
- **创建日期**: 2025-10-23
- **兼容性**: Claude (所有版本)

## 💡 常见问题

**Q: Skill会自动运行吗？**
A: 是的，当你提出代码审查相关请求时会自动触发。

**Q: 可以只用于特定编程语言吗？**
A: 此Skill支持所有编程语言的代码审查。

**Q: 如何获得更详细的反馈？**
A: 明确说明你关注的方面（如"重点检查安全性"），或要求"全面深入的审查"。

**Q: 可以审查多个文件吗？**
A: 可以，但建议一次专注于一个文件或相关的小组文件以获得最佳结果。

## 🤝 反馈与改进

如果在使用过程中有任何问题或改进建议，欢迎反馈！

---

**祝你代码审查愉快！** 🚀
