# Evidence Gathering Framework

## Purpose

After understanding customer jobs and creating personas, gather evidence from the real world to:
- Validate assumptions about customer needs
- Discover what solutions already exist
- Identify gaps and opportunities
- Understand competitive landscape
- Find patterns in customer feedback
- Inform solution direction

## Five Evidence Sources

### 1. Social Media Listening

**What to look for:**
- Customer complaints and frustrations about current solutions
- Feature requests and wishlist items
- Workarounds people have created
- Communities and discussions around the problem space
- Influencer perspectives and trending topics

**Where to look:**
- Twitter/X (hashtags, keywords, discussions)
- Reddit (relevant subreddits, search posts)
- LinkedIn (professional perspectives, B2B insights)
- Facebook Groups (community discussions, recommendations)
- Instagram (visual evidence, lifestyle context)
- TikTok (how people actually use things, hacks)
- YouTube (reviews, tutorials, complaints)
- Local/regional platforms (WeChat, WhatsApp groups, Telegram, local forums)

**Questions to explore:**
- What are people complaining about?
- What workarounds have they invented?
- What language do they use to describe the problem?
- Who are the influential voices?
- What solutions get recommended?

---

#### Social Media Listening: Specific Search Templates

**Twitter/X Search Strategies:**

*Basic pain point discovery:*
```
"I hate how [problem area]..."
"Why is [task] so difficult"
"[Product type] should..."
"Wish there was a way to..."
```

*Workaround identification:*
```
"Here's my hack for [problem]"
"Pro tip for [task]"
"My workaround for [pain]"
```

*Competitive intelligence:*
```
"[Competitor] is so frustrating"
"Just switched from [Competitor A] to [Competitor B]"
"Better alternative to [Competitor]?"
```

*Example for mobile lending:*
```
"I hate how banks require so much paperwork"
"Why is getting a small loan so difficult"
"Wish there was instant lending for market traders"
"My workaround for cash flow problems"
```

**Reddit Search Strategies:**

*Find relevant subreddits:*
- Search for industry keywords
- Look at subscriber count and activity level
- Check post frequency (active > 10 posts/week)

*Search within subreddits:*
```
title:[keyword] AND (frustrating OR annoying OR broken OR terrible)
title:[keyword] AND (alternative OR better OR switching)
flair:"Help" OR flair:"Question" [keyword]
```

*Sort by:*
- Top (past year) - highest signal
- Controversial - reveals polarizing pain points
- New - current trends

*Example searches for FairCredit (mobile lending):*
```
subreddit:smallbusiness title:loan AND (rejected OR denied OR frustrating)
subreddit:Entrepreneur title:financing AND alternative
```

**LinkedIn Search Strategies:**

*For B2B insights:*
```
"The biggest challenge in [industry] is..."
"[Problem space] pain points"
"Why [current solution] doesn't work"
```

*Follow relevant hashtags:*
- #[Industry]Challenges
- #[ProblemSpace]
- #[UserSegment]

*Join relevant groups:*
- Industry-specific communities
- Professional associations
- Problem-focused groups

**YouTube Search Strategies:**

*Tutorial and review analysis:*
```
"[Product type] review"
"How to [task] - the hard way"
"[Competitor] pros and cons"
"[Task] tutorial"
```

*Look for:*
- Comments with complaints
- Workarounds in video descriptions
- "Why I switched" videos
- Comparison videos

**Local/Regional Platform Guidance:**

**For emerging markets:**
- **WhatsApp:** Join local business/community groups (ask contacts for intros)
- **Telegram:** Search for [country/region + industry] channels
- **WeChat:** Follow accounts related to problem space (China)
- **Local forums:** Google "[country] + [problem space] + forum"

**For specific regions:**
- Nigeria: Nairaland forum, Nigerian Twitter
- India: LocalCircles, Indian subreddits (r/india, r/bangalore)
- Southeast Asia: e27 forums, HardwareZone (Singapore), Kaskus (Indonesia)
- Latin America: Country-specific Facebook groups, Taringa (Spanish)
- Middle East: Arabic Twitter, country-specific forums

---

#### Social Media Listening: Time-Boxed Approach

**Quick (20 minutes):**
- Pick 1 platform (Twitter or Reddit)
- 3-5 keyword searches
- Skim top 20 results per search
- Capture 3-5 key quotes

**Standard (1-2 hours):**
- Pick 2-3 platforms
- 5-10 keyword searches per platform
- Review top 50 results per search
- Join 1-2 communities, read recent discussions
- Capture 8-12 quotes and patterns

**Deep (4+ hours):**
- All relevant platforms
- Comprehensive keyword mapping
- Join 5+ communities, participate/lurk
- Analyze influencer perspectives
- Track hashtags over time (use tools)
- 20+ quotes captured with context

---

#### Social Media Analysis Tools (Optional)

**Free tools:**
- Twitter Advanced Search (filter by date, location, engagement)
- Reddit Search syntax (title:, flair:, author:)
- Google Alerts (set up for keywords)
- Answer The Public (question clustering)

**Paid tools (if available):**
- Brandwatch / Mention (social listening)
- BuzzSumo (content analysis, influencer identification)
- Sprout Social (social analytics)

**Note:** Manual search is often sufficient for innovation discovery. Don't over-invest in tools.

### 2. Market & Competitor Analysis

**What to examine:**
- Existing solutions (direct and indirect competitors)
- Product reviews and ratings
- Feature comparisons
- Pricing models and strategies
- Go-to-market approaches
- Success stories and failures

**Where to look:**
- Product Hunt (new products, launches)
- App stores (reviews, ratings, feature lists)
- G2, Capterra (B2B software reviews)
- Amazon reviews (product feedback)
- Company websites and marketing materials
- Funding announcements (Crunchbase, TechCrunch)
- Industry reports and analyst perspectives

**Questions to explore:**
- What exists already? Who are the players?
- What do customers love? What do they hate?
- Where are the gaps in current offerings?
- What pricing are customers willing to pay?
- How saturated is the market?
- What recent trends or shifts have occurred?

### 3. Customer Feedback & Support Data

**What to analyze:**
- Support tickets and common issues
- Feature requests and product feedback
- User interviews and surveys
- Usability test results
- Churn reasons and exit interviews
- NPS scores and verbatim comments

**Where to find it:**
- Your own customer data (if you have it)
- Public forums where customers discuss products
- Review sites with detailed feedback
- User research repositories
- Customer advisory board insights
- Sales team feedback

**Questions to explore:**
- What problems come up repeatedly?
- What features do users request most?
- Why do customers leave competitors?
- What moments delight vs. frustrate?
- What use cases weren't anticipated?

### 4. Technology & Trend Scanning

**What to track:**
- Emerging technologies that enable new solutions
- Platform shifts (mobile-first, AI, blockchain, etc.)
- Regulatory changes affecting the space
- Cultural/societal trends
- Economic factors and market dynamics
- Infrastructure developments

**Where to look:**
- Tech news (TechCrunch, The Verge, Wired)
- Academic research (Google Scholar, arxiv)
- Industry conferences and reports
- Government/regulatory announcements
- Trend reports (McKinsey, Gartner, Forrester)
- Innovation showcases and accelerators

**Questions to explore:**
- What's now possible that wasn't before?
- What constraints are being removed?
- What's the "why now" for this solution?
- What tailwinds or headwinds exist?
- What adjacent spaces provide inspiration?

### 5. Direct Customer Research

**What to conduct:**
- User interviews (1-on-1 conversations)
- Contextual inquiry (observe in natural environment)
- Surveys (quantitative validation)
- Focus groups (group dynamics and discussion)
- Diary studies (track over time)
- Beta testing and feedback

**How to approach:**
- Recruit personas that match your target
- Ask about jobs, pains, and current solutions
- Observe actual behavior (not just what they say)
- Test assumptions and hypotheses
- Validate findings from other sources
- Iterate based on learning

**Questions to explore:**
- How do they currently solve this job?
- What's the sequence of steps they take?
- What emotions do they experience?
- What do they wish existed?
- What would they pay for a solution?

## Evidence Gathering Workflow

### 1. Choose Your Depth Level

Select based on time available and uncertainty level:

#### Quick Evidence Gathering (1 hour)
**When to use:** Low risk idea, familiar problem space, time-constrained

**Approach:**
- 1-2 evidence sources only
- High-level pattern identification
- Minimal competitive analysis

**Output:**
- 3-5 key findings
- Basic competitive landscape (who exists, rough positioning)
- 2-3 customer quotes

#### Standard Evidence Gathering (3-5 hours) **[Recommended]**
**When to use:** Most innovation projects, moderate uncertainty

**Approach:**
- 3-4 evidence sources
- Pattern identification across sources
- Competitive landscape with gaps identified
- Direct customer language captured

**Output:**
- 8-12 key findings organized by category
- Competitive landscape with strengths/weaknesses
- 5-8 customer quotes
- Pricing signals and willingness-to-pay indicators
- "Why now" factors identified

#### Deep Evidence Gathering (8+ hours)
**When to use:** High investment decision, high uncertainty, unfamiliar market

**Approach:**
- All 5 evidence sources
- Comprehensive competitive analysis
- Multiple customer interviews/research
- Trend analysis and market dynamics

**Output:**
- 15-20+ detailed findings
- Comprehensive competitive landscape with positioning map
- 10-15 customer quotes across segments
- Market size and growth estimates
- Regulatory and technology trend analysis

---

### 2. Define Research Questions
Based on JTBD and persona, identify what you need to learn:
- Validation questions: "Is this pain real and widespread?"
- Discovery questions: "What else should we know?"
- Solution questions: "What's already been tried?"

### 3. Select Evidence Sources
Choose sources based on your depth level and context:

**Quick (1 hour) - Pick 1-2:**
- Social media (Twitter/LinkedIn quick search)
- Competitor website review
- App Store/G2 reviews

**Standard (3-5 hours) - Pick 3-4:**
- B2C consumer products → Social media + App reviews + Customer research
- B2B enterprise → LinkedIn + G2 reviews + Customer interviews
- Emerging markets → Local platforms + Direct research (social listening may be limited)
- Hardware/physical → Amazon reviews + YouTube + Observation

**Deep (8+ hours) - All 5 sources:**
- Social media listening
- Market & competitor analysis
- Customer feedback & support data
- Technology & trend scanning
- Direct customer research

### 4. Gather & Synthesize
- **Quick:** 1 hour total, skim for top patterns
- **Standard:** 3-5 hours, look for patterns across sources (recommended)
- **Deep:** 8+ hours, comprehensive analysis with triangulation

Key principles:
- Look for patterns, not comprehensive coverage
- Capture direct quotes and specific examples
- Note contradictions and edge cases (they reveal complexity)
- Identify strongest signals

### 5. Organize Findings
Structure evidence into categories:

**Validation:**
- Confirms: [What validated your assumptions]
- Contradicts: [What surprised you or contradicted expectations]

**Landscape:**
- Existing solutions: [What's out there, who's doing it]
- Gaps & opportunities: [What's missing, underserved segments]

**Customer Voice:**
- Key quotes: [Direct customer language]
- Pain intensity: [How urgent/frequent is the problem]
- Willingness to pay: [Pricing signals]

**Trends & Context:**
- Enabling factors: [What's making this possible now]
- Headwinds: [What makes this harder]

## Evidence Gathering Template

```markdown
# Evidence Gathering: [Problem Space]

## Research Questions
1. [Validation question]
2. [Discovery question]
3. [Solution question]

## Sources Used
- [Source 1: e.g., Reddit r/productivity, 100 posts reviewed]
- [Source 2: e.g., 10 user interviews with target personas]
- [Source 3: e.g., 25 competitor products analyzed]

## Key Findings

### Validation
**Confirms:**
- [Finding 1 with supporting evidence]
- [Finding 2 with supporting evidence]

**Contradicts:**
- [Surprising finding 1]
- [Surprising finding 2]

### Landscape
**Existing Solutions:**
- [Solution 1: strengths, weaknesses, pricing]
- [Solution 2: strengths, weaknesses, pricing]

**Gaps & Opportunities:**
- [Unmet need 1]
- [Underserved segment 1]
- [Emerging opportunity 1]

### Customer Voice
**Key Quotes:**
- "[Direct customer quote 1]"
- "[Direct customer quote 2]"

**Pain Intensity:**
- Frequency: [How often problem occurs]
- Severity: [Impact when it occurs]
- Current coping: [What they do today]

**Willingness to Pay:**
- [Price signals from research]
- [Competitive pricing benchmarks]

### Trends & Context
**Enabling Factors:**
- [Technology/trend making this possible]
- [Market dynamic creating opportunity]

**Headwinds:**
- [Challenge or barrier to consider]
- [Risk factor]

## Implications for Solution
[2-3 key insights that should inform solution direction]
```

## Tips for Effective Evidence Gathering

**Do:**
- Focus on recent evidence (last 6-12 months)
- Look for patterns across multiple sources
- Capture customer language and quotes
- Consider global context (solutions vary by market)
- Balance online and offline evidence
- Note what's NOT being said (silent needs)

**Don't:**
- Spend weeks researching (diminishing returns)
- Only look at successful solutions (failures teach too)
- Ignore contradictory evidence (it reveals complexity)
- Assume Western markets represent global reality
- Rely only on one type of evidence
- Skip this step (assumptions are dangerous)

## Common Pitfalls

**Analysis paralysis:** Set time limit (3-5 hours), then synthesize
**Confirmation bias:** Actively seek contradicting evidence
**Surface-level:** Go deeper than just feature lists—understand why
**Western bias:** Include evidence from target markets, not just US/Europe
**Recency bias:** Look at sustained patterns, not just latest buzz

## Output

After evidence gathering, you should have:
1. Validated (or refined) your JTBD and persona
2. Clear picture of competitive landscape
3. Identified gaps and opportunities
4. Customer language and quotes
5. Pricing and monetization signals
6. Understanding of "why now"

This evidence informs the next phase: defining your solution direction.
