# Example Outputs - Customer Discovery

These examples demonstrate the complete customer-discovery process with globally diverse personas.

---

## Example 1: Mobile Micro-Lending Service (Nigeria)

### Jobs-to-be-Done Analysis

**Job Statement:**
"When I need urgent cash for business inventory or family emergency, I want to access a small loan quickly without collateral or complex paperwork, so I can seize opportunities or handle crises. This helps me feel secure and capable (emotional) and maintain my reputation as a reliable business person and family provider (social)."

**Functional Jobs:**
- Access 5,000-50,000 Naira ($12-$120 USD) within hours
- Repay loan in flexible installments over 1-3 months
- Build credit history for future borrowing
- Avoid predatory informal lenders
- Maintain business cash flow during seasonal fluctuations

**Emotional Jobs:**
- Feel financially secure and prepared
- Reduce anxiety about emergencies
- Feel empowered and in control
- Avoid shame of asking family for money
- Build confidence in business decisions

**Social Jobs:**
- Maintain dignity and independence
- Be seen as reliable business operator
- Demonstrate responsibility to family
- Show progress and growth in community
- Avoid stigma of debt collectors

**Pains (Current Situation):**
- Banks require collateral, payslips, and minimum balances
- Loan officer (informal lender) charges 20-30% monthly interest
- Loan sharks harass and embarrass if payment late
- Family loans create obligations and tension
- ROSCAs (rotating savings) require waiting for turn
- Mobile app loans charge hidden fees, unclear terms
- No way to build credit history for future needs
- Paper documentation and physical bank visits take full day

**Gains (Desired):**
- Instant approval based on mobile money transaction history
- Transparent terms and fair interest rates (3-5% monthly)
- Flexible repayment aligned with business income cycles
- No collateral or guarantor required
- Builds credit score for future loans
- Privacy (family doesn't need to know)
- Respect and dignity in borrowing process
- Can access from phone, no bank visit

### Persona: Chidinma Okafor - The Determined Market Trader

**Profile:**
- Age: 34
- Occupation: Market trader (textiles and household goods)
- Location: Ikeja, Lagos, Nigeria
- Life stage: Married, three children (ages 6, 9, 12)

**Context:**
Chidinma runs a stall in Ikeja market selling textiles, household goods, and fashion accessories. She buys inventory weekly from wholesalers and sells retail with 20-30% markup. Business is good but cash flow is unpredictable—she might sell 80,000 Naira one week, 30,000 the next. When she sees good deals on inventory or needs to stock up before festivals (Christmas, Easter, Eid), she needs cash immediately. Her husband drives an okada (motorcycle taxi) with inconsistent income. They rent a one-room apartment. She uses feature phone primarily (voice, SMS, WhatsApp), shares an Android phone with her husband. All transactions are mobile money (Paga, OPay) or cash. She has no bank account—banks require too much documentation and minimum balance. When she needs money, she borrows from loan officer at 25% monthly interest or asks her ROSCA group.

**Jobs to Be Done:**
**Functional:** Access 15,000-40,000 Naira within 4 hours to buy inventory or handle emergency  
**Emotional:** Feel secure and avoid stress of begging or exploitation  
**Social:** Maintain reputation as successful trader and responsible mother

**Goals & Motivations:**
- Grow her trading business to rent a larger stall
- Send children to good school (current school is free but poor quality)
- Save for land or better housing
- Prove herself as independent businesswoman

**Pain Points & Challenges:**
- Cash flow gaps between inventory purchase and sales
- No collateral or payslip for traditional banks
- Loan officer's 25% interest eats into profit margins
- Missed opportunities when good deals appear (no quick cash)
- Fear of loan officers' aggressive collection tactics
- ROSCA requires waiting 3-4 months for her turn
- Can't build credit history to access larger loans
- Lost full day's sales last time she went to bank to inquire

**Behaviors:**
- **Decision-making:** Consults husband on loans above 20,000 Naira
- **Information sources:** Other traders, WhatsApp groups, radio ads
- **Technology use:** Basic mobile, comfortable with mobile money apps
- **Payment methods:** Mobile money primary, some cash, no cards

**Quote:**
"I'm not asking for charity—I just need fast money when opportunity comes, and I will pay back with fair interest. Why should I pay 25% when I'm a good businesswoman?"

### Evidence Gathering: Mobile Micro-Lending Service (Nigeria)

**Research Questions:**
1. How widespread is the pain of limited credit access for informal sector workers?
2. What mobile lending services exist and what are their reputations?
3. What drives trust and adoption in this market?

**Sources Used:**
- Reddit r/Nigeria, Nairaland forums (150 threads reviewed)
- Google Play Store reviews of 8 Nigerian lending apps
- 5 informal interviews with market traders in Lagos
- Reports from EFInA (Enhancing Financial Innovation & Access) Nigeria
- Social media analysis (Twitter, Facebook lending app discussions)

**Key Findings:**

**Validation:**

**Confirms:**
- Credit access is massive pain point: 63% of Nigerian adults excluded from formal banking (EFInA 2023)
- Loan officer exploitation is common: "They charge 30% and show up at your shop to embarrass you" (Nairaland quote)
- Mobile money adoption is high: 45M+ active mobile money users in Nigeria
- Informal sector is huge: 80%+ of urban workers are informal traders/operators

**Contradicts:**
- Users aren't afraid of digital lending—they're afraid of hidden fees and harassment
- Problem isn't education/literacy—it's trust and transparency
- Many have tried 2-3 apps already and been burned by surprise charges

**Landscape:**

**Existing Solutions:**
- **Carbon (formerly Paylater):** 1M+ downloads, 3.5★ rating. "Approved in 5 min but charged hidden fees I didn't see" (common complaint)
- **FairMoney:** 5M+ downloads, 3.8★ rating. "Better than loan officers but still expensive at 15-20%"
- **Branch:** 1M+ downloads, 3.2★ rating. "They approved me, I paid back 3 times, then suddenly denied with no explanation"
- **Traditional loan officers:** 25-40% monthly interest, physical harassment, but "at least you know the person"
- **ROSCAs (Ajo):** Free but requires waiting and group trust

**Gaps & Opportunities:**
- Transparency: Users don't understand total cost until it's too late
- Respect: Aggressive collection tactics cause trauma and embarrassment
- Flexibility: Fixed repayment schedules don't match informal income
- Credit building: No one rewards good repayment with better terms/rates
- Underserved segment: Female traders specifically mentioned feeling disrespected

**Customer Voice:**

**Key Quotes:**
- "I paid 10,000 back for a 8,000 loan. Where did the extra 2,000 come from? Hidden fees!" (Google Play review)
- "They called my contacts when I was only 2 days late. Embarrassed me to my customers." (Twitter)
- "I need a lender that treats me like a businesswoman, not a thief." (Interview)
- "Show me everything upfront. I can do maths, I'm not stupid." (Nairaland)
- "I repaid 4 times on time. Why am I still getting same 10,000 limit?" (Google Play)

**Pain Intensity:**
- Frequency: Weekly or bi-weekly need for working capital
- Severity: High - missing opportunity costs potential profit, family emergencies create crisis
- Current coping: Expensive loan officers, waiting for ROSCA turn, missing opportunities

**Willingness to Pay:**
- Survey data: 70% would use digital lender at 5% monthly vs. 25% loan officer rate
- Acceptable range: 3-7% monthly interest cited as "fair"
- Current competitor pricing: 15-30% monthly (all-in cost)
- Most important: Transparency over absolute cheapest rate

**Trends & Context:**

**Enabling Factors:**
- Mobile money infrastructure matured: 45M+ users, agent network everywhere
- Smartphone penetration growing: 60% in Lagos, shared devices common
- COVID accelerated digital payments adoption
- CBN (Central Bank) credit bureau data sharing improving
- Youth population familiar with apps and digital services

**Headwinds:**
- Reputation damage from predatory apps has created wariness
- Informal sector income hard to verify (no payslips)
- Default rates high when economy unstable (inflation, currency)
- Regulatory uncertainty around digital lending
- Data privacy concerns (who sees my mobile money history?)

**Implications for Solution:**
1. **Transparency first:** Show total cost upfront in simple terms
2. **Respectful collections:** Never call contacts, grace periods, human dignity
3. **Credit building:** Reward good behavior with better rates and higher limits
4. **Income-aware:** Flexible repayment matching informal income patterns
5. **Mobile-first:** Work on basic phones (SMS/USSD), not just smartphones
6. **Community-informed:** Use ROSCA principles (social proof, gradual trust)

---

## Example 2: Remote Team Collaboration Platform (Southeast Asia)

### Jobs-to-be-Done Analysis

**Job Statement:**
"When managing a distributed team across multiple time zones and languages, I want to coordinate work, share context, and build team cohesion without forcing everyone online simultaneously, so work gets done efficiently and team feels connected. This helps me feel confident as a leader (emotional) and demonstrate modern management capabilities (social)."

**Functional Jobs:**
- Assign tasks and track progress across 5-15 team members
- Share information and updates asynchronously (not everyone online together)
- Make decisions without requiring synchronous meetings
- Maintain project visibility and prevent work duplication
- Bridge language barriers (English, Mandarin, Bahasa, Thai, Vietnamese)

**Emotional Jobs:**
- Feel connected to team despite physical distance
- Reduce anxiety about whether work is happening
- Build confidence in team's capabilities
- Avoid guilt about time zone impositions
- Feel like a competent modern leader

**Social Jobs:**
- Be seen as effective remote manager by leadership
- Demonstrate trust and respect for team autonomy
- Show cultural sensitivity across diverse team
- Project image of innovative, flexible organization

**Pains (Current Situation):**
- Zoom fatigue: Meetings at awkward hours for someone always
- WhatsApp chaos: Important info buried in 500 messages
- Email threads become confusing with replies across time zones
- Can't tell if teammates saw/understood information
- Google Docs everywhere, hard to find things
- Language barriers cause misunderstandings
- Junior team members in Philippines/Vietnam feel ignored vs. Singapore seniors
- No visibility when someone is stuck or needs help

**Gains (Desired):**
- Work happens 24/7 across time zones without constant meetings
- Clear visibility of progress without micromanaging
- Context preserved (why decisions made, not just what to do)
- Automatic translation helps multilingual team
- Team feels included and valued regardless of location
- Decisions recorded with rationale, findable later
- Reduce meetings by 50% through async communication
- New members onboard quickly (context is documented)

### Persona: Mei Lin Tan - The Pragmatic Engineering Manager

**Profile:**
- Age: 36
- Occupation: Engineering Manager at fintech startup
- Location: Singapore
- Life stage: Married, one child (age 4)

**Context:**
Mei Lin manages a team of 12 software engineers distributed across Singapore (4), Philippines (3), Vietnam (3), and Thailand (2). Company is Series B fintech startup building payment infrastructure for Southeast Asian SMEs. Team speaks mix of English, Mandarin, Filipino (Tagalog), Vietnamese, Thai—English is working language but proficiency varies. Half the team has never met in person. She tries to respect everyone's time zones but Philippines team complains Singapore HQ makes all decisions in calls they can't join (4am their time). Currently uses WhatsApp for quick chats, Jira for tasks, Google Docs for specs, Zoom for meetings, Confluence for docs (underused). Information is scattered, and she spends 2 hours daily just syncing people. Promoted 8 months ago from IC role—first time managing remote team.

**Jobs to Be Done:**
**Functional:** Coordinate effective work across 12 people in 4 countries without timezone tyranny  
**Emotional:** Feel confident as leader and reduce anxiety about invisibility  
**Social:** Be seen as fair, effective manager who builds strong distributed teams

**Goals & Motivations:**
- Deliver product roadmap on time and build career as engineering leader
- Build high-performing team culture despite distance
- Prove remote/distributed model works to leadership
- Balance work and family (daughter's daycare pickup at 6pm)

**Pain Points & Challenges:**
- Information scattered across 5 tools, team can't find things
- Philippines/Vietnam team feels like "second-class" vs. Singapore HQ
- Burned out from 8am-10pm schedule trying to cover all time zones
- WhatsApp has 400+ messages daily, important stuff lost
- Language barriers cause misunderstandings on technical specs
- Can't tell if quiet team members understand or are struggling
- Junior developers wait 8+ hours for answers to questions
- Confluence docs nobody reads because they're always outdated

**Behaviors:**
- **Decision-making:** Collaborative but feels pressure to move fast
- **Information sources:** Manager Slack channels, Medium articles, peer managers
- **Technology use:** High comfort, team varies (seniors fluent, juniors learning)
- **Communication:** Prefers async but defaults to meetings when confused

**Quote:**
"I need one place where the team can work together regardless of when they're online, and I can see progress without babysitting. Right now I'm gluing together 5 tools and it's not working."

### Evidence Gathering: Remote Team Collaboration Platform (Southeast Asia)

**Research Questions:**
1. What collaboration pain points are unique to Southeast Asian distributed teams?
2. How do successful remote teams in region actually coordinate work?
3. What causes tool abandonment and what drives sustained adoption?

**Sources Used:**
- Reddit r/remotework, r/SEADevelopers (80 threads)
- Product Hunt reviews of Notion, Asana, Monday, Linear, Basecamp
- 8 interviews with engineering managers at Singapore/regional startups
- LinkedIn posts from Southeast Asian tech leaders (100+ posts analyzed)
- Facebook "Southeast Asia Tech Community" group discussions

**Key Findings:**

**Validation:**

**Confirms:**
- Time zone coordination is major pain: "Someone is always sleeping" (recurring theme)
- Tool sprawl is universal: Average team uses 6-8 tools
- WhatsApp dominates in region but scales poorly: "It's great until it's not" (common)
- Language barriers underestimated: Even good English speakers miss nuance
- Hierarchy sensitivity: Junior team members less likely to speak up in video calls

**Contradicts:**
- Problem isn't too many meetings—it's meetings with wrong people at wrong time
- Teams want structure, not complete freedom (chaos from over-flexibility)
- Not all async is good—chat messages (WhatsApp, Slack) create FOMO and interruptions
- Western tools often ignore regional reality: "Notion templates assume everyone works US hours"

**Landscape:**

**Existing Solutions:**
- **WhatsApp:** Universal but poor for work (no task tracking, search terrible, everything buried)
- **Slack:** Popular with larger startups but expensive ($8/user/month), overwhelming notifications
- **Microsoft Teams:** Enterprise standard but clunky, meetings-focused not async-first
- **Notion:** 4.7★, loved by managers, overwhelming for junior team members
- **Asana/Monday:** Task management OK but no context, pure PM tool not collaboration
- **Linear:** 4.8★, developers love it but eng-only, doesn't help cross-functional
- **Basecamp:** Good async culture but feels dated, limited Southeast Asia adoption
- **Regional players:** Zoho (India-focused), DingTalk (China-focused), few truly regional

**Gaps & Opportunities:**
- Async-first by design (not meeting replacement but meeting prevention)
- Context preservation: Decisions and rationale preserved, not just tasks
- Multilingual support: Built-in translation, not afterthought
- Time zone awareness: Tool "knows" when each person is available
- All-in-one: Reduces tool sprawl (docs + tasks + decisions in one place)
- Southeast Asia-specific: Understands regional work culture, pricing, needs

**Customer Voice:**

**Key Quotes:**
- "We schedule 5pm call to include Manila team. But then Singapore team has to leave for kid pickup." (Interview)
- "My Vietnamese teammates are too polite to say they don't understand. They just do it wrong." (Reddit)
- "WhatsApp is free and everyone has it. But work gets lost in the noise." (LinkedIn)
- "I love Notion but my team hates it. Too complicated, they just want simple." (Interview)
- "Why do all these tools assume we work 9-5 California time?" (Facebook group)
- "We tried 4 tools last year. Team revolt every time. Back to WhatsApp + chaos." (Reddit)

**Pain Intensity:**
- Frequency: Daily pain, acute during launches or urgent issues
- Severity: High - delays cost sprint goals, team morale suffers, burnout
- Current coping: Tool sprawl, late-night meetings, over-documentation (then ignored)

**Willingness to Pay:**
- Sweet spot: $5-8/user/month for Southeast Asia market
- Considerations: Many startups bootstrapped or Series A, price-sensitive
- Comparison: WhatsApp free, Slack $8, Notion $10, Microsoft Teams bundled
- Value perception: Must clearly save time/meetings to justify cost

**Trends & Context:**

**Enabling Factors:**
- Remote work normalized post-COVID, not going back
- Southeast Asia tech talent distributed (not just Singapore/major cities)
- Startup ecosystem maturing: More companies scaling distributed teams
- Internet infrastructure improved: Reliable broadband in Philippines, Vietnam
- AI translation getting good enough for real-time use

**Headwinds:**
- Tool fatigue: Teams resist learning new platforms
- WhatsApp network effects: Everyone already on it
- Budget pressure: Startups cutting costs in downturn
- Regional fragmentation: No single dominant solution
- Cultural change hard: Async requires training and discipline

**Implications for Solution:**
1. **Async-first design:** Default to written updates, not meetings
2. **Built-in translation:** Don't assume English proficiency
3. **Time zone intelligence:** Show when people available, prevent bad meeting times
4. **Simple for juniors:** Power users get features, juniors get simple interface
5. **WhatsApp integration:** Meet people where they are, don't force migration
6. **Context-rich:** Preserve why behind decisions, not just what
7. **Southeast Asia pricing:** $5-7/user/month, not Silicon Valley pricing

---

## Example 3: Affordable Home Solar System (Rural India)

### Jobs-to-be-Done Analysis

**Job Statement:**
"When managing household energy needs in an area with unreliable grid electricity, I want to power essential appliances and lighting without expensive diesel generators or repeated battery purchases, so my family can study, work, and live comfortably. This helps me feel I'm providing well for my family (emotional) and shows I'm a progressive, responsible household head (social)."

**Functional Jobs:**
- Power lights (4-6 LED bulbs), phone charging (3-4 phones), fan, TV
- Operate during grid outages (4-8 hours daily in summer)
- Avoid diesel generator costs (fuel + maintenance)
- Reduce electricity bills
- Last 5-7 years with minimal maintenance

**Emotional Jobs:**
- Feel pride in providing reliable power
- Reduce stress about outages during important times
- Feel confident in investment decision
- Avoid frustration of generator noise and smell

**Social Jobs:**
- Be seen as forward-thinking household head
- Show environmental responsibility
- Demonstrate financial wisdom
- Enable children's education (study at night)

**Pains (Current Situation):**
- Grid power outages 4-8 hours daily, unpredictable timing
- Diesel generator costs 3,000-4,000 Rupees monthly (fuel + maintenance)
- Generator noisy, smelly, disturbs neighbors
- Children can't study when power out
- Inverter batteries need replacement every 2 years (8,000 Rupees)
- Can't run fan during summer outages (unbearable heat)
- Phone charging requires going to town center
- Perceived as too expensive or complicated for rural household

**Gains (Desired):**
- Reliable power during outages
- Reduce energy costs by 50-70%
- Silent operation
- 5+ year lifespan with minimal maintenance
- Simple installation and operation
- Payback period under 3 years
- Pride of using modern, clean technology

### Persona: Rajesh Kumar - The Rural Shopkeeper

**Profile:**
- Age: 38
- Occupation: Shopkeeper (general store)
- Location: Village near Jaipur, Rajasthan, India
- Life stage: Married, three children (ages 9, 13, 16)

**Context:**
Rajesh runs a general store in a village of 2,500 people, 45 km from Jaipur. Sells groceries, mobile phone recharge, basic medicines. His shop has refrigerator (store cold drinks), lights, fan, and he charges villagers' phones for 5 Rupees. House is attached to shop. Grid electricity is unreliable—outages 4-6 hours daily in summer, less in winter but still frequent. He runs diesel generator during outages to keep fridge running and shop open. Generator costs 3,500 Rupees monthly in fuel. His oldest son preparing for college entrance exams—needs light to study at night. Village getting more phones and small appliances but electricity is bottleneck. He heard about solar from government schemes but confused about costs and quality. Some neighbors got cheap Chinese solar, stopped working after 1 year.

**Jobs to Be Done:**
**Functional:** Power shop and home reliably without expensive generator fuel  
**Emotional:** Feel confident providing for family's needs and education  
**Social:** Be seen as progressive business owner and good father

**Goals & Motivations:**
- Send oldest son to good college (first in family)
- Grow shop business (add more refrigerated items)
- Improve family quality of life
- Save money for daughter's future wedding

**Pain Points & Challenges:**
- Generator fuel eating 40% of shop profit margin
- Outages cost sales when customers leave (no cold drinks, dark shop)
- Son's exam prep suffering without reliable light
- Confused about solar: upfront cost, which company, will it work?
- Saw neighbor's cheap solar fail after 1 year—afraid of waste
- Banks want collateral for loan he doesn't have
- Government subsidy process bureaucratic and slow
- Installation and maintenance: who will service it in village?

**Behaviors:**
- **Decision-making:** Risk-averse, consults village elders and successful shopkeepers
- **Information sources:** Other shopkeepers, government officials, vendor demos
- **Technology use:** Basic mobile, comfortable with appliances, wary of complicated systems
- **Payment methods:** Cash primarily, considering digital payments for shop

**Quote:**
"I want to stop wasting money on diesel and have proper electricity for my shop and children's studies. But I can't afford to make an expensive mistake—I need something that works and lasts."

### Evidence Gathering: Affordable Home Solar System (Rural India)

**Research Questions:**
1. What drives and prevents solar adoption in rural/semi-rural India?
2. What's the reputation of existing solutions and where do they fail?
3. What financing and support models actually work in this context?

**Sources Used:**
- Reviews of solar companies on Google, Justdial (200+ reviews)
- India subreddit r/india, r/solar discussions (50 threads)
- Government reports on solar adoption (MNRE, CEA data)
- 4 shop visits and conversations in villages near Jaipur
- YouTube reviews of solar systems in Hindi (20 videos)

**Key Findings:**

**Validation:**

**Confirms:**
- Rural grid unreliability is severe: 4-6 hours daily outages common
- Generator costs significant: 3,000-5,000 Rupees monthly widespread
- Upfront cost biggest barrier: 50,000-80,000 Rupees is 6-12 months income
- Quality fears real: Many experienced cheap Chinese products failing
- Support gap critical: Installation happens once, then no service availability

**Contradicts:**
- Not primarily about "being green"—it's pure economics and reliability
- Subsidies exist but bureaucracy prevents uptake—not awareness problem
- Rural users sophisticated about technology—don't need dumbed-down
- Price isn't the only issue—trust and post-sales support matter equally

**Landscape:**

**Existing Solutions:**
- **Tata Power Solar:** Premium brand (80,000-120,000 Rupees), 3.8★. "Good quality but too expensive for village"
- **Luminous, Havells:** Inverter brands moving to solar, familiar names, trust
- **Chinese products on Amazon:** 15,000-30,000 Rupees, 2.5★. "Stopped working after 8 months, no support"
- **Government MNRE scheme:** 40% subsidy but requires eligible connections and paperwork
- **Local installers:** Variable quality, post-sales service unpredictable
- **Diesel generators:** 25,000-40,000 Rupees plus fuel (status quo)

**Gaps & Opportunities:**
- Financing: Need pay-over-time models, not just upfront purchase
- Trust: Local presence for installation and support
- Right-sizing: Most systems over-specced or under-powered for actual needs
- Simplicity: Plug-and-play installation without electrician
- Warranty reality: 5-year warranty means nothing if company disappears
- Underserved: 50,000-150,000 household income segment (not poorest, not affluent)

**Customer Voice:**

**Key Quotes:**
- "I want to buy solar but 70,000 Rupees upfront? I don't have that money. Need installments." (Shop conversation)
- "My neighbor bought Chinese solar for 20,000. Dead in 6 months. Who will fix it? No one." (Google review)
- "Government subsidy sounds good but paperwork is nightmare. Easier to keep suffering." (Reddit)
- "Tata brand I trust, but their price is for city people, not villages." (YouTube comment)
- "Who will come to my village if something breaks? This is my main worry." (Shop conversation)

**Pain Intensity:**
- Frequency: Daily problem (outages), monthly expense (generator fuel)
- Severity: High—affects livelihood (shop sales), children's education, quality of life
- Current coping: Expensive, loud, polluting diesel generators

**Willingness to Pay:**
- Upfront: 15,000-25,000 Rupees possible (savings)
- Monthly: 2,000-3,000 Rupees acceptable if financed (equivalent to current generator cost)
- Payback expectation: 2-3 years to break even vs. generator
- Total budget: 50,000-60,000 Rupees all-in if spread over time

**Trends & Context:**

**Enabling Factors:**
- Solar costs declining: Panel prices down 80% since 2010
- Battery technology improving: Lithium-ion becoming affordable
- Government push: MNRE targets, PM Kusum scheme
- Grid outages not improving despite promises
- Mobile penetration: Payment systems (UPI) enable financing
- Installation skills spreading: More trained technicians in smaller towns

**Headwinds:**
- Upfront cost barrier despite declining prices
- Quality perception damaged by cheap products
- Subsidy bureaucracy limits reach
- Monsoon/dust affects performance in some regions
- Lack of standardization creates confusion
- Post-sales service network thin in rural areas

**Implications for Solution:**
1. **Financing first:** Monthly payment model around generator fuel cost (2,500-3,000 Rupees)
2. **Right-sized systems:** 500-1000W systems for essential loads, not over-engineered
3. **Local support network:** Service technicians in taluka/block level, not just cities
4. **Trusted brand:** Partner with known brand or build reputation through guarantees
5. **Simple installation:** Plug-and-play or single-day install, no complicated wiring
6. **Warranty that matters:** Money-back guarantee if not satisfied after 3 months
7. **Value messaging:** Focus on savings vs. generator, child's education, not environment
