# Jobs-to-be-Done (JTBD) Framework

## Overview

Jobs-to-be-Done helps understand what customers are truly hiring a product or service to accomplish in their lives. Focus on the progress customers want to make, not just the features they want.

## Three Types of Jobs

### 1. Functional Jobs
The practical, objective tasks customers need to accomplish.

**Questions to explore:**
- What task or problem needs to be solved?
- What outcome does the customer want to achieve?
- What gets measured to determine success?
- What constraints exist (time, budget, resources)?

**Examples:**
- "Get from home to work in under 30 minutes"
- "Create a professional presentation in 2 hours"
- "Track household energy consumption"

### 2. Emotional Jobs
The feelings customers want to have or avoid.

**Questions to explore:**
- How does the customer want to feel?
- What feelings do they want to avoid?
- What does success feel like emotionally?
- What anxieties or concerns do they have?

**Examples:**
- "Feel confident presenting to executives"
- "Avoid guilt about environmental impact"
- "Feel in control of my budget"
- "Reduce anxiety about safety"

### 3. Social Jobs
How customers want to be perceived by others.

**Questions to explore:**
- How do they want to be seen by peers/colleagues/family?
- What image or status do they want to project?
- What social expectations are they managing?
- What role are they playing in their community?

**Examples:**
- "Be seen as an innovative leader"
- "Demonstrate environmental responsibility to family"
- "Show I'm tech-savvy to colleagues"
- "Maintain status as an expert"

## Pains & Gains

### Pains (Before/Without the Solution)
Negative aspects of the current situation:

- **Obstacles:** What prevents customers from completing the job?
- **Challenges:** What makes the job difficult or frustrating?
- **Risks:** What could go wrong? What are they afraid of?
- **Undesired outcomes:** What results do they want to avoid?

**Example pains:**
- Takes too long to complete
- Requires expensive tools or expertise
- Inconsistent results
- Social embarrassment if done wrong
- Hidden costs or surprises

### Gains (With the Solution)
Positive outcomes customers desire:

- **Required gains:** Must-have outcomes for the job to be complete
- **Expected gains:** Standard benefits customers assume will be provided
- **Desired gains:** Nice-to-have benefits that exceed expectations
- **Unexpected gains:** Delighters that customers didn't anticipate

**Example gains:**
- Saves time and effort
- Professional-quality results
- Peace of mind
- Social recognition
- Cost savings

## JTBD Question Flow

Use this sequence to explore the job:

1. **Context:** "When does this job arise? What triggers the need?"
2. **Functional job:** "What are they trying to accomplish? What does success look like?"
3. **Current approach:** "How do they solve this today? What alternatives exist?"
4. **Pains:** "What's frustrating about current solutions? What could go wrong?"
5. **Emotional job:** "How do they want to feel during and after?"
6. **Social job:** "How do they want to be perceived related to this job?"
7. **Gains:** "What would make this job dramatically better? What would delight them?"

## Output Format

**Job Statement Template:**
"When [situation/trigger], I want to [functional job], so I can [desired outcome]. This helps me [emotional job] and [social job]."

**Example:**
"When commuting to work in a crowded city, I want to travel quickly and arrive fresh, so I can be productive from the start of my day. This helps me feel in control and reduces stress (emotional) and demonstrates my environmental consciousness (social)."
