# Persona Creation Framework

## Purpose

Personas bring the JTBD analysis to life by creating a vivid, specific representation of the target customer. A good persona makes it easy to empathize with users and make decisions from their perspective.

## CRITICAL: Global Diversity

**ALWAYS create globally diverse personas unless the product/service is explicitly region-specific.**

### Geographic Diversity
Rotate through different regions, NOT just US/Western markets:
- **Asia-Pacific:** India, China, Japan, Southeast Asia, Australia
- **Africa:** Nigeria, Kenya, South Africa, Egypt
- **Latin America:** Brazil, Mexico, Argentina, Colombia
- **Middle East:** UAE, Saudi Arabia, Turkey, Israel
- **Europe:** UK, Germany, Poland, Spain, Nordic countries
- **North America:** US, Canada (if relevant)

### Cultural Context Matters
Consider how cultural factors shape the job:
- **Family structures:** Extended families, multi-generational households
- **Economic contexts:** Emerging vs. developed markets, income levels
- **Infrastructure:** Internet access, payment systems, logistics
- **Social norms:** Privacy expectations, status symbols, gender roles
- **Language:** Multiple languages in household, literacy levels
- **Values:** Individualism vs. collectivism, relationship to technology

### Avoid Western Bias
**Don't assume:**
- Everyone has a credit card or bank account
- Reliable high-speed internet is available
- Individual decision-making (many cultures are collective)
- Western work schedules or living arrangements
- Access to same technologies or services
- Similar economic resources

**Do consider:**
- Local payment methods (mobile money, cash, local apps)
- Internet/power reliability issues
- Family/community decision-making dynamics
- Local competitors and alternatives
- Cultural holidays, schedules, rhythms
- Language preferences and multilingual contexts

## Essential Persona Elements

### 1. Basic Profile
- **Name:** Use culturally appropriate, authentic names for the region
- **Age & Life Stage:** Influences priorities and constraints
- **Occupation/Role:** Shapes daily context and needs
- **Location:** City/region/country - be specific

### 2. Context & Situation
- **Living situation:** Family status, household composition
- **Daily routine:** Typical day structure, key activities
- **Technology access:** Device ownership, internet quality, digital literacy
- **Key constraints:** Time, budget, skills, infrastructure, physical limitations
- **Cultural context:** Relevant cultural factors affecting the job

### 3. Goals & Motivations
- **Primary goals:** What they're trying to achieve (link to JTBD)
- **Values:** What matters most to them (may differ by culture)
- **Aspirations:** Who they want to become
- **Current priorities:** What's competing for their attention

### 4. Challenges & Frustrations
- **Current pain points:** Specific problems they face (from JTBD pains)
- **Obstacles:** What stands in their way (infrastructure, economic, social)
- **Past failures:** Previous solutions they've tried that didn't work
- **Concerns & anxieties:** What keeps them up at night

### 5. Behaviors & Patterns
- **How they make decisions:** Individual, family, community-based
- **Information sources:** Where they learn and get advice (local vs. global)
- **Buying behavior:** Research depth, price sensitivity, payment methods
- **Communication preferences:** WhatsApp, WeChat, local apps, SMS, etc.

### 6. Quote/Mantra
A memorable quote that captures their mindset in their voice.

## How to Build a Persona

### Option A: From Real User Research
1. Interview or survey target customers in specific markets
2. Identify patterns in goals, behaviors, and pain points
3. Composite common characteristics into a representative persona
4. Validate with additional users from that context

### Option B: From JTBD Analysis (When Research is Limited)
1. Start with the JTBD statement
2. Ask: "Where in the world would this job be most urgent/frequent?"
3. Choose a specific market/region (rotate for diversity)
4. Build out culturally-appropriate details
5. Add realistic local constraints and context
6. Test assumptions with target users when possible

## Persona Template

Use this structure:

```
# [Name] - [Role/Archetype]

## Profile
- Age: [age]
- Occupation: [job title]
- Location: [city, country/region]
- Life stage: [family situation]

## Context
"[2-3 sentences describing their daily life, key responsibilities, current situation, and relevant cultural context]"

## Jobs to Be Done
**Functional:** [from JTBD analysis]
**Emotional:** [from JTBD analysis]
**Social:** [from JTBD analysis]

## Goals & Motivations
- [Primary goal 1]
- [Primary goal 2]
- [Primary goal 3]

## Pain Points & Challenges
- [Specific pain 1 with local context]
- [Specific pain 2 with local context]
- [Specific pain 3 with local context]

## Behaviors
- **Decision-making:** [individual/family/community context]
- **Information sources:** [where they learn - local apps, word-of-mouth, etc.]
- **Technology use:** [comfort level, devices, connectivity]
- **Payment methods:** [how they pay for things]

## Quote
"[Memorable quote that captures their mindset]"
```

## Multiple Personas

Create 2-3 personas when:
- Different customer segments have significantly different jobs or contexts
- The product serves multiple markets with different cultural contexts
- Different personas have conflicting needs that require design trade-offs

Keep the primary persona as the main focus; secondary personas provide important but not dominant perspectives.

## Example Persona Snapshots (Globally Diverse)

### Priya Sharma - The Ambitious Micro-Entrepreneur
32-year-old runs a home-based tailoring business in Pune, India. Lives with husband and two children in 600 sq ft apartment. Uses WhatsApp for customer orders and payment via Paytm/Google Pay. Limited English, primarily speaks Marathi and Hindi. Internet comes through shared family smartphone with inconsistent 4G. Decision-making involves husband for major purchases. Dreams of expanding business but constrained by capital and space. "I need solutions that work on my phone and don't require expensive equipment—my business depends on keeping costs low."

### Carlos Mendoza - The Multi-Job Hustler  
28-year-old works two jobs in Mexico City—morning shift at electronics store, evening as ride-share driver. Lives with parents and sister's family (7 people total). High school education, self-taught tech skills. Uses Android phone extensively but laptop access limited. Pays mostly cash, some debit card. WhatsApp is primary communication. Goals: Save for own apartment, eventually start small business. "Time is my enemy—I need things that work while I'm moving between my jobs."

### Amina Hassan - The Connected Professional
35-year-old marketing manager in Nairobi, Kenya. MBA from local university, works for regional telecommunications company. Lives in middle-class neighborhood, commutes 90 minutes daily. Smartphone-first user, good internet at work but slower/expensive data at home. Active on Twitter, LinkedIn, local tech communities. Decision-maker in household (married, one child). "I want tools that respect African contexts—not just Western products adapted with an afterthought."

### Kenji Tanaka - The Efficiency-Focused Salaryman
42-year-old mid-level manager at manufacturing firm in Osaka, Japan. Long work hours, values efficiency and reliability over novelty. Lives in small apartment with wife and elderly mother. Tech-comfortable but conservative—doesn't adopt new tools quickly. Uses LINE for communication, prefers Japanese-language interfaces. Decision-making slow, seeks group consensus. "It must integrate seamlessly with my existing routine—I don't have time to learn complicated new systems."
