# Multi-Criteria Evaluation Framework

## Overview

This framework provides structured criteria for evaluating innovation ideas. Use it to score ideas objectively and make defensible prioritization decisions.

---

## The Five Evaluation Dimensions

### 1. Customer Value (Impact on JTBD)

**Core question:** How much does this idea help customers get their job done better?

#### Sub-Criteria

**Pain Relief (40%)**
How much does this reduce customer frustrations and obstacles?
- **5 - Exceptional:** Eliminates a critical pain point entirely
- **4 - Strong:** Significantly reduces a major pain
- **3 - Moderate:** Noticeably reduces a moderate pain
- **2 - Weak:** Slightly reduces a minor pain
- **1 - Poor:** Minimal or no pain relief

**Gain Creation (40%)**
How much does this enable desired outcomes and benefits?
- **5 - Exceptional:** Unlocks transformative new outcomes
- **4 - Strong:** Enables significant new gains
- **3 - Moderate:** Provides noticeable improvements
- **2 - Weak:** Marginal improvements
- **1 - Poor:** No meaningful gain creation

**Job Performance (20%)**
How much better/faster/cheaper does this make the core job?
- **5 - Exceptional:** 10x improvement in speed, cost, or quality
- **4 - Strong:** 3-5x improvement
- **3 - Moderate:** 50-100% improvement
- **2 - Weak:** 10-30% improvement
- **1 - Poor:** Negligible improvement

#### Evidence to Consider
- **From JTBD:** Which pains does this address? Which gains?
- **From Persona:** Does this match how target customers actually work?
- **From Evidence:** Do social media, reviews, or research validate this need?
- **From PRFAQ:** Does this align with customer testimonial narrative?

---

### 2. Feasibility (Can We Build It?)

**Core question:** How realistic is it to implement this idea with our resources?

#### Sub-Criteria

**Technical Feasibility (35%)**
Do we have or can we acquire the technology and skills?
- **5 - Exceptional:** Proven technology we already use
- **4 - Strong:** Well-established tech, we have most skills
- **3 - Moderate:** Mature tech, need to learn or hire
- **2 - Weak:** Emerging tech, significant learning curve
- **1 - Poor:** Cutting-edge or unproven, high technical risk

**Operational Feasibility (30%)**
Can our processes and operations support this?
- **5 - Exceptional:** Fits perfectly into existing workflows
- **4 - Strong:** Minor process adjustments needed
- **3 - Moderate:** Significant process changes required
- **2 - Weak:** Major operational restructuring needed
- **1 - Poor:** Requires entirely new operational model

**Resource Availability (25%)**
Do we have the time, budget, and people?
- **5 - Exceptional:** Can build with current team in 1-2 months
- **4 - Strong:** Can build with current team in 3-6 months
- **3 - Moderate:** Need 1-2 new hires or 6-12 months
- **2 - Weak:** Need significant hiring or 12+ months
- **1 - Poor:** Beyond current resource capacity

**Dependencies (10%)**
How many external dependencies or unknowns?
- **5 - Exceptional:** Fully self-contained, no dependencies
- **4 - Strong:** 1-2 well-understood dependencies
- **3 - Moderate:** Several dependencies, mostly manageable
- **2 - Weak:** Many dependencies, some uncertain
- **1 - Poor:** Critical dependencies outside our control

#### Evidence to Consider
- **From Closed World:** What internal components can we leverage?
- **From Closed World:** What external factors constrain us?
- **From Team:** What skills exist? What gaps?
- **From Roadmap:** How does this fit with existing commitments?

---

### 3. Viability (Does It Make Business Sense?)

**Core question:** Will this idea work as a sustainable business?

#### Sub-Criteria

**Revenue Potential (30%)**
Can we monetize this effectively?
- **5 - Exceptional:** Clear path to significant new revenue
- **4 - Strong:** Good revenue opportunity, proven model
- **3 - Moderate:** Moderate revenue, some uncertainty
- **2 - Weak:** Limited revenue potential
- **1 - Poor:** No clear path to monetization

**Cost Structure (30%)**
Is this economically sustainable to deliver?
- **5 - Exceptional:** Very low marginal cost, high margin
- **4 - Strong:** Good unit economics, sustainable
- **3 - Moderate:** Breakeven or modest margin
- **2 - Weak:** Negative margin initially, scale uncertain
- **1 - Poor:** Fundamentally unprofitable

**Pricing (20%)**
Will customers pay enough to make it viable?
- **5 - Exceptional:** Customers willing to pay premium
- **4 - Strong:** Strong willingness to pay at target price
- **3 - Moderate:** Acceptable willingness, competitive pricing
- **2 - Weak:** Price sensitivity, thin margins
- **1 - Poor:** Customers won't pay enough

**Unit Economics at Scale (20%)**
Do the economics improve or worsen with scale?
- **5 - Exceptional:** Strong positive economies of scale
- **4 - Strong:** Moderate economies of scale
- **3 - Moderate:** Mostly linear scaling
- **2 - Weak:** Diseconomies of scale emerge
- **1 - Poor:** Doesn't scale economically

#### Evidence to Consider
- **From PRFAQ:** Pricing justified by willingness to pay?
- **From Stakeholder FAQs:** Business model viability addressed?
- **From Competitive Landscape:** How do competitors make money?
- **From Unit Economics:** Do quick calculations pass sanity check?

---

### 4. Desirability (Do Customers Want It?)

**Core question:** How emotionally appealing is this idea to customers?

#### Sub-Criteria

**Emotional Resonance (35%)**
Does this spark delight, excitement, or strong positive emotion?
- **5 - Exceptional:** "Love it!" reaction, strong emotional pull
- **4 - Strong:** Positive emotion, clearly appealing
- **3 - Moderate:** Neutral to mildly positive
- **2 - Weak:** Lukewarm reception
- **1 - Poor:** Indifferent or negative reaction

**Brand Fit (25%)**
Does this align with how customers perceive our brand?
- **5 - Exceptional:** Perfectly on-brand, strengthens positioning
- **4 - Strong:** Good fit, reinforces brand values
- **3 - Moderate:** Acceptable, doesn't harm brand
- **2 - Weak:** Slight brand mismatch
- **1 - Poor:** Off-brand, could damage perception

**Differentiation (25%)**
Is this meaningfully different from alternatives?
- **5 - Exceptional:** Radically different, no comparable alternative
- **4 - Strong:** Clear differentiation, hard to copy
- **3 - Moderate:** Somewhat different, distinguishable
- **2 - Weak:** Minor differences, easily copied
- **1 - Poor:** Me-too, no differentiation

**Shareability (15%)**
Will customers tell others about this?
- **5 - Exceptional:** Highly viral, "must share" quality
- **4 - Strong:** Strong word-of-mouth potential
- **3 - Moderate:** Some organic sharing
- **2 - Weak:** Low sharing likelihood
- **1 - Poor:** Nothing remarkable to share

#### Evidence to Consider
- **From Persona:** What delights this customer type?
- **From PRFAQ Customer Quote:** Does testimonial show emotional response?
- **From Evidence Gathering:** Social media sentiment on similar features?
- **From Competitive Landscape:** What makes competitors boring?

---

### 5. Strategic Fit (Does It Advance Our Vision?)

**Core question:** How well does this align with long-term strategic goals?

#### Sub-Criteria

**Competitive Advantage (30%)**
Does this create defensible differentiation?
- **5 - Exceptional:** Unique moat, very hard to replicate
- **4 - Strong:** Clear competitive edge, moderately defensible
- **3 - Moderate:** Some advantage, competitors could copy
- **2 - Weak:** Temporary advantage only
- **1 - Poor:** No competitive advantage

**Vision Alignment (30%)**
Does this move us toward our long-term vision?
- **5 - Exceptional:** Core to realizing our vision
- **4 - Strong:** Important step toward vision
- **3 - Moderate:** Consistent with vision
- **2 - Weak:** Tangential to vision
- **1 - Poor:** Misaligned with vision

**Learning Value (20%)**
Does this teach us something strategically important?
- **5 - Exceptional:** Critical learning for future strategy
- **4 - Strong:** Important insights into market/tech
- **3 - Moderate:** Some useful learning
- **2 - Weak:** Limited learning value
- **1 - Poor:** No strategic learning

**Platform Potential (20%)**
Can this unlock future opportunities?
- **5 - Exceptional:** Opens entirely new opportunity space
- **4 - Strong:** Enables multiple future innovations
- **3 - Moderate:** Some follow-on potential
- **2 - Weak:** Mostly standalone
- **1 - Poor:** Dead-end, no platform value

#### Evidence to Consider
- **From PRFAQ:** Does this advance the vision described?
- **From Stakeholder FAQs:** Is this "what we're NOT doing"?
- **From Competitive Landscape:** Does this create unique positioning?
- **From Long-term Goals:** Does this build toward 3-5 year objectives?

---

## Weighting Strategies

### Standard Balanced Weighting
Best for: Mature companies with balanced priorities

```
Customer Value:  25%
Feasibility:     20%
Viability:       20%
Desirability:    20%
Strategic Fit:   15%
```

### Fast Follower / Quick Wins
Best for: Companies needing near-term revenue or proven models

```
Feasibility:     30%
Viability:       25%
Customer Value:  25%
Strategic Fit:   15%
Desirability:     5%
```

### Disruptive Innovation / Moonshot
Best for: Well-funded companies pursuing breakthrough innovation

```
Customer Value:  30%
Strategic Fit:   30%
Desirability:    20%
Feasibility:     10%
Viability:       10%
```

### Early Stage / PMF Search
Best for: Startups seeking product-market fit

```
Customer Value:  30%
Desirability:    25%
Strategic Fit:   25%
Feasibility:     15%
Viability:        5%
```

### Resource-Constrained
Best for: Small teams, limited budget

```
Feasibility:     35%
Viability:       30%
Customer Value:  20%
Desirability:    10%
Strategic Fit:    5%
```

### Enterprise B2B
Best for: Selling to large organizations with long cycles

```
Customer Value:  30%
Feasibility:     30%
Viability:       20%
Strategic Fit:   15%
Desirability:     5%
```

### Consumer B2C
Best for: Mass market consumer products

```
Desirability:    30%
Customer Value:  25%
Strategic Fit:   20%
Viability:       15%
Feasibility:     10%
```

---

## Scoring Best Practices

### 1. Score Relatively, Not Absolutely
Don't score ideas in isolation. Compare them:
- "Is Idea A better than Idea B on Customer Value?"
- "Which idea has stronger Strategic Fit?"

### 2. Use Evidence, Not Gut Feeling
Ground scores in:
- Closed World map (for Feasibility)
- PRFAQ (for Customer Value and Strategic Fit)
- Personas (for Desirability)
- Competitive landscape (for Viability and Strategic Fit)

### 3. Score One Dimension at a Time
Score ALL ideas on Customer Value before moving to Feasibility. This ensures:
- Consistency across ideas
- Relative comparison
- Pattern recognition

### 4. Document Extreme Scores
If you score something 1 or 5, write a brief note explaining why. This helps:
- Remember reasoning later
- Defend scores to stakeholders
- Identify assumptions to validate

### 5. Embrace Uncertainty with Middle Scores
If uncertain, use 2-3 scores. Don't artificially inflate or deflate.
- **3 = "decent but uncertain"** is a valid score
- Validation (Six Thinking Hats) will resolve uncertainty

### 6. Watch for Patterns
After scoring 10+ ideas, look for patterns:
- Are all Feasibility scores clustering around 3? (Weights may need adjustment)
- Do certain SCAMPER types score higher? (Strategic bias to recognize)
- Are scores correlated? (High Customer Value = Low Feasibility often)

---

## Common Scoring Pitfalls

### Feasibility Bias
**Symptom:** All top ideas are "easy to build"
**Problem:** Missing transformative innovations
**Solution:** Reduce Feasibility weight, increase Customer Value and Strategic Fit

### Founder's Favorite
**Symptom:** One idea scores 5s across the board
**Problem:** Emotional attachment distorting objectivity
**Solution:** Score that idea last, compare to others, have second person review

### Analysis Paralysis
**Symptom:** Spending 30 minutes debating 3.2 vs. 3.4
**Problem:** Over-precision, wasting time
**Solution:** Use integers (1-5), trust the process, move quickly

### Correlation Neglect
**Symptom:** High scores on conflicting dimensions (e.g., 5 on Viability AND 5 on Disruptive Innovation)
**Problem:** Internal contradiction
**Solution:** Challenge correlations - breakthrough innovations often trade feasibility for impact

### Ignoring Must-Haves
**Symptom:** Top-scoring idea violates hard constraint
**Problem:** Wasted validation effort
**Solution:** Quick-filter for constraints BEFORE scoring

---

## Adapting the Framework

### Add Custom Dimensions

**Examples of additional dimensions:**
- **Risk Tolerance** - for risk-averse organizations
- **Speed to Market** - when timing is critical
- **Regulatory Compliance** - for regulated industries
- **Team Morale** - when engagement matters
- **Partner Dependencies** - for ecosystem plays
- **Environmental Impact** - for sustainability-focused companies

**When adding dimensions:**
1. Define clear 1-5 scoring criteria
2. Adjust weights so total = 100%
3. Ensure new dimension isn't redundant (overlaps with existing)

### Modify Scoring Scale

**1-3 Scale (Fast):**
- 3 = Strong
- 2 = Moderate
- 1 = Weak

**Pros:** Faster, forces clearer distinctions
**Cons:** Less nuance, harder to differentiate

**1-10 Scale (Detailed):**
- Allows fine-grained comparison
- Useful for large idea sets (50+)

**Pros:** More precision
**Cons:** Slower, false precision risk

**Binary (Must-Have Filters):**
- Use for deal-breakers before scoring
- Example: "Regulatory compliant? Yes/No"

### Collaborative Scoring

**Independent then Discuss:**
1. Each person scores independently
2. Compare scores
3. Discuss differences >2 points
4. Converge on consensus scores

**Benefits:** Reduces groupthink, surfaces diverse perspectives

**Delphi Method:**
1. Round 1: Anonymous independent scoring
2. Share results, discuss outliers
3. Round 2: Re-score with new information
4. Converge

**Benefits:** Reduces authority bias, systematic

---

## Interpreting Results

### Score Ranges

**4.0 - 5.0: Top Tier**
Clear candidates for validation. Strong across most dimensions.

**3.5 - 3.9: Strong Consideration**
Competitive ideas, likely make top 10. Look for why not higher.

**3.0 - 3.4: Moderate**
Decent ideas but notable weaknesses. Portfolio fillers or "wait and see."

**2.5 - 2.9: Weak**
Significant concerns outweigh strengths. Unlikely to pursue.

**< 2.5: Eliminate**
Critical flaws. Archive but don't invest further.

### Portfolio Balance

Don't just pick top 3 by score. Balance:
- **Quick wins** (high Feasibility) + **moonshots** (high Customer Value/Strategic Fit)
- **Different SCAMPER types** (not all ELIMINATE or all COMBINE)
- **Core product** improvements + **ecosystem** expansions

### Sensitivity Analysis

**Test weight changes:**
- What if we doubled Customer Value weight?
- What if we halved Feasibility weight?
- Do top 3 ideas change?

If rankings are stable across weightings → robust
If rankings flip wildly → marginal differences, choose based on other factors

---

## Using Scores for Decisions

### Go / No-Go Thresholds

**Validation threshold:** 3.0+
- Ideas scoring <3.0 don't justify validation effort

**Implementation threshold:** 3.5+
- Ideas scoring <3.5 need significant de-risking before build

**Platform bet threshold:** 4.0+
- Only ideas scoring 4.0+ warrant major resource commitment

### Portfolio Allocation

**70 / 20 / 10 Rule:**
- 70% effort: Ideas scoring 3.5-4.0 (strong, manageable risk)
- 20% effort: Ideas scoring 4.0+ (bets, high uncertainty)
- 10% effort: Learning experiments (score doesn't matter, test assumptions)

### Communication to Stakeholders

**When sharing results:**
1. Explain weighting rationale first
2. Show top 10, not just top 3 (context matters)
3. Highlight portfolio balance
4. Be transparent about scoring limitations ("not a guarantee")
5. Invite challenge on extreme scores

---

## Validation Handoff

**For each top 3-5 idea, document:**
1. **Scores and ranking** - where it stands
2. **Key strengths** - why it scored well
3. **Key concerns** - what needs validation
4. **Critical assumptions** - what must be true for this to work
5. **Validation questions** - specific questions for Six Thinking Hats

This ensures smooth handoff to critical-validation phase.

---

## When to Re-Evaluate

**Trigger re-evaluation if:**
- Strategic priorities shift (new CEO, pivot, funding)
- Major market change (competitor launch, regulation, technology)
- Initial validation contradicts scores (assumed Feasibility was 4, actually 2)
- 3-6 months pass (context and capabilities evolve)
- New ideas emerge that challenge top 3

**Re-evaluation process:**
1. Review original weights - still valid?
2. Re-score ideas that changed
3. Compare new ranking to old
4. Decide: continue with top 3, or pivot to new ideas?

---

## Conclusion

This framework provides structure, not prescription. Adapt it to your context, trust your judgment when scores conflict with intuition, and remember: **evaluation narrows options, validation tests assumptions.**

Good evaluation gets you to the right 3-5 ideas quickly. Deep validation (next phase) determines which of those ideas will actually work.
