---
name: ideation-scamper
description: Generate innovative ideas systematically using SCAMPER techniques within your Closed World. Guides you through all 7 creative thinking methods (Substitute, Combine, Adapt, Modify, Put to other uses, Eliminate, Reverse) to generate 30-50+ ideas from existing components. Use after solution-definition to explore innovation possibilities. Third phase of systematic innovation.
---

# Ideation Powerhouse: SCAMPER Orchestration

## Purpose

Generate a large quantity of diverse, innovative ideas by systematically applying all 7 SCAMPER techniques to your solution's Closed World components. This orchestrator guides you through each technique in sequence, ensuring comprehensive exploration of the innovation space.

## When to Use This Skill

Use this skill when:
- You've completed solution-definition (PRFAQ + Closed World mapping)
- You need to generate many innovative ideas before selecting best options
- You want systematic creativity rather than random brainstorming
- You're ready to explore how to innovate within available resources
- You need ideas that are grounded in what's actually feasible

## SCAMPER Overview

SCAMPER is a creative thinking technique that provides 7 different lenses for generating ideas:

1. **Substitute** - Replace components with alternatives
2. **Combine** - Merge components in novel ways
3. **Adapt** - Borrow ideas from other contexts
4. **Modify/Magnify/Minify** - Change attributes, scale, or properties
5. **Put to other uses** - Repurpose components for new jobs
6. **Eliminate** - Remove components to simplify
7. **Reverse/Rearrange** - Flip or reorder processes/components

Each technique reveals different types of innovations. Using all 7 ensures comprehensive coverage.

## Orchestrated Workflow

This skill guides you through all 7 SCAMPER techniques systematically. For each technique:

### Step 1: Review Closed World
Start with the Closed World map from your solution-definition. This is your innovation playground.

### Step 2: Apply Technique Sequentially
Work through each SCAMPER technique in order:
1. Substitute (5-10 ideas)
2. Combine (5-10 ideas)
3. Adapt (5-10 ideas)
4. Modify (5-10 ideas)
5. Put to other uses (5-10 ideas)
6. Eliminate (5-10 ideas)
7. Reverse (5-10 ideas)

### Step 3: Capture All Ideas
Don't judge yet—just generate. Aim for quantity over quality at this stage. Target: 30-50+ total ideas.

### Step 4: Quick Filtering
After all 7 techniques, do a quick pass to remove duplicates and obviously infeasible ideas.

### Step 5: Ready for Evaluation
Move to idea-evaluation skill to rate and select top ideas.

## Using Individual SCAMPER Skills

You can also use each SCAMPER technique as a standalone skill if you want to focus on a specific approach:

- **scamper-substitute** - Deep dive on replacement strategies
- **scamper-combine** - Focus on merging and integration
- **scamper-adapt** - Extensive cross-industry inspiration
- **scamper-modify** - Explore variations and adjustments
- **scamper-put-to-other-uses** - Repurposing and new applications
- **scamper-eliminate** - Simplification and minimalism
- **scamper-reverse** - Inversion and rearrangement

**When to use individual skills:**
- You want deeper exploration of one technique
- Time-constrained (choose 2-3 most relevant techniques)
- Targeting specific innovation type (e.g., simplification → use Eliminate)

**When to use this orchestrator:**
- First time ideating on a solution
- Want comprehensive coverage
- Need large quantity of diverse ideas

## Complete Examples

**For inspiration and patterns:** Read `references/example-outputs.md` for complete SCAMPER sessions applied to all four case studies:
- FairCredit (Nigeria mobile micro-lending)
- AsyncFlow (Southeast Asia remote collaboration)
- SolarSeva (Rural India home solar)
- Unbroken (Sweden disaster logistics)

Each example shows all 7 techniques applied, revealing 40-50 ideas per solution.

## Output Format

Structure your SCAMPER ideation session as follows:

```markdown
# SCAMPER Ideation: [Product/Service Name]

## Closed World Reference
[Brief reminder of key internal and external components from solution-definition]

---

## SUBSTITUTE Ideas
[5-10 ideas replacing components with alternatives]

1. **Idea:** [concise description]
   **What's substituted:** [component] → [alternative]
   **Potential benefit:** [why this might be valuable]

---

## COMBINE Ideas
[5-10 ideas merging components in novel ways]

1. **Idea:** [concise description]
   **What's combined:** [component A] + [component B]
   **Potential benefit:** [why this might be valuable]

---

## ADAPT Ideas
[5-10 ideas borrowing from other contexts]

1. **Idea:** [concise description]
   **Adapted from:** [industry/context]
   **Potential benefit:** [why this might be valuable]

---

## MODIFY Ideas
[5-10 ideas changing attributes, scale, properties]

1. **Idea:** [concise description]
   **What's modified:** [component/attribute] → [how it changes]
   **Potential benefit:** [why this might be valuable]

---

## PUT TO OTHER USES Ideas
[5-10 ideas repurposing components]

1. **Idea:** [concise description]
   **Component repurposed:** [component]
   **New use:** [alternative purpose]
   **Potential benefit:** [why this might be valuable]

---

## ELIMINATE Ideas
[5-10 ideas removing components]

1. **Idea:** [concise description]
   **What's eliminated:** [component]
   **How it still works:** [brief explanation]
   **Potential benefit:** [why this might be valuable]

---

## REVERSE Ideas
[5-10 ideas flipping or reordering]

1. **Idea:** [concise description]
   **What's reversed:** [process/relationship]
   **Potential benefit:** [why this might be valuable]

---

## Summary
**Total ideas generated:** [count]
**Ideas to explore further:** [quick list of most promising]
**Ready for:** idea-evaluation skill
```

## Tips for Success

**Before starting:**
- Have your PRFAQ and Closed World map ready
- Set timer: 60-90 minutes for full SCAMPER session
- Work in environment free from distractions
- Have someone to bounce ideas with (optional but helpful)

**During ideation:**
- Quantity over quality—defer judgment
- Build on "crazy" ideas—they often lead somewhere
- Reference Closed World frequently—stay grounded
- If stuck on a technique, move to next and come back
- Aim for 5-10 per technique, but don't force it
- Write brief descriptions—details come later

**After ideation:**
- Let ideas sit for a few hours or overnight
- Quick pass to remove duplicates and nonsense
- Group related ideas as variations
- Don't throw away "wild" ideas—sometimes the best innovations seem crazy at first

## Common Pitfalls

Avoid these mistakes:
- **Skipping techniques:** Each reveals different innovations—don't skip any
- **Judging too early:** Kills creativity—separate generation from evaluation
- **Not using Closed World:** Adding new components defeats the constraint
- **Vague ideas:** "Make it better" isn't an idea—be specific
- **Stopping too soon:** Push past first obvious ideas to breakthrough thinking
- **Working alone if stuck:** Sometimes a partner helps unstick creativity
- **Analysis paralysis:** 60-90 minutes is enough—don't overthink

## Integration with Previous Phases

SCAMPER ideation builds directly on solution-definition:

**From PRFAQ:**
- Customer pains inform which ideas might have most impact
- Vision guides overall direction of ideation
- Constraints from FAQ keep ideas realistic

**From Closed World:**
- Internal components are your building blocks
- External components are additional resources
- Relationships reveal innovation opportunities
- Constraint forces creative thinking

**Example:** For FairCredit (micro-lending), Closed World includes: loan algorithm, mobile app, repayment tracking, SMS notifications, user's contacts, user's transaction history, local merchants. SCAMPER asks: What if we substitute formal credit score with merchant endorsements? Combine loan repayment with merchant loyalty points? Adapt peer lending from crowdfunding? Etc.

## Next Steps

After completing SCAMPER ideation:
1. **Quick review:** Remove obvious duplicates and infeasible ideas
2. **Evaluation:** Use idea-evaluation skill to rate and rank ideas
3. **Validation:** Use critical-validation skill (Six Hats) on top ideas
4. **Technical challenges:** If hard problems emerge, use technical-breakthrough skill (TRIZ)

The goal is quantity at this stage. You'll narrow down to the best ideas in the next phase.

## Individual Technique Resources

For deeper exploration of specific techniques, see:
- `scamper-substitute` skill - Replacement strategies and examples
- `scamper-combine` skill - Merging and integration patterns
- `scamper-adapt` skill - Cross-industry inspiration library
- `scamper-modify` skill - Variation and adjustment approaches
- `scamper-put-to-other-uses` skill - Repurposing frameworks
- `scamper-eliminate` skill - Simplification methodologies
- `scamper-reverse` skill - Inversion and rearrangement techniques

Each individual skill provides more detailed prompts, examples, and templates for that specific SCAMPER technique.
