# SCAMPER Ideation Examples

This document shows complete SCAMPER sessions applied to our four case studies. Each example demonstrates all 7 techniques generating 40-50 ideas.

---

## Example 1: FairCredit (Nigeria Mobile Micro-Lending)

### Closed World Reference

**Internal Components:**
1. Loan algorithm - Credit scoring and approval logic
2. Mobile app interface - User interactions
3. Repayment tracking system - Monitor payments
4. SMS notification system - Alerts and reminders
5. User profile database - Personal information
6. Transaction history analyzer - Spending patterns
7. Loan product catalog - Different loan types
8. Interest calculation engine - Pricing
9. Customer support chatbot - Help system
10. Disbursement system - Money transfer

**External Components:**
1. User's smartphone - Access device
2. User's mobile money account - Payment method
3. User's contacts/social network - Verification
4. Local merchants - Transaction ecosystem
5. Mobile network connectivity - Communication
6. Peer borrowers - Community
7. User's location data - Context
8. Government ID systems - Verification
9. Alternative data sources - Credit signals

---

### SUBSTITUTE Ideas

1. **Idea:** Replace traditional credit score with "merchant trust score"
   **What's substituted:** Formal credit bureau data → Endorsements from local merchants where user shops
   **Potential benefit:** Serves unbanked better, builds community ties

2. **Idea:** Substitute manual loan approval with instant AI approval
   **What's substituted:** Loan officer review → Algorithm-only decision
   **Potential benefit:** Faster turnaround, lower costs, 24/7 availability

3. **Idea:** Replace SMS notifications with WhatsApp messages
   **What's substituted:** SMS → WhatsApp Business API
   **Potential benefit:** Richer interactions, lower cost, better engagement

4. **Idea:** Substitute individual lending with group lending pools
   **What's substituted:** One-to-one (FairCredit to user) → Peer pool model
   **Potential benefit:** Social pressure for repayment, community building

5. **Idea:** Replace monthly repayment with daily micro-payments
   **What's substituted:** Monthly lump sum → Daily small amounts
   **Potential benefit:** Matches cash flow for daily traders, reduces default risk

6. **Idea:** Substitute cash disbursement with airtime/goods vouchers
   **What's substituted:** Money transfer → Direct vouchers
   **Potential benefit:** Ensures loan used for intended purpose, partnerships with merchants

7. **Idea:** Replace mobile app with USSD interface (no smartphone needed)
   **What's substituted:** Smartphone app → Feature phone USSD codes
   **Potential benefit:** Reaches users without smartphones, truly inclusive

8. **Idea:** Substitute interest payments with revenue sharing
   **What's substituted:** Fixed interest → Percentage of business revenue
   **Potential benefit:** Aligns incentives, fair during slow periods

---

### COMBINE Ideas

1. **Idea:** Combine loan approval with savings account creation
   **What's combined:** Borrowing + Saving
   **Potential benefit:** Builds financial health, creates asset base, cross-selling

2. **Idea:** Merge repayment with mobile airtime purchase
   **What's combined:** Debt payment + Essential service
   **Potential benefit:** Convenient single transaction, guaranteed repayment

3. **Idea:** Integrate loan product with business training
   **What's combined:** Capital + Knowledge
   **Potential benefit:** Higher success rates, customer loyalty, social impact

4. **Idea:** Combine credit scoring with health insurance enrollment
   **What's combined:** Financial profile + Health risk assessment
   **Potential benefit:** Comprehensive protection, new revenue stream

5. **Idea:** Merge transaction history with inventory management
   **What's combined:** Payment data + Stock tracking
   **Potential benefit:** Help traders manage business, increase repayment capacity

6. **Idea:** Integrate disbursement with supplier payment directly
   **What's combined:** Loan + Purchase order
   **Potential benefit:** Ensures proper use, builds supplier relationships

7. **Idea:** Combine customer support with financial literacy education
   **What's combined:** Help desk + Training
   **Potential benefit:** Empowerment, better financial decisions, loyalty

8. **Idea:** Merge loan marketplace with peer-to-peer lending
   **What's combined:** FairCredit funding + Individual lenders
   **Potential benefit:** Lower cost of capital, community investment

---

### ADAPT Ideas

1. **Idea:** Adapt "buy now, pay later" model from e-commerce
   **Adapted from:** Klarna, Afterpay retail checkout financing
   **Potential benefit:** Instant purchasing power at point of sale

2. **Idea:** Borrow gamification from fitness apps
   **Adapted from:** Strava challenges, Duolingo streaks
   **Potential benefit:** Make repayment engaging, build positive habits

3. **Idea:** Adapt credit-building from US secured credit cards
   **Adapted from:** Capital One, Chime credit builder
   **Potential benefit:** Help users graduate to formal banking

4. **Idea:** Copy subscription model from streaming services
   **Adapted from:** Netflix, Spotify premium tiers
   **Potential benefit:** Predictable revenue, tiered access to loan amounts

5. **Idea:** Borrow social proof from Airbnb reviews
   **Adapted from:** Two-way ratings (borrower rates lender experience too)
   **Potential benefit:** Trust building, quality control

6. **Idea:** Adapt autopay from utility bills
   **Adapted from:** Electricity, water automatic deductions
   **Potential benefit:** Reduced defaults, convenience

7. **Idea:** Copy referral rewards from Dropbox growth model
   **Adapted from:** Storage space for referrals → Interest discount for referrals
   **Potential benefit:** Viral growth, community building

8. **Idea:** Borrow dynamic pricing from Uber surge
   **Adapted from:** Interest rates adjust based on demand/risk real-time
   **Potential benefit:** Market efficiency, manages risk

---

### MODIFY Ideas (Magnify/Minify)

1. **Idea:** Magnify loan frequency - allow borrowing multiple times per week
   **What's modified:** Frequency (monthly → multiple weekly)
   **Potential benefit:** Matches market trader cash flow cycles

2. **Idea:** Minify loan application to 3 taps
   **What's modified:** Process length (20 min → 30 seconds)
   **Potential benefit:** Frictionless experience, higher conversion

3. **Idea:** Amplify repayment flexibility - choose any amount, any time
   **What's modified:** Rigidity → Complete flexibility
   **Potential benefit:** Reduces stress, accommodates variable income

4. **Idea:** Reduce interest rate but add membership fee
   **What's modified:** Pricing structure (high % → low % + flat fee)
   **Potential benefit:** Fairness for larger loans, predictable revenue

5. **Idea:** Magnify social features - borrower community forums
   **What's modified:** Isolation → Community (minimal → extensive social)
   **Potential benefit:** Peer support, knowledge sharing, retention

6. **Idea:** Minify documentation required - no forms, just phone number
   **What's modified:** Requirements (extensive → minimal)
   **Potential benefit:** Accessibility, speed, inclusivity

7. **Idea:** Amplify loan amounts progressively based on good history
   **What's modified:** Loan ceiling (static → growing with trust)
   **Potential benefit:** Loyalty, growth incentive, risk management

8. **Idea:** Reduce repayment period for discount (7 days instead of 30)
   **What's modified:** Time (shorter duration = lower total cost)
   **Potential benefit:** Faster capital recycling, rewards discipline

---

### PUT TO OTHER USES Ideas

1. **Idea:** Use transaction history analysis for business insights dashboard
   **Component repurposed:** Transaction analyzer
   **New use:** Originally for credit assessment → Now business intelligence tool
   **Potential benefit:** Value-add service, helps users grow revenue

2. **Idea:** Repurpose SMS system for emergency alerts and community news
   **Component repurposed:** Notification infrastructure
   **New use:** Loan reminders → Community information channel
   **Potential benefit:** Engagement, social value, brand building

3. **Idea:** Use loan algorithm to power supplier credit for merchants
   **Component repurposed:** Scoring engine
   **New use:** Consumer lending → B2B trade credit
   **Potential benefit:** New market, ecosystem expansion

4. **Idea:** Leverage customer support chatbot for pre-loan financial counseling
   **Component repurposed:** Support bot
   **New use:** Troubleshooting → Proactive financial advice
   **Potential benefit:** Better outcomes, differentiation

5. **Idea:** Repurpose user location data for merchant discovery
   **Component repurposed:** Location tracking
   **New use:** Risk assessment → Local business directory
   **Potential benefit:** Connect users to suppliers, marketplace revenue

6. **Idea:** Use repayment tracking for personal budgeting tool
   **Component repurposed:** Payment monitor
   **New use:** Loan tracking → Overall expense management
   **Potential benefit:** Financial wellness, stickiness

7. **Idea:** Leverage social network data for job referrals
   **Component repurposed:** Contact analysis
   **New use:** Verification → Employment opportunities
   **Potential benefit:** Income growth, repayment capacity

8. **Idea:** Repurpose disbursement system for person-to-person transfers
   **Component repurposed:** Money movement infrastructure
   **New use:** Lending → General payments
   **Potential benefit:** Compete with mobile money, daily usage

---

### ELIMINATE Ideas

1. **Idea:** Eliminate the mobile app entirely - pure SMS/USSD
   **What's eliminated:** Smartphone app requirement
   **How it still works:** All interactions via SMS commands
   **Potential benefit:** Universal access, simplicity, lower barriers

2. **Idea:** Remove loan approval step - instant auto-disbursement
   **What's eliminated:** Manual review, waiting period
   **How it still works:** Algorithm pre-approves amount based on history
   **Potential benefit:** Instant gratification, emergency access

3. **Idea:** Eliminate interest entirely - flat fee model only
   **What's eliminated:** Compound interest calculation
   **How it still works:** Simple ₦500 fee regardless of loan size/duration
   **Potential benefit:** Transparency, trust, simplicity

4. **Idea:** Remove individual accounts - family/group accounts only
   **What's eliminated:** Personal liability
   **How it still works:** Shared responsibility within trusted group
   **Potential benefit:** Cultural fit, lower risk, social bonds

5. **Idea:** Eliminate repayment reminders - trust users to remember
   **What's eliminated:** SMS notifications, push alerts
   **How it still works:** Users take responsibility, only contact if late
   **Potential benefit:** Respect, lower costs, dignity

6. **Idea:** Remove credit checks completely - trust-based lending only
   **What's eliminated:** Scoring algorithm
   **How it still works:** Start everyone with small amount, grow with behavior
   **Potential benefit:** True inclusion, simplicity, speed

7. **Idea:** Eliminate customer support - peer support community only
   **What's eliminated:** Dedicated support team
   **How it still works:** Experienced borrowers help new ones
   **Potential benefit:** Cost savings, community, scalability

8. **Idea:** Remove loan products menu - one standard product only
   **What's eliminated:** Choice complexity
   **How it still works:** Single amount, single term, simple
   **Potential benefit:** Clarity, speed, reduced confusion

---

### REVERSE Ideas

1. **Idea:** Reverse lending direction - users lend to FairCredit first
   **What's reversed:** Money flow (FairCredit → User becomes User → FairCredit first)
   **Potential benefit:** Builds savings before borrowing, reduces risk

2. **Idea:** Flip the credit-building model - start high trust, decrease if they fail
   **What's reversed:** Traditional "prove yourself" → "We trust you until proven otherwise"
   **Potential benefit:** Dignified, optimistic, motivating

3. **Idea:** Reverse payment model - borrowers propose their own interest rate
   **What's reversed:** Lender sets price → Borrower bids
   **Potential benefit:** Market discovery, empowerment, transparency

4. **Idea:** Invert support flow - borrowers teach financial literacy to others
   **What's reversed:** FairCredit teaches users → Users teach each other
   **Potential benefit:** Community ownership, peer learning, scale

5. **Idea:** Flip timing - repay before borrowing (pay-forward model)
   **What's reversed:** Borrow then repay → Repay then borrow
   **Potential benefit:** Zero default risk, savings culture

6. **Idea:** Reverse verification - merchants verify users, not FairCredit
   **What's reversed:** Centralized verification → Distributed verification
   **Potential benefit:** Community trust, accuracy, relationships

7. **Idea:** Invert disbursement - pull not push (user withdraws when needed)
   **What's reversed:** Lump sum on approval → Credit line, user controls timing
   **Potential benefit:** Flexibility, only borrow what's needed, lower total interest

8. **Idea:** Reverse growth path - start urban, move rural (opposite of microfinance)
   **What's reversed:** Typical rural-first → Urban-first to build proof
   **Potential benefit:** Faster initial traction, easier infrastructure

---

### Summary

**Total ideas generated:** 56 ideas across 7 SCAMPER techniques

**Ideas to explore further (quick filtering):**
- Merchant trust score (Substitute #1) - Strong cultural fit
- Combine loan with business training (Combine #3) - High impact
- USSD for feature phones (Substitute #7) - Massive market expansion
- Transaction history → business insights (Put to other uses #1) - Value-add
- Daily micro-payments (Substitute #5) - Cash flow match
- Eliminate app, pure SMS (Eliminate #1) - Inclusion
- Borrower-proposed interest rate (Reverse #3) - Innovative
- Group lending pools (Substitute #4) - Community strength
- Pay-forward model (Reverse #5) - Cultural respect
- Gamification of repayment (Adapt #2) - Engagement

**Ready for:** idea-evaluation skill to systematically rate these ideas on customer value, feasibility, viability, and strategic fit.

**Observations:**
- ELIMINATE and REVERSE techniques generated most culturally innovative ideas
- ADAPT brought in proven models from other contexts
- COMBINE revealed service expansion opportunities
- SUBSTITUTE focused on accessibility improvements

---

## Example 2: AsyncFlow (Southeast Asia Remote Collaboration) - Abbreviated

### Closed World Reference (Brief)

**Internal:** Message threads, video call system, document editor, notification engine, status updates, search function, integrations API, user presence tracking, file storage, task assignments

**External:** User's timezone, user's work schedule, team members, internet connection, external tools (Slack, email), client communications, company culture, deadlines

### Selected SCAMPER Ideas (10 examples across techniques)

**SUBSTITUTE:**
- Replace synchronous notifications with daily digest summaries
- Substitute video calls with async video messages (Loom-style)

**COMBINE:**
- Merge status updates with time-zone aware scheduling
- Integrate task completion with automatic documentation

**ADAPT:**
- Borrow "office hours" concept from professors (scheduled live availability)
- Adapt Wikipedia's talk pages for threaded decision-making

**MODIFY:**
- Amplify context in every message (auto-include relevant links, past decisions)
- Minify meeting length cap (maximum 25 minutes enforced)

**PUT TO OTHER USES:**
- Repurpose message threads as knowledge base articles
- Use timezone data for automatic work-life balance monitoring

**ELIMINATE:**
- Remove real-time presence indicators (reduce FOMO)
- Eliminate "urgent" flag (everything is async)

**REVERSE:**
- Reverse meeting default: async-first, require justification for live meetings
- Flip response expectations: depth over speed valued

**Total: 35+ ideas generated** → Ready for evaluation

---

## Example 3: SolarSeva (Rural India Home Solar) - Abbreviated

### Closed World Reference (Brief)

**Internal:** Solar panels, battery bank, inverter, charge controller, installation hardware, monitoring sensors, warranty terms, local technician network (SolarSeva-trained), sales reps, installation teams, customer support, financing model, pricing plans, subsidy processing

**External:** Sunlight, roof space, household electricity needs, power grid (unreliable), customer's income patterns, monsoon weather, family members, diesel generator (being replaced), customer's UPI accounts, government subsidy program

### Selected SCAMPER Ideas (10 examples across techniques)

**SUBSTITUTE:**
- Replace upfront payment with lease-to-own model
- Substitute battery bank with grid-tie and net metering

**COMBINE:**
- Merge solar system with water purification
- Integrate monitoring with micro-insurance against failure

**ADAPT:**
- Borrow mobile money payment from M-Pesa model
- Adapt Netflix subscription tiers (basic/premium solar capacity)

**MODIFY:**
- Modular panels (start small, add capacity over time)
- Magnify battery storage for selling back to grid

**PUT TO OTHER USES:**
- Use technician network for other appliance repairs (new revenue)
- Repurpose monitoring system for home security

**ELIMINATE:**
- Remove inverter for DC-only appliances (simpler, cheaper)
- Eliminate installation appointment (ship pre-assembled, user installs)

**REVERSE:**
- Reverse ownership: SolarSeva owns system, user pays for electricity
- Community solar (shared system) instead of individual

**Total: 40+ ideas generated** → Ready for evaluation

---

## Example 4: Unbroken (Sweden Disaster Logistics) - Abbreviated

### Closed World Reference (Brief)

**Internal:** Offline sync engine, mesh network capability, logistics optimization algorithm, inventory tracking, route planning, supplier database, priority system, mobile/desktop apps, data encryption, conflict resolution logic

**External:** Internet outages, natural disasters, warehouse staff, transport vehicles, damaged infrastructure, emergency timelines, supplier locations, government regulations, competing priorities

### Selected SCAMPER Ideas (10 examples across techniques)

**SUBSTITUTE:**
- Replace central server with fully distributed blockchain
- Substitute GPS routing with offline maps + manual updates

**COMBINE:**
- Merge logistics tracking with crisis communication platform
- Integrate inventory with predictive disaster modeling

**ADAPT:**
- Borrow Bitcoin's proof-of-work for data consensus
- Adapt military supply chain resilience tactics

**MODIFY:**
- Amplify offline capability: 30 days without internet
- Minify data payload: extreme compression for satellite links

**PUT TO OTHER USES:**
- Repurpose mesh network for post-disaster communications
- Use optimization algorithm for normal operations, not just disasters

**ELIMINATE:**
- Remove dependency on cloud servers entirely
- Eliminate real-time analytics (batch processing only)

**REVERSE:**
- Reverse data flow: edge-to-center, not center-to-edge
- Flip priority: availability over consistency (eventual accuracy acceptable)

**Total: 38+ ideas generated** → Ready for evaluation

---

## Cross-Cutting Insights

### Patterns Across All Four Examples

**SUBSTITUTE often reveals:**
- Technology replacements (digital ↔ analog, smart ↔ simple)
- Business model alternatives
- Accessibility improvements

**COMBINE often reveals:**
- Service expansion opportunities
- Cross-selling and bundling
- Ecosystem plays

**ADAPT often reveals:**
- Proven patterns from other industries
- Cultural borrowing
- Scale transfer (large → small or vice versa)

**MODIFY often reveals:**
- Optimization opportunities
- Market segmentation (different sizes/speeds for different users)
- Simplification or enhancement paths

**PUT TO OTHER USES often reveals:**
- Hidden assets that can generate new revenue
- Platform opportunities
- Repurposing waste/byproducts

**ELIMINATE often reveals:**
- Simplification that increases adoption
- Cost reduction opportunities
- Challenging industry assumptions

**REVERSE often reveals:**
- Business model innovations
- Cultural fit improvements
- Disruptive rethinking

### Technique Selection Strategy

**When time-constrained, prioritize:**
1. **ELIMINATE** - Often highest impact, hardest to see without structured approach
2. **REVERSE** - Generates most disruptive, differentiated ideas
3. **COMBINE** - Reveals ecosystem and expansion opportunities

**For incremental innovation:**
- MODIFY, SUBSTITUTE, ADAPT

**For breakthrough innovation:**
- ELIMINATE, REVERSE, PUT TO OTHER USES

**For comprehensive exploration:**
- Use all 7 systematically (60-90 minutes)

---

## Tips Based on Examples

1. **Let Closed World guide you:** FairCredit's "merchant" component led to merchant trust score idea
2. **Cultural context matters:** Nigeria/India examples emphasized community and cash flow
3. **Don't self-censor:** "Eliminate the app" sounds crazy but led to USSD inclusion breakthrough
4. **Build on ideas:** AsyncFlow's "async video" (Substitute) + "auto-context" (Modify) could combine
5. **Quantity works:** 40-50 ideas ensures some gems emerge
6. **Vary scale:** Some ideas are features, some are business model pivots - both valuable
7. **Note your surprises:** Which ideas excited you? Which technique was most productive?

---

## Ready for Next Phase

After generating 30-50+ ideas with SCAMPER:

1. **Quick filter:** Remove duplicates and nonsense (10 minutes)
2. **Group:** Related ideas as variations (5 minutes)
3. **Evaluate:** Use idea-evaluation skill to score and rank (1-2 hours)
4. **Validate:** Use critical-validation skill on top 3-5 (2-3 hours per idea)
5. **Solve:** Use technical-breakthrough if hard problems emerge

The SCAMPER phase is about divergent thinking—generating possibilities. The next phases are convergent—selecting the best and validating feasibility.
