# SCAMPER Framework for Systematic Ideation

## Overview

SCAMPER is a creative thinking technique developed by Bob Eberle in 1971, building on Alex Osborn's brainstorming checklist. It provides seven distinct lenses for generating innovative ideas by manipulating existing components in different ways.

## Why SCAMPER Works

**Systematic coverage:** Ensures you explore multiple types of innovations, not just the obvious ones

**Constraint-based:** Works within Closed World—uses what you have, not what you wish you had

**Proven patterns:** Each technique maps to real-world innovation patterns used by successful products

**Complementary techniques:** Different techniques reveal different opportunities

**Quantity drives quality:** Systematic approach generates enough ideas to find breakthrough thinking

## The Seven SCAMPER Techniques

### 1. SUBSTITUTE - Replace with Alternatives

**Core question:** What can you replace or swap out?

**Innovation pattern:** Finding better, cheaper, or more suitable alternatives

**Types of substitution:**
- Materials (metal → plastic → carbon fiber)
- Components (mechanical → electronic)
- Processes (manual → automated)
- People/roles (expert → user, individual → crowd)
- Power sources (battery → solar → kinetic)
- Channels (physical → digital)

**Real-world examples:**
- Uber: Substitute taxi company employees with independent contractors
- Airbnb: Substitute hotel buildings with people's homes
- Digital cameras: Substitute film with sensors and memory

**Prompting questions:**
- What materials could be substituted?
- What other processes could be used?
- What other ingredients or components could work?
- Can automation substitute for manual work?
- What cheaper alternative exists?
- Can we substitute the location, time, or context?

---

### 2. COMBINE - Merge Components

**Core question:** What can you bring together or integrate?

**Innovation pattern:** Creating new value through integration

**Types of combination:**
- Features (phone + camera + computer = smartphone)
- Services (ride + food delivery)
- Data sources (credit score + social + transactions)
- User roles (consumer + creator)
- Processes (payment + verification)
- Purposes (furniture + storage)

**Real-world examples:**
- Smartphone: Combined camera, computer, phone, GPS, music player
- Swiss Army knife: Combined multiple tools in one
- Spotify: Combined music library + social sharing + discovery

**Prompting questions:**
- What components could be merged?
- Can we combine purposes or functions?
- What can be packaged together?
- Can we blend different user groups?
- Can we integrate with complementary products?
- What processes could happen simultaneously?

---

### 3. ADAPT - Borrow from Other Contexts

**Core question:** What can you copy or borrow from elsewhere?

**Innovation pattern:** Cross-pollination from different industries or contexts

**Types of adaptation:**
- From nature (Velcro from burrs, bullet trains from kingfisher)
- From other industries (assembly line from meatpacking → automotive)
- From different cultures (management practices, service approaches)
- From past/historical solutions (bringing back old ideas)
- From adjacent problems (solving A like we solved B)

**Real-world examples:**
- Zara: Adapted fast fashion from Toyota's just-in-time manufacturing
- Hospital hygiene: Adapted checklists from aviation
- Netflix recommendations: Adapted collaborative filtering from Amazon

**Prompting questions:**
- What does this remind me of in nature?
- How do other industries solve similar problems?
- What worked in the past that we've forgotten?
- How do other cultures handle this?
- What adjacent problem has a good solution we could borrow?
- Can we adapt a solution from a larger/smaller scale?

---

### 4. MODIFY/MAGNIFY/MINIFY - Change Attributes

**Core question:** What can you change, amplify, or reduce?

**Innovation pattern:** Variation and optimization through parameter changes

**Types of modification:**
- Scale (bigger, smaller)
- Shape (form factor)
- Color, sound, texture (sensory)
- Speed (faster, slower)
- Frequency (more often, less often)
- Strength/power (amplify, reduce)
- Flexibility (more rigid, more flexible)

**Real-world examples:**
- iPod Mini/Nano: Minified the original iPod
- Supersizing: Magnified portion sizes
- Instagram Stories: Modified permanence (24-hour vs forever)
- Dyson: Modified vacuum suction (amplified power)

**Prompting questions:**
- What if we made it 10x bigger? 10x smaller?
- What if we made it faster? Slower?
- Can we change the shape or form?
- What if we amplified this feature?
- What if we reduced or weakened this attribute?
- Can we change the timing or frequency?
- What if we made it more flexible? More rigid?

---

### 5. PUT TO OTHER USES - Repurpose

**Core question:** What else can this be used for?

**Innovation pattern:** Finding new applications for existing components

**Types of repurposing:**
- New user segments (industrial → consumer)
- New contexts (indoor → outdoor)
- New problems (original purpose → alternative purpose)
- Waste/byproducts → valuable outputs
- Secondary functions become primary

**Real-world examples:**
- Bubble wrap: Originally wallpaper, repurposed for packaging
- Play-Doh: Originally wallpaper cleaner, repurposed as toy
- Arm & Hammer baking soda: Cooking → deodorizing → cleaning → toothpaste
- Twitter: Status updates → news distribution → customer service

**Prompting questions:**
- Who else could use this?
- What other problems could this solve?
- Can waste become valuable?
- Can a secondary feature become the main purpose?
- What if we target a completely different user?
- Can this work in a different environment?

---

### 6. ELIMINATE - Remove Components

**Core question:** What can you remove or simplify?

**Innovation pattern:** Simplification and minimalism revealing new value

**Types of elimination:**
- Features (do less, better)
- Steps in a process (reduce friction)
- Parts/components (simplify)
- Options (reduce choice paralysis)
- Requirements (lower barriers)
- Intermediaries (disintermediation)

**Real-world examples:**
- Google homepage: Eliminated clutter, just search
- Dollar Shave Club: Eliminated retail stores
- Craigslist: Eliminated fancy design
- Direct-to-consumer brands: Eliminated middlemen

**Prompting questions:**
- What if we removed this feature entirely?
- What steps in the process can we skip?
- What components aren't essential?
- Can we eliminate intermediaries?
- What requirements create unnecessary barriers?
- What if we did less but better?
- Can we eliminate user effort or input?

---

### 7. REVERSE/REARRANGE - Flip or Reorder

**Core question:** What can you flip, invert, or resequence?

**Innovation pattern:** Challenging assumptions through inversion

**Types of reversal:**
- Process order (end → beginning)
- Roles (provider → consumer, teacher → student)
- Direction (push → pull, centralized → distributed)
- Timing (before → after, proactive → reactive)
- Ownership (buy → rent, keep → share)
- Information flow (broadcast → narrowcast)

**Real-world examples:**
- Freemium: Reversed "pay first, use later" to "use first, pay later"
- Khan Academy: Reversed lecture at school/homework at home
- Reverse auctions: Buyers set price, sellers compete
- Pre-orders: Payment before product exists

**Prompting questions:**
- What if we reversed the process order?
- Can provider and consumer switch roles?
- What if we flipped this relationship?
- Can we rearrange the sequence?
- What if timing was opposite?
- Can we reverse the direction of flow?
- What if ownership model was inverted?

---

## Using SCAMPER with Closed World

The power of SCAMPER amplifies when combined with Closed World mapping:

1. **Start with Closed World map** - Know what components you have
2. **Apply each SCAMPER technique** to components systematically
3. **Stay within constraints** - Use existing components, don't add new ones (that's for later)
4. **Generate quantity** - Aim for 5-10 ideas per technique
5. **Defer judgment** - Evaluation comes after generation

**Example - FairCredit Closed World:**
- Internal: Loan algorithm, mobile app, repayment tracking, SMS notifications, user profile, transaction history
- External: User's contacts, user's phone, mobile money networks, local merchants, peer borrowers

**SCAMPER on this Closed World:**
- **Substitute:** Replace credit score with merchant endorsements
- **Combine:** Merge loan approval with airtime purchase
- **Adapt:** Borrow peer verification from crowdfunding
- **Modify:** Magnify repayment frequency (daily instead of monthly)
- **Put to other uses:** Use SMS for financial literacy, not just notifications
- **Eliminate:** Remove formal application, approve based on transaction history alone
- **Reverse:** Let borrowers set loan terms, lenders compete

---

## SCAMPER Session Best Practices

### Preparation (5-10 minutes)
- Have PRFAQ and Closed World map visible
- Clear workspace, minimize distractions
- Set timer for 60-90 minutes total
- Get into creative mindset

### Generation (50-70 minutes)
- Work through techniques in order (about 8-10 min each)
- Write down everything, no filtering
- If stuck, use prompting questions
- Build on previous ideas
- Take brief breaks between techniques

### Quick Review (10 minutes)
- Remove obvious duplicates
- Flag ideas that excite you
- Note which techniques were most productive
- Prepare for evaluation phase

### Common Blocks and Solutions

**Block:** "Can't think of anything for this technique"
**Solution:** Use prompting questions, look at examples, skip and return later

**Block:** "All ideas seem obvious or bad"
**Solution:** Quantity over quality—keep going, breakthrough often comes after obvious ideas

**Block:** "Forgetting the Closed World constraint"
**Solution:** Keep map visible, reference frequently

**Block:** "Taking too long on one technique"
**Solution:** Set 10-minute timer per technique, move on when it rings

---

## Output from SCAMPER

**Immediate output:** 30-50+ raw ideas across 7 techniques

**After quick filtering:** 25-40 ideas worth evaluating

**After evaluation (next phase):** Top 3-5 ideas for deep validation

**After validation (later phase):** 1-2 ideas to implement

The funnel starts wide (SCAMPER generates quantity) and narrows through subsequent phases.

---

## Integration with Innovation Journey

**Input from previous phase (solution-definition):**
- PRFAQ defines the problem and vision
- Closed World provides components to manipulate
- Customer pains/gains guide what matters

**Output to next phase (idea-evaluation):**
- Large pool of diverse ideas
- Ideas grounded in feasible components
- Ideas mapped to techniques (helps with evaluation)

**Later phases use SCAMPER output:**
- Evaluation rates ideas on multiple criteria
- Validation deep-dives on top ideas
- Technical breakthrough solves hard problems discovered

---

## When to Use SCAMPER vs Other Methods

**Use SCAMPER when:**
- You have a defined solution space (Closed World)
- You want systematic, comprehensive ideation
- You need quantity of diverse ideas
- You're working within constraints

**Use other methods when:**
- Blue-sky exploration without constraints → brainstorming
- Evaluating existing ideas → Six Hats, evaluation matrices
- Solving technical contradictions → TRIZ
- Improving existing products → customer feedback analysis

SCAMPER is the bridge between "what should we build" (PRFAQ) and "which ideas are best" (evaluation). It generates the raw material for the later selection and validation phases.
