# PRFAQ Writer

**Description**: Write compelling PRFAQ (Press Release + FAQ) documents using Amazon's Working Backwards methodology to develop customer-centric innovations.

---

## Purpose

The PRFAQ Writer skill helps you create customer-centric innovation documents using Amazon's Working Backwards methodology. A PRFAQ is a 4-6 page document that starts with the customer experience and works backward to define the product or service. By writing the press release first, you force clarity about the customer problem, the solution, and the value proposition before investing in development.

This skill guides you through:
- The 5 Working Backwards Questions to frame the customer problem
- Today Statement creation to articulate the current state
- Press Release writing (7-paragraph structure)
- Customer FAQs (~7-10 questions addressing customer concerns)
- Stakeholder FAQs (~7-10 questions addressing risks and implementation)
- Optional visuals (journey maps, wireframes, mockups)

## When to Use This Skill

Use PRFAQ Writer when you need to:
- Develop a new product or service concept
- Pitch an innovation idea to leadership or stakeholders
- Force clarity about customer value before building
- Align teams around a customer-centric vision
- Document a feature or initiative with customer focus
- Replace traditional requirement documents with customer narratives
- Test if an idea solves a meaningful customer problem

Don't use this skill for:
- Small bug fixes or minor improvements
- Technical specifications without customer impact
- Internal process changes (unless they impact customers - although it is great to use it for internal customers for certain teams who serve those - e.g. Human Resources or IT department)
- Ideas still in brainstorming phase (use Ideation and Idea Evaluation tools first)

## Input Required

### Minimum Information Needed:
- General concept or idea you want to develop
- Target customer or user group (can be refined during process)
- Problem space or opportunity area

### Helpful But Optional:
- Customer research or insights
- Market data or competitive analysis
- Technical constraints or requirements
- Business goals or success metrics
- Existing solutions and their limitations

## Execution Modes
Explian these two modes and ask the user which mode they want to use.

### Mode 1: Interactive Mode (Recommended for First-Time Users)
Walk through each section step-by-step with guidance and examples. Claude will ask questions, provide feedback, and help refine your thinking at each stage.

**Best for**: Learning the methodology, complex innovations, team collaboration

### Mode 2: Autonomous Mode
Provide your idea and available information, and Claude will draft a complete PRFAQ for your review and refinement.

**Best for**: Experienced users, time constraints, draft starting points

---

## The PRFAQ Structure

A complete PRFAQ document consists of:

### 1. Press Release (1 page, ~7 paragraphs)
The customer-facing announcement written as if the product/service launched today.

### 2. Customer FAQs (2-3 pages, 7-10 questions)
Questions customers would ask about using the product/service.

### 3. Stakeholder FAQs (2-3 pages, 7-10 questions)
Questions internal teams would ask about building and launching it.

### 4. Visuals (Optional appendix)
Journey maps, wireframes, mockups, or diagrams that clarify the experience.

**Formatting Standards**:
- 11pt font (Calibri or Arial)
- Line numbers on the left margin
- 4-6 pages for core document (excluding visuals)
- No bullet points in narrative sections
- Single-spaced with clear section headers

---

## Workflow

### Phase 1: Foundation - The 5 Working Backwards Questions

Before writing anything, answer these fundamental questions:

#### Question 1: Who is the customer?
Be specific about the target customer segment. Avoid "everyone" - narrow down to a specific group.
The key principle is that while other types of users may end up using the solution, this specific customer definition helps us decide who do we want to delight most. Who exemplifies the current friction or gap in the most prominent way.

**Examples**:
- "Swedish residents over 16 who need to access government digital services"
- "Small business owners with 5-50 employees who struggle with payroll processing"
- "Parents of children ages 3-8 who want to encourage reading habits"

#### Question 2: What is the customer problem or opportunity?
Describe the current pain point or unmet need in detail. What frustration or gap exists today? Which missed opportunity is not leveraged?

**Examples**:
- "Citizens struggle with multiple authentication methods across government services, leading to forgotten passwords and access barriers"
- "Small business owners spend 4-6 hours per month on manual payroll calculations and compliance checks"
- "Parents have difficulty finding age-appropriate books and tracking reading progress across multiple children"

#### Question 3: What is the most important customer benefit?
What is the single biggest value your solution provides? This should be transformative, not incremental.
The specific problem, for the specific customer we chose may carry different oportunities. But we want to make sure we delight and over-deliver on the one things they really care about.
It should also try to avoid a definition of a specific solution - technology, process, service, program.

**Examples**:
- "Access all government services with ease"
- "Reduce payroll processing time from hours to minutes while ensuring 100% compliance"
- "Discover perfect books for your child's reading level and celebrate their progress together"

#### Question 4: How do you know what customers need or want?
What evidence supports that this problem is real and worth solving?

**Examples**:
- "Government research shows 23% of citizens abandon digital services due to authentication problems; customer support receives 15,000 password-related calls monthly"
- "Survey of 500 small business owners revealed payroll as #2 time burden; 67% reported compliance anxiety"
- "Parent interviews revealed 82% struggle to find appropriate books; reading engagement drops 40% between ages 5-8"

#### Question 5: What does the customer experience look like?
Paint a vivid picture of the customer using your solution. Tell a story.

**Example**:
"Sofia, a 34-year-old parent in Stockholm, needs to update her address after moving. She opens ID-me on her phone, authenticates with Face ID, and immediately sees all services requiring her new address: tax agency, health services, unemployment insurance, and her child's school registration. She updates her address once, and ID-me propagates it to all connected services. The entire process takes 2 minutes. No usernames to remember, no forms to fill out multiple times, no follow-up calls needed."

**🎯 Deliverable**: Complete answers to all 5 questions before proceeding to press release.

---

### Phase 2: Today Statement (Optional but Recommended)
In interactive mode discuss this and refine the today statement with the user, showing them 3 options and asking which on resonates. In autonomous mode - create a suggestion of a today statement and show it to them to approve or comment.
Create a structured problem statement using this format:

**TODAY STATEMENT TEMPLATE**:
```
Today [customers]
Have to [customer problem]
When [situation when the problem occurs]
[Customers] need [most important benefit]
```

**Example**:
```
Today Swedish residents, who have a family with young children, and manage their family’s affairs,
have to remember different passwords and go through multi-step verification processes,
whenever they need to use digital services at banks, public services, healthcare or education providers.
They need a simple way to use digital services which require secure identity verification.
```

**🎯 Deliverable**: One-paragraph Today Statement that frames the problem and direction.

---

### Phase 3: Press Release - The 7 Paragraph Structure

Write a one-page press release announcing your innovation as if it launched today. Use past tense ("announced," "launched") to make it feel real.

#### Paragraph 1: Elevator Pitch (The Lead)
**Purpose**: Hook the reader in 2-3 sentences. What is it, who is it for, and what's the key benefit?

**Anatomy**:
- Headline: Clear product/service name + key benefit - 5-7 words, ideally with 1 word for the solution name
- Sub-headline: One-sentence expansion of the value proposition
- Lead paragraph: Location, date, launch announcement, and core benefit

**Example**:
```
Secure, Seamless Access to Swedish Digital Services with ID-me
Effortless authentication for anyone over 16 years old - access essential services with just your phone

STOCKHOLM, Dagens Nyheter, 1/1/2025. ID-me now allows Swedish residents to easily and securely login to all online digital services. The service works with everything from financial services to healthcare and government platforms. It works through a free mobile app with a few simple taps. By providing a single, secure digital identity, ID-me empowers users to control and manage their personal information across a wide range of essential services with a single and hassle-free solution.
```

**Tips**:
- Make the headline compelling but not clever - clarity over creativity
- Use concrete language, not buzzwords
- Include the city and publication to ground it in reality

#### Paragraph 2: Problem
**Purpose**: Describe the current painful reality. Make readers nod and say "yes, that's exactly my frustration!"

**Anatomy**:
- Start with "Until now", "Currently", or "Until today" to contrast with the new solution
- Be specific about pain points - use concrete details
- Quantify the impact if possible
- Show empathy for the customer struggle

**Example**:
```
Currently, Swedish residents face significant challenges when accessing government digital services. Each agency and municipality requires different authentication methods, usernames, and passwords. Citizens must remember multiple sets of credentials or repeatedly reset forgotten passwords through cumbersome email verification processes. This fragmentation leads to 23% of users abandoning critical services like tax filing, health records access, and benefit applications. Support centers receive over 15,000 authentication-related calls each month, and many citizens, particularly elderly residents and recent immigrants, avoid digital services entirely despite their convenience.
```

**Tips**:
- Use customer language, not internal jargon
- Include emotional impact, not just functional problems
- Reference your customer research or data
- Make it relatable to the target audience
- Do not mention the solution yet - this comes in the next paragraph

#### Paragraph 3: Solution
**Purpose**: Describe how your innovation solves the problem. Focus on what it does, not how it works technically.

**Anatomy**:
- Start with the product/service name
- Explain the core functionality in customer terms
- Highlight 2-4 key features that address the pain points
- Show the before/after transformation
- Use active, concrete verbs

**Example**:
```
ID-me solves these problems by providing one simple and secure way to verify your identity for all the services you need. Whether you’re logging into your bank account, accessing healthcare, or signing important documents, you can use ID-me from any device. Instead of juggling passwords or carrying physical identification, you can confirm your identity with just your phone. Your personal information stays safe while you enjoy the convenience of fast, easy access to everything that matters.
```

**Tips**:
- Focus on customer benefits, not technical architecture
- Use "by doing X" construction to show cause-and-effect
- Avoid superlatives or adjectives like "innovative" or "revolutionary" - show, don't tell
- Keep it to 4-6 sentences maximum

#### Paragraph 4: Leader Quote
**Purpose**: Add credibility and vision through a quote from a relevant executive or leader.

**Anatomy**:
- Attribution with full name and title
- First sentence: Express enthusiasm about the launch
- Second sentence: Restate the key customer benefit
- Third sentence: Connect to broader vision or mission
- Keep it authentic - avoid corporate speak

**Example**:
```
"We are excited to launch ID-me for all Swedish residents," said Anna Bergström, Director of Digital Services for the Swedish Government. "For too long, citizens have struggled with fragmented authentication systems that create barriers to accessing essential services. ID-me removes these barriers and makes digital government services as easy to use as sending a text message. This is a major step toward our vision of making Sweden's digital infrastructure accessible to everyone, regardless of technical skill or background."
```

**Tips**:
- Use a real or realistic name and title
- Write in natural speaking style, not marketing language
- Connect customer benefit to organizational mission
- Avoid buzzwords and jargon
- Keep it to 3-4 sentences

#### Paragraph 5: How It Works
**Purpose**: Provide a simple, step-by-step description of the customer experience.

**Anatomy**:
- Walk through the key user journey
- Use chronological order
- Focus on ease and simplicity
- Include 3-5 steps maximum
- Use concrete action verbs

**Example**:
```
When a user logs into a service using ID-me, they open the ID-me app on their smartphone and scan the QR code provided on the website. Next, they confirm their identity with a fingerprint or a quick code, and within seconds, they can securely access services like banking, healthcare, or government platforms. They may also perform actions that require a verification step, such as money transfers, personal information updates, and ordering of services.
```

**Tips**:
- Start with the first step and move chronologically
- Use "user does X, system does Y" pattern
- Keep each step simple and concrete
- Avoid technical details or system architecture
- Show the ease and speed of the experience

#### Paragraph 6: Customer Testimonial
**Purpose**: Bring the solution to life through a customer's voice and experience.

**Anatomy**:
- Frustration before the solution
- Name and relevant info about the customer
- Discovery of the solution
- Key benefit(s)
- One delightful moment
- How it changed their reality
- Optional: Converted to an admirer/ambassador

**Example**:
```
"Before ID-me, I struggled with keeping track of countless passwords and annoying verification processes every time I needed to access my accounts," said Johan Andersson, 35, from Stockholm, "With ID-me, things are much easier. Just yesterday, I made payments in my bank, booked a doctor’s meeting for our son, and submitted an address change on Skatteverket – all in just 15 minutes and no SMS codes. It made my digital life so much simpler. I am telling all my family and friends that they have to use it, too!"
```

**Tips**:
- Create a realistic persona that represents your target customer
- Include specific details that make it believable
- Show concrete results (time saved, frustration eliminated)
- Use conversational language
- Include both functional and emotional benefits

#### Paragraph 7: Call to Action
**Purpose**: Tell readers how to get started and where to learn more.

**Anatomy**:
- Availability statement (when/where/how to access)
- Pricing or cost information
- Where to learn more or get support
- Any eligibility requirements
- Keep it short and actionable

**Example**:
```
Visit www.ID-me.se or download the app in the Appstore to get started.
```

**Tips**:
- Be specific about availability and access
- Make pricing or cost crystal clear
- Provide concrete next steps
- Include support resources
- Avoid marketing fluff - just give useful information

**🎯 Deliverable**: One-page press release (approximately 400-500 words) following the 7-paragraph structure.

---

### Phase 4: Customer FAQs (5-8 Questions)

Write questions that customers would ask about using your product or service. These should address practical concerns, not technical implementation.

#### Customer FAQ Categories:

**1. Getting Started**: How do I sign up? What do I need? How long does it take?

**2. Usage**: How does it work? What can I do with it? What are the limitations?

**3. Cost & Value**: How much does it cost? What do I get? Are there different plans?

**4. Trust & Security**: Is it safe? What about my privacy? Who has access to my data?

**5. Support**: Where can I get help? What if something goes wrong? Are there tutorials?

**6. Compatibility**: What devices work? What about my current setup? Does it integrate with X?

**7. Accessibility**: Can everyone use this? What about language options? What about disabilities?

**8. Future**: Will it get better? What's coming next? Can I request features?

#### Customer FAQ Structure:

Each FAQ should follow this pattern:
- **Question**: Written in customer voice (casual, direct)
- **Answer**: 2-4 sentences, customer-focused, jargon-free
- Include specific details and concrete examples
- End with reassurance or additional benefit when appropriate

**Example Customer FAQs**:

```
**Q: How do I get started with ID-me?**
A: Download the free ID-me app from the App Store or Google Play, then verify your identity using your existing BankID or eID credential. This one-time setup takes about 5 minutes. After that, set up Face ID or fingerprint authentication on your device, and you're ready to access all connected government services instantly.

**Q: Which government services work with ID-me?**
A: ID-me currently works with all major Swedish government services, including tax agency (Skatteverket), health services (1177), unemployment services (Arbetsförmedlingen), pension services, and most municipal services. The complete list of over 150 connected services is available in the app and on our website. New services are added regularly based on user requests.

**Q: Is ID-me secure? What happens to my personal information?**
A: Yes, ID-me meets the highest European security standards (eIDAS Level High). Your biometric data never leaves your device - it stays in your phone's secure enclave. ID-me only transmits authentication tokens to verify your identity, not your actual biometric data. All communications are encrypted, and we're regularly audited by independent security firms. Your personal information is stored in Swedish data centers and never shared with third parties.

**Q: What if I get a new phone? Do I have to set everything up again?**
A: Transferring ID-me to a new phone takes about 2 minutes. When you set up your new device, download the ID-me app and choose "Transfer to New Device." You'll verify your identity using your old phone or a backup method (SMS code to your registered number), and all your connected services transfer automatically. No need to reconfigure anything.

**Q: Does ID-me cost anything? Are there premium features?**
A: ID-me is completely free for all Swedish residents. There are no premium tiers, hidden fees, or paid features. The Swedish government funds ID-me as a public service to improve digital access for all citizens. Everything you need to access government services is included at no cost.

**Q: What if I need help? Is there customer support?**
A: Yes, support is available 7 days a week from 7 AM to 10 PM via phone (020-XXX-XXXX), email (support@id-me.se), and in-app chat. Support is available in Swedish, English, Arabic, Somali, and Persian. The app also includes step-by-step guides and video tutorials for common tasks. Average response time is under 5 minutes for phone and chat, under 2 hours for email.

**Q: Can my elderly parent use ID-me? What about people who aren't tech-savvy?**
A: Yes, ID-me is designed to be simple enough for anyone to use. We've specifically focused on making it accessible for elderly users and people with limited technical experience. The app includes a simplified mode with larger text and icons, voice guidance options, and the ability to set up trusted helpers who can assist remotely if needed. We also offer free in-person setup assistance at libraries and community centers in major cities.

**Q: What languages does ID-me support?**
A: ID-me is currently available in Swedish, English, Arabic, Somali, Persian, and Finnish, with plans to add more languages based on user needs. You can switch languages anytime in the app settings, and all support materials, tutorials, and customer service are available in these languages.
```

**Tips for Writing Customer FAQs**:
- Think like a skeptical customer who's considering trying it
- Address practical concerns, not theoretical edge cases
- Use conversational language in questions
- Provide specific, concrete answers with numbers/details
- Anticipate objections and concerns
- Include trust-building information (security, privacy, support)
- Show you've thought through the real customer experience
- Aim for 7-10 questions - don't overwhelm

**🎯 Deliverable**: 7-10 Customer FAQs (approximately 2 page total)

---

### Phase 5: Stakeholder FAQs (7-10 Questions)

Write questions that internal teams and stakeholders would ask about building, launching, and scaling your innovation. If answers are not certain (as this is an innovation) it should state the assumptions being made, clarifies our thinking, and states how we plan to learn more.

#### Stakeholder FAQ Structure:

Each question should:
- Be specific and challenging (think "skeptical executive")
- Answer with concrete data, plans, or reasoning
- Address dependencies and trade-offs
- Show you've thought deeply about implementation

**Example Stakeholder FAQs**:

```
Q1: Why are we launching ID-me now?
A1: The need for a secure, unified digital identity solution has been growing rapidly as more services move online. Swedish residents are frustrated with managing multiple logins and verification processes. By launching ID-me now, we can get ahead of the curve and establish ourselves as the go-to platform for streamlined digital access.

Q2: What are the key risks, and how will we address them?
A2: Data security and privacy are paramount concerns. We will implement industry-leading encryption and security protocols to protect user data. Additionally, we will be transparent about our data practices and give users control over their information. Another risk is user adoption - we will invest in user education and a seamless onboarding experience to drive adoption.

Q3: What will we do in case of overnight runaway success?
A3: While rapid growth would be exciting, we need to be prepared to scale our infrastructure and support resources accordingly. We will have a robust capacity planning process in place and be ready to quickly provision additional servers and hire more customer support sta^ as needed. The architecture is build on cloud and serverless components to allow for automated scale up and scale down accroding to demand, while saving cost and wasted resources.

Q4: What are we thinking about a funding model for develolpment and maintainance?
A4: Our goal is to make ID-me accessible to all Swedish residents. We will establish partnerships with banks, government agencies, and service providers to o^er ID-me as a secure authentication service, so that they help fund it, consolidating development and maintanace cost with one authorized entity.

Q5: How will we ensure compatibility with various digital services?
A5: We will work closely with major service providers (banks, healthcare, government, etc.) to integrate ID-me into their platforms. We will also develop a robust API and documentation to enable smaller providers to easily integrate with our solution. Maintaining an up-to-date list of compatible services will be a priority.

Q6: What is our plan for user support and education?
A6: We recognize that some users may need assistance with setup and troubleshooting. Our support strategy includes a comprehensive knowledge base, video tutorials, and both self-service and human-assisted support channels (chat, email, phone). We will also invest in marketing and educational campaigns to raise awareness and drive adoption.

Q7: How will we address potential regulatory or compliance concerns?
A7: We will work closely with relevant regulatory bodies and legal experts to ensure ID-me complies with all applicable laws and regulations around data privacy, security, and digital  identities. We will also implement robust internal policies and procedures 140 to maintain compliance as regulations evolve.

Q8: What is our long-term vision for ID-me?
A8: While our initial focus is on simplifying digital access for Swedish residents, our long term vision is to expand ID-me into a global platform for secure digital identities. We aim to partner with service providers and governments worldwide to make ID-me the universal solution for streamlined, secure access to online services.

```

**Tips for Writing Stakeholder FAQs**:
- Put yourself in the shoes of a skeptical executive or engineer, which still wants to help the team discover assumptions and make the solution better and more robust
- Provide specific data, timelines, and numbers
- Show you've thought through dependencies and trade-offs
- Include mitigation strategies for major risks
- Be realistic about challenges - don't oversell
- Demonstrate depth of thinking about implementation
- Include costs, timelines, resources required
- Address organizational and technical feasibility

**🎯 Deliverable**: 7-10 Stakeholder FAQs (approximately 2-3 pages total)

---

### Phase 6: Optional Visuals

Consider adding visuals to clarify the customer experience or solution approach. These go in an appendix and don't count toward the 4-6 page limit.

**Useful Visual Types**:

1. **Customer Journey Map**: Show the step-by-step experience from the customer's perspective
2. **Before/After Comparison**: Illustrate the current pain vs. the new solution
3. **Process Flow**: Show how the system works at a high level
4. **Wireframes/Mockups**: Show key screens or interfaces
5. **Data/Metrics**: Charts showing problem magnitude or expected impact
6. **Ecosystem Diagram**: Show how this fits into the larger context

**Tips for Visuals**:
- Keep them simple and easy to understand
- Add captions explaining what the visual shows
- Reference visuals in the main document where relevant
- Don't use visuals to avoid writing clear narratives
- Focus on customer experience, not technical architecture

**🎯 Deliverable**: 2-4 pages of optional visuals in appendix

---

## Output Format

Your final PRFAQ document should be structured as follows:

```
[PRESS RELEASE]

[Headline]
[Sub-headline]

[7 paragraphs following the structure: Elevator Pitch, Problem, Solution, Leader Quote, How It Works, Customer Testimonial, Call to Action]

---

CUSTOMER FREQUENTLY ASKED QUESTIONS

[7-10 Customer-focused questions and answers]

---

STAKEHOLDER FREQUENTLY ASKED QUESTIONS

[7-10 Internally-focused questions and answers]

---

APPENDIX: VISUALS (Optional)

[Customer journey maps, wireframes, diagrams, etc.]
```

---

## Examples

### Example 1: Smart Reading Companion for Children

**Context**: A service helping parents find appropriate books and track reading progress for children ages 3-8.

**Press Release - Elevator Pitch**:
```
ReadBuddy Helps Children Ages 3-8 Discover Their Next Favorite Book
Personalized book recommendations matched to your child's reading level and interests - making reading time engaging and stress-free

STOCKHOLM – Dagens Nyheter – 9/1/2025. ReadBuddy launched today, providing parents with a simple way to discover age-appropriate books their children will love while tracking reading progress across the family. Using research-backed reading assessments and interest profiling, ReadBuddy matches each child with books at their perfect level, making reading time more engaging and building lifelong reading habits.
```

**Sample Customer FAQ**:
```
Q: How does ReadBuddy know which books are right for my 5-year-old?
A: ReadBuddy starts with a 5-minute assessment where your child interacts with a few short stories in the app. This helps us understand their current reading level (letter recognition, word recognition, comprehension). You also tell us their interests (dinosaurs, princesses, trucks, animals, etc.). We then match them with books from our library of 10,000+ titles that are at their level and align with their interests. As they read and progress, ReadBuddy adjusts recommendations to grow with them.
```

**Sample Stakeholder FAQ**:
```
Q: How do we know parents will pay for this when free library resources exist?
A: Our research with 200 parents showed that while libraries are valuable, 73% struggle to find appropriate books among thousands of options, and 68% report checking out books that end up being wrong level or uninteresting to their child. Parents want curation and guidance, not just access. In our beta test with 500 families, 82% converted from free trial to paid subscription ($9.90/month) after 2 weeks, citing time savings (average 45 minutes per library visit) and better engagement (children read 3.2x more books than before). The willingness to pay is strong when the curation genuinely works.
```

---

### Example 2: Sustainable Meal Kit Service

**Context**: A meal kit service delivering locally-sourced ingredients with zero-waste packaging for busy urban professionals.

**Press Release - Problem Paragraph**:
```
Today, environmentally-conscious professionals face a frustrating dilemma. They want to cook healthy meals with sustainable, locally-sourced ingredients, but lack the time to shop at multiple markets and research which products are truly sustainable. Meal kits offer convenience but generate mountains of plastic waste - an average meal kit service produces 2.5 kg of packaging waste per week per household. Meanwhile, buying sustainable ingredients from local markets requires visiting 3-4 different locations, taking 2+ hours per week. As a result, 64% of urban professionals report feeling guilty about their food choices, either for environmental impact or for relying on takeout. This daily dilemma creates stress and compromises both health and environmental values.
```

**Sample Customer FAQ**:
```
Q: How is this actually sustainable? I've tried "green" meal kits before and they still had tons of packaging.
A: GreenPlate is fundamentally different. We use a reusable container system - your ingredients come in glass jars, stainless steel containers, and cloth bags that we pick up and sanitize each week. There is zero single-use packaging. Produce comes in compostable bags you can keep. We source 100% of ingredients from farms within 150 km of Stockholm, and you can see exactly which farm each ingredient came from in your app. Our sustainability report is public and audited quarterly by independent environmental consultants. After 10 weeks, the average household diverts 12 kg of plastic waste compared to traditional meal kits.
```

**Sample Stakeholder FAQ**:
```
Q: How do we handle the logistics of reusable container pickup and sanitization? Doesn't that make operations much more complex than single-use packaging?
A: Yes, it's more complex operationally, but we've designed for it from day one. Our delivery drivers collect used containers during each delivery (same trip, no additional routes). Containers go to our central kitchen where we run them through commercial sanitization (same systems restaurants use). We maintain 3x container inventory to allow for sanitization cycle time. Cost per container use is 8 SEK (purchase, sanitization, logistics) vs. 6 SEK for equivalent single-use packaging, so 2 SEK premium per delivery. However, customer willingness to pay is 25 SEK higher for reusable system, giving us 23 SEK net benefit per delivery. We've piloted this system with 200 households for 6 months and optimized the process - loss/damage rate is 2%, sanitization costs are within projections, and customer satisfaction with the system is 4.7/5.0.
```

---

## Tips for Success

### General Tips:
1. **Start with the customer, always**: Every sentence should be understandable and relevant to your target customer
2. **Be specific**: Vague language and buzzwords kill PRFAQs. Use concrete details, numbers, and examples
3. **Show, don't tell**: Instead of "revolutionary," show what changes. Instead of "easy," show it takes 2 minutes
4. **Use the inverted pyramid**: Most important information first. If someone only reads the first paragraph, they should understand the core value
5. **Write for the skeptic**: Address objections head-on. Anticipate "yeah, but..." questions
6. **Make it believable**: Use realistic names, actual dates, specific numbers. Make it feel like it already exists
7. **Edit ruthlessly**: Remove adjectives, cut redundancy, eliminate jargon. Shorter is better
8. **Test it on someone unfamiliar**: If they can't explain it back to you, rewrite it

### Precise Writing Principles:

**Remove Redundancy**:
- ❌ "The new solution will solve this problem"
- ✅ "The solution solves this problem"

**Use Active Voice**:
- ❌ "Password resets are handled by the system"
- ✅ "The system handles password resets"

**Be Concrete**:
- ❌ "Significantly faster"
- ✅ "3x faster (20 seconds vs. 60 seconds)"

**Replace Jargon**:
- ❌ "Leveraging synergistic paradigms"
- ✅ "Combining existing authentication systems"

**Use Data, Not Adjectives**:
- ❌ "Amazing customer satisfaction"
- ✅ "4.8/5.0 customer satisfaction (500 reviews)"

**Spell Out Acronyms First Use**:
- ❌ "Supports eIDAS compliance"
- ✅ "Supports eIDAS (electronic IDentification, Authentication and trust Services) compliance"

### Common Pitfalls to Avoid:

1. **Writing about the product, not the customer benefit**: Focus on what changes for the customer, not product features
2. **Using internal terminology**: Write for customers who have no knowledge of your organization
3. **Being too high-level**: "Simplifies authentication" is too vague. "Reduces login time from 2 minutes to 5 seconds" is specific
4. **Ignoring the current state**: Show empathy for current pain before jumping to your solution
5. **Making it too long**: The press release should be 1 page, not 3. Edit ruthlessly
6. **Writing FAQ answers as marketing fluff**: Be honest about limitations, costs, and trade-offs
7. **Skipping stakeholder FAQs**: This is where you prove you've thought through implementation
8. **Not addressing feasibility**: "Can we actually build this?" is the most important question

### When to Iterate:

If your PRFAQ doesn't pass these tests, revise it:

✅ **The Grandparent Test**: Can someone unfamiliar with your industry understand the problem and solution?

✅ **The Excitement Test**: Does the customer testimonial feel authentic? Would someone actually say that?

✅ **The Skeptic Test**: Have you addressed the obvious objections? Do the stakeholder FAQs feel hard-hitting?

✅ **The Brevity Test**: Is every sentence necessary? Can you cut 20% without losing meaning?

✅ **The Data Test**: Do you have specific numbers and evidence, or just adjectives?

✅ **The Build Test**: Could an engineering team start planning implementation based on the stakeholder FAQs?

---

## Integration Points

### Before PRFAQ:
- **Idea Evaluation**: Use to assess and score initial concepts before investing time in PRFAQ
- **Critical Validation**: Use Six Thinking Hats to explore idea from multiple perspectives

### After PRFAQ:
- **Critical Validation**: Validate your completed PRFAQ using Six Thinking Hats methodology
- **Stakeholder Presentations**: Use press release as executive summary
- **Roadmap Planning**: Use stakeholder FAQs to identify dependencies and sequencing

### Parallel Use:
- **Customer Research**: Conduct research while writing PRFAQ, iterate based on findings
- **Technical Feasibility**: Have engineers review feasibility FAQs and provide feedback

---

## Closing Thoughts

Writing a great PRFAQ is hard. It forces clarity about customer value, solution approach, and implementation reality. The discomfort you feel while writing is feature, not a bug - if you can't articulate the customer problem clearly, you probably don't understand it well enough to solve it.

The best PRFAQs go through at least 5-10 revisions as you sharpen your thinking. Don't expect perfection on the first draft. Use each section as a thinking tool to pressure-test your idea.

Remember: the goal isn't a beautiful document. The goal is clarity about whether this idea is worth building and how to build it right.

Start writing. The customer is waiting.
