# PRFAQ Template

**Instructions**: Replace all [BRACKETED TEXT] with your content. Delete instruction comments before finalizing. Target: 4-6 pages total (excluding visuals).

---

## PRESS RELEASE

### [PRODUCT/SERVICE NAME]: [KEY BENEFIT IN 5-8 WORDS]

**[One-sentence sub-headline expanding the value proposition]**

**[CITY] – [Publication/News Outlet] – [Date].** [Opening sentence: Product/service name + launch announcement + core benefit for target customer. Use past tense like "announced today" or "launched today" to make it feel real.]

<!-- Paragraph 1: Elevator Pitch - Hook the reader. What is it, who is it for, what's the key benefit? Keep to 3-4 sentences. -->

---

**[Problem Paragraph Heading - Optional]**

[Currently/Today], [describe the current painful reality your customer faces. Be specific about pain points - use concrete details. Quantify the impact if possible. Show empathy for the customer struggle. Make readers nod and say "yes, that's exactly my frustration!" This should be 4-6 sentences painting a vivid picture of the problem.]

<!-- Paragraph 2: Problem - What frustration or gap exists today? Use customer language, not internal jargon. Include emotional impact, not just functional problems. Reference your research or data. -->

---

**[Solution Paragraph Heading - Optional]**

[Product/service name] [solves this problem by doing X core thing]. [Explain 2-4 key features that address the pain points mentioned above. Focus on WHAT it does in customer terms, not HOW it works technically. Show the before/after transformation. Keep to 4-6 sentences using active, concrete verbs.]

<!-- Paragraph 3: Solution - Describe how your innovation solves the problem. Focus on benefits, not technical architecture. Use "by doing X" construction to show cause-and-effect. Avoid adjectives like "innovative" - show, don't tell. -->

---

"[Opening statement expressing enthusiasm about the launch]," said [Full Name], [Title] at [Organization]. "[Second sentence: Restate the key customer benefit or problem being solved.] [Third sentence: Connect to broader vision, mission, or strategic goal.] [Optional fourth sentence: Additional context or future vision.]"

<!-- Paragraph 4: Leader Quote - Add credibility through executive voice. Use realistic name and title. Write in natural speaking style, not marketing language. Avoid buzzwords and jargon. Keep to 3-4 sentences. -->

---

**[How It Works Heading - Optional]**

[Walk through the key user journey in 3-5 simple steps. Use chronological order. Focus on ease and simplicity. Start with: "Getting started takes..." or "Using [product] is simple..." Then describe each step using concrete action verbs. Example: "First, users download... Then they verify... Finally, they access..."]

<!-- Paragraph 5: How It Works - Provide step-by-step customer experience. Use "user does X, system does Y" pattern. Keep each step simple and concrete. Avoid technical details. Show the ease and speed. -->

---

"[Opening statement about the customer's previous struggle or context]," said [Realistic Name], [relevant context like "a 42-year-old teacher from Stockholm"]. "[Describe the before state - their specific pain point.] [Describe the after state - their success with your solution.] [Include specific outcome like time saved, frustration eliminated, goal achieved.] [End with emotional response or broader impact on their life.]"

<!-- Paragraph 6: Customer Testimonial - Bring solution to life through customer voice. Create realistic persona representing target customer. Include specific details that make it believable. Show concrete results. Use conversational language. Include both functional and emotional benefits. -->

---

[Product/service name] is [available now/launching on DATE] [pricing information - be crystal clear about cost]. [Where/how to access - app stores, website, physical location, etc.] [Any eligibility requirements or prerequisites.] [For more information, including [specific helpful resources], visit [website] or [contact method].]

<!-- Paragraph 7: Call to Action - Tell readers how to get started. Be specific about availability, access, and pricing. Provide concrete next steps. Include support resources. Avoid marketing fluff - give useful information. Keep to 3-4 sentences. -->

---

## CUSTOMER FREQUENTLY ASKED QUESTIONS

<!-- Write 5-8 questions customers would ask. Cover: Getting Started, Usage, Cost & Value, Trust & Security, Support, Compatibility, Accessibility, Future. Use customer voice (casual, direct). Answer in 2-4 sentences, customer-focused, jargon-free. Include specific details. -->

**Q: [How do I get started with PRODUCT/SERVICE?]**
A: [Explain the onboarding process in simple steps. How long does it take? What do they need? Be specific and reassuring.]

**Q: [What does it cost? Are there different pricing tiers?]**
A: [Be crystal clear about pricing. No hidden fees. Explain what's included. If there are tiers, explain the differences simply.]

**Q: [Is it secure? What about my privacy/data?]**
A: [Address security and privacy concerns directly. What standards do you meet? Where is data stored? Who has access? Be specific and build trust.]

**Q: [How does it actually work? What can I do with it?]**
A: [Explain the core functionality and key use cases. What are the main things customers will do? Keep it practical and concrete.]

**Q: [What if I need help? Is there customer support?]**
A: [Describe support options: hours, channels (phone, email, chat), response times, languages, additional resources like tutorials or guides.]

**Q: [What devices/platforms does it work with? What about my current setup?]**
A: [Specify compatibility: OS versions, device types, browsers. Address integration concerns. Be clear about any limitations.]

**Q: [Can SPECIFIC_GROUP use this? What about accessibility?]**
A: [Address accessibility for people with disabilities, elderly users, non-technical users, or other specific groups. Describe accommodations and alternative options.]

**Q: [What's coming next? Will it get better?]**
A: [Share future plans or roadmap highlights. Show you're committed to ongoing improvement. Mention how users can provide feedback or request features.]

<!-- Add 0-2 more questions addressing specific concerns for your product/service -->

---

## STAKEHOLDER FREQUENTLY ASKED QUESTIONS

### VALUE RISK

<!-- Address market demand, customer adoption, willingness to pay, competitive positioning. Include 3-5 questions that a skeptical executive would ask. Provide concrete data and evidence. -->

**Q: [How do we know customers will actually use/buy this?]**
A: [Provide research data, pilot results, customer interviews, market analysis. Include specific numbers: adoption rates, conversion rates, retention rates, satisfaction scores. Show evidence of demand.]

**Q: [Why would someone choose this over EXISTING_ALTERNATIVE?]**
A: [Explain your differentiation clearly. What problem do you solve that alternatives don't? What's your unique value? Include comparison data or pilot results showing preference.]

**Q: [What if customers don't trust this? How do we overcome SPECIFIC_OBJECTION?]**
A: [Address the main barrier to adoption. Show how you've designed to overcome it. Include testing results or feedback that demonstrates you've solved this concern.]

<!-- Add 1-3 more value risk questions -->

---

### FEASIBILITY RISK

<!-- Address technical implementation, integration, scalability, dependencies. Include 3-5 questions about whether you can actually build and scale this. Be specific about architecture, resources, timelines. -->

**Q: [What's the technical architecture? Can we build this with our current capabilities?]**
A: [Describe the tech stack and architecture at a high level. What capabilities do you have vs. need to build? What's the team size and timeline? What technologies are you leveraging?]

**Q: [How do we handle SPECIFIC_TECHNICAL_CHALLENGE?]**
A: [Address the hardest technical problem. Explain your approach. Include proof that it's solvable: prototypes, technical research, vendor partnerships, or similar systems that exist.]

**Q: [Can this scale to X users/volume? What about performance?]**
A: [Provide scalability plan and capacity projections. Include load testing results, infrastructure approach (cloud, on-prem), auto-scaling strategy. Show cost per user at scale.]

**Q: [What are our dependencies? What could block or delay this?]**
A: [List critical dependencies: APIs, partnerships, legal approvals, infrastructure, third-party services. For each, state status and mitigation plan if delayed.]

<!-- Add 1-2 more feasibility risk questions -->

---

### USABILITY RISK

<!-- Address ease of use, learning curve, error handling, accessibility, edge cases. Include 3-5 questions about whether customers can successfully use this. Include testing data. -->

**Q: [How easy is it to set up/get started? What if users get stuck?]**
A: [Provide usability testing results: completion rates, time to complete, points of confusion. Describe support mechanisms: in-app help, tutorials, live support. Show you've tested with real users.]

**Q: [What about users who DON'T FIT TYPICAL PROFILE? Can they use this?]**
A: [Address edge cases: older devices, non-technical users, users with disabilities, users without prerequisites. Describe accommodations or alternative paths.]

**Q: [What happens when something goes wrong? What if SPECIFIC_ERROR_SCENARIO?]**
A: [Describe error handling and recovery mechanisms. Include fallback options. Show you've thought through failure modes and have mitigation strategies.]

**Q: [How do we handle accessibility requirements?]**
A: [List accessibility standards you meet (WCAG, etc.). Describe specific accommodations: screen readers, text size, contrast, alternative inputs. Include testing results with users with disabilities.]

<!-- Add 0-2 more usability risk questions -->

---

### VIABILITY RISK

<!-- Address costs, ROI, business model, organizational alignment, risks, go-to-market. Include 3-5 questions about whether this makes business sense. Include financial projections. -->

**Q: [What's the total cost and expected ROI?]**
A: [Break down costs by year and category: development, launch, operations. Provide ROI calculation with assumptions. When do you break even? What's the 3-year net benefit? Be specific with numbers.]

**Q: [How does this align with our strategy and other initiatives?]**
A: [Show how this supports strategic priorities. Explain how it complements (not competes with) other projects. Include executive sponsorship and where this fits in roadmap.]

**Q: [What's our go-to-market strategy? How do we drive adoption?]**
A: [Describe launch phases, target segments, acquisition channels, marketing approach. Include adoption targets by timeframe. Show you have a realistic plan to reach customers.]

**Q: [What are the ongoing operational costs and who will manage this?]**
A: [Detail ongoing costs: infrastructure, support team, maintenance, updates. Specify team size and roles. Explain governance and long-term ownership.]

**Q: [What could cause this to fail? What's our mitigation plan?]**
A: [List top 3-5 failure risks. For each risk, provide: likelihood, impact, mitigation strategy, contingency plan. Show you've thought through worst-case scenarios.]

<!-- Add 0-2 more viability risk questions -->

---

## APPENDIX: VISUALS (Optional)

<!-- Include customer journey maps, before/after comparisons, wireframes, process flows, data visualizations, or ecosystem diagrams. Add captions explaining what each visual shows. Reference these in the main document where relevant. Focus on customer experience, not technical architecture. -->

**[Visual 1 Title]**
[Description of what this visual shows and why it's helpful]
[Insert visual here]

**[Visual 2 Title]**
[Description of what this visual shows and why it's helpful]
[Insert visual here]

---

## CHECKLIST BEFORE FINALIZING

- [ ] Press release is exactly 1 page (400-500 words)
- [ ] All 7 press release paragraphs are present and follow structure
- [ ] No bullet points in press release narrative
- [ ] Customer FAQs: 5-8 questions, practical concerns
- [ ] Stakeholder FAQs: 12-18 questions across 4 risk categories
- [ ] All numbers and data are specific (not vague adjectives)
- [ ] No buzzwords or jargon - customer language throughout
- [ ] Active voice used, redundancy removed
- [ ] Acronyms spelled out on first use
- [ ] Customer testimonial feels authentic and realistic
- [ ] Stakeholder FAQs address technical feasibility, costs, risks
- [ ] Someone unfamiliar with your industry could understand this
- [ ] Core document is 4-6 pages (excluding visuals)
- [ ] 11pt font, line numbers, clear section headers
- [ ] Passes "The Grandparent Test" - anyone can understand it

---

**Remember**: The PRFAQ is a thinking tool. If you struggle to articulate something clearly, you probably need to think about it more deeply. That's the point.
