# PRFAQ Quick Reference

## The 5 Working Backwards Questions

Before writing anything, answer these:

1. **Who is the customer?** (Be specific - avoid "everyone")
2. **What is the customer problem or opportunity?** (Current pain point in detail)
3. **What is the most important customer benefit?** (Single biggest value, transformative not incremental)
4. **How do you know what customers need or want?** (Evidence and data)
5. **What does the customer experience look like?** (Tell a vivid story)

---

## Today Statement Template

```
Today, [target customer] wants to [goal], but [problem exists].

This is important because [impact].

We know this is true because [evidence].

We believe [solution] will improve [outcome] for [customer].
```

---

## Press Release Structure (7 Paragraphs)

### 1. Elevator Pitch (The Lead)
- [ ] Clear headline with product name + key benefit
- [ ] Sub-headline expands value proposition
- [ ] Lead paragraph: Location, date, launch announcement, core benefit
- [ ] Written in past tense ("announced," "launched")

### 2. Problem
- [ ] Starts with "Currently" or "Today"
- [ ] Specific pain points with concrete details
- [ ] Quantified impact where possible
- [ ] Shows empathy for customer struggle

### 3. Solution
- [ ] Product/service name clearly stated
- [ ] Core functionality in customer terms
- [ ] 2-4 key features addressing pain points
- [ ] Before/after transformation shown
- [ ] Focus on benefits, not technical details

### 4. Leader Quote
- [ ] Full name and realistic title
- [ ] Enthusiasm about launch
- [ ] Restate key customer benefit
- [ ] Connect to broader vision/mission
- [ ] Natural speaking style (3-4 sentences)

### 5. How It Works
- [ ] Simple step-by-step description
- [ ] Chronological order
- [ ] 3-5 steps maximum
- [ ] Concrete action verbs
- [ ] Shows ease and simplicity

### 6. Customer Testimonial
- [ ] Realistic name with relevant context
- [ ] Describe before state (struggle)
- [ ] Describe after state (success)
- [ ] Emotional response or specific outcome
- [ ] Authentic, human language

### 7. Call to Action
- [ ] When/where/how to access
- [ ] Pricing or cost (crystal clear)
- [ ] Where to learn more
- [ ] Eligibility requirements
- [ ] No marketing fluff - just facts

**Target**: 400-500 words total, fits on 1 page

---

## Customer FAQs (5-8 Questions)

### Categories to Cover:
- **Getting Started**: How do I sign up? What do I need?
- **Usage**: How does it work? What are limitations?
- **Cost & Value**: How much? What do I get?
- **Trust & Security**: Is it safe? What about privacy?
- **Support**: Where can I get help?
- **Compatibility**: What devices work?
- **Accessibility**: Can everyone use this?
- **Future**: What's coming next?

### Structure per FAQ:
- Question in customer voice (casual, direct)
- Answer: 2-4 sentences, customer-focused, jargon-free
- Specific details and concrete examples
- End with reassurance or additional benefit

---

## Stakeholder FAQs (12-18 Questions)

### Four Risk Categories (3-5 questions each):

#### VALUE RISK
- Will customers actually want this?
- Will they pay or switch from alternatives?
- How do we know there's demand?

#### FEASIBILITY RISK
- Can we actually build this?
- Do we have the technology?
- Can we scale it?
- What are the dependencies?

#### USABILITY RISK
- Can customers figure out how to use it?
- Is it intuitive?
- What about edge cases and errors?
- What about accessibility?

#### VIABILITY RISK
- Does this make business sense?
- What's the cost and ROI?
- Does it align with strategy?
- What could cause this to fail?

### Answer Format:
- Concrete data, timelines, numbers
- Address dependencies and trade-offs
- Show depth of thinking
- Include mitigation strategies for risks
- Be realistic about challenges

---

## Precise Writing Principles

### DO:
✅ Use active voice ("The system handles..." not "Password resets are handled...")
✅ Be concrete ("3x faster - 20 seconds vs. 60 seconds" not "significantly faster")
✅ Use data ("4.8/5.0 satisfaction, 500 reviews" not "amazing satisfaction")
✅ Spell out acronyms on first use
✅ Remove redundancy ("The solution solves..." not "The new solution will solve...")
✅ Use customer language, not internal jargon

### DON'T:
❌ Use bullet points in press release narrative
❌ Use adjectives instead of data ("innovative," "revolutionary")
❌ Use passive voice
❌ Use buzzwords or corporate speak
❌ Make vague claims without specifics
❌ Skip addressing obvious objections

---

## Formatting Standards

- **Font**: 11pt Calibri or Arial
- **Line numbers**: On left margin
- **Length**: 4-6 pages core document (excluding visuals)
- **Spacing**: Single-spaced with clear section headers
- **Structure**: Press Release (1 page) → Customer FAQs (1 page) → Stakeholder FAQs (2-4 pages) → Visuals (appendix)

---

## The Grandparent Test

Before finalizing, ask:
- ✅ Can someone unfamiliar with your industry understand it?
- ✅ Does the customer testimonial feel authentic?
- ✅ Have you addressed obvious objections?
- ✅ Is every sentence necessary?
- ✅ Do you have specific numbers, not just adjectives?
- ✅ Could an engineering team start planning from this?

---

## Quick Wins

**Too vague**: "Simplifies authentication for users"
**Better**: "Reduces login time from 2 minutes to 5 seconds"

**Too generic**: "Our solution helps customers achieve their goals"
**Better**: "Parents find age-appropriate books in under 2 minutes, compared to 45 minutes at the library"

**Too buzzwordy**: "Leveraging AI-powered synergistic paradigms"
**Better**: "Using machine learning to match customers with relevant products"

**Too marketing**: "Revolutionary innovation transforms the industry"
**Better**: "Reduces costs by 60% ($108M annually) while improving satisfaction from 3.2/5 to 4.7/5"

---

## Remember

The PRFAQ is a thinking tool, not a marketing document. If you can't articulate the customer problem clearly, you don't understand it well enough to solve it. Discomfort while writing = clarity emerging.

**Start writing. The customer is waiting.**
