---
name: scamper-adapt
description: Generate innovative ideas by borrowing from other contexts, industries, or nature. Part of SCAMPER ideation toolkit. Cross-pollinate solutions from different domains to solve your problem in novel ways. Leverage proven patterns from elsewhere. Can be used standalone or as part of ideation-scamper orchestration.
---

# SCAMPER: Adapt - Borrow from Other Contexts

## Purpose

Generate innovative ideas by borrowing, copying, or adapting solutions from other industries, cultures, nature, or historical contexts. Adaptation leverages proven patterns and accelerates innovation through cross-pollination.

## When to Use This Skill

Use this skill when:
- Stuck on a problem others have likely solved differently
- Want to accelerate innovation by not reinventing the wheel
- Seeking inspiration from unexpected sources
- Looking to transfer proven patterns from mature to emerging markets
- Part of comprehensive SCAMPER session (use ideation-scamper orchestrator)

## The Adapt Technique

**Core question:** What can you copy or borrow from elsewhere?

**Philosophy:** Your problem is rarely unique. Someone, somewhere—perhaps in a completely different domain—has solved something similar. Adaptation is smart borrowing, not lazy copying.

## Types of Adaptation

### 1. Cross-Industry Transfer
Borrow solutions from different sectors
- Example: Assembly line from meatpacking → Automotive (Ford)
- Example: Fast fashion from just-in-time manufacturing (Zara ← Toyota)
- Example: Hospital checklists from aviation safety

### 2. Biomimicry
Copy from nature
- Example: Velcro from burr hooks on dog fur
- Example: Bullet train nose from kingfisher beak
- Example: Solar panels from leaf photosynthesis

### 3. Cross-Cultural Adaptation
Borrow from different cultures or markets
- Example: Mobile money from Kenya (M-Pesa) → Other markets
- Example: QR code payments from China → Global
- Example: Hygge lifestyle design from Scandinavia → Worldwide

### 4. Historical Revival
Bring back old solutions
- Example: Vinyl records comeback
- Example: Mechanical keyboards returning
- Example: Apprenticeship models for modern skills

### 5. Scale Transfer
Adapt from larger/smaller scale
- Example: Enterprise software → Consumer (Slack)
- Example: Consumer tech → Enterprise (iPhone → BYOD)
- Example: Industrial → Household (3D printing)

### 6. Analogical Thinking
Solve like an analogous problem
- Example: Traffic congestion → Data packet routing
- Example: Immune system → Cybersecurity
- Example: Evolution → Algorithm optimization

## Workflow

### Step 1: Frame Your Challenge
Clearly state the problem you're trying to solve.

### Step 2: Find Analogies
Ask: Who else faces similar challenges?
- What industry?
- What scale?
- What context?

### Step 3: Research Solutions
Look for how they solved it:
- Industry case studies
- Nature documentaries
- Historical examples
- Cultural practices

### Step 4: Abstract the Pattern
Identify the core principle, not surface details.

### Step 5: Adapt to Your Context
Translate the pattern to your specific situation.

### Step 6: Generate 5-10 Ideas
Document adaptations with source context.

## Prompting Questions

**Industry:**
- How do other industries handle similar problems?
- What does [industry X] do that we could borrow?
- Who's best-in-class at this, anywhere?

**Nature:**
- What does this problem remind me of in nature?
- How do animals/plants/ecosystems handle this?
- What biological systems are analogous?

**Culture:**
- How do other cultures approach this?
- What works in emerging markets that developed markets abandoned?
- What traditional practices solve modern problems?

**History:**
- How was this handled before modern technology?
- What old solutions did we forget?
- What's cyclical that might return?

**Scale:**
- How do enterprises solve this vs startups?
- How do large countries handle this vs small ones?
- What works at massive scale that could work small?

**Analogy:**
- What's this problem like?
- If this were [X], how would we solve it?
- What shares the same structure?

## Examples from Case Studies

### FairCredit (Nigeria Micro-Lending)

**Adapt #1:** Borrow "buy now, pay later" from e-commerce
- **Adapted from:** Klarna, Afterpay at checkout
- **Benefit:** Point-of-sale financing for market purchases, instant gratification

**Adapt #2:** Copy gamification from fitness apps
- **Adapted from:** Strava challenges, Duolingo streaks
- **Benefit:** Make repayment engaging, build positive habits, social motivation

**Adapt #3:** Borrow credit-building from US secured cards
- **Adapted from:** Capital One, Chime credit builder programs
- **Benefit:** Pathway to formal banking, graduation model

**Adapt #4:** Copy autopay from utility bills
- **Adapted from:** Electricity, water automatic deductions
- **Benefit:** Set-and-forget convenience, reduced defaults

**Adapt #5:** Borrow referral rewards from Dropbox
- **Adapted from:** Storage for referrals → Interest discount for referrals
- **Benefit:** Viral growth, community building, customer acquisition

### AsyncFlow (Remote Collaboration)

**Adapt #1:** Borrow "office hours" from academia
- **Adapted from:** Professor availability windows → Team lead scheduled availability
- **Benefit:** Predictable synchronous time, protected async time

**Adapt #2:** Copy Wikipedia's talk pages
- **Adapted from:** Article discussion system → Decision documentation
- **Benefit:** Threaded context, reasoning preserved, searchable decisions

**Adapt #3:** Borrow "show your work" from mathematics
- **Adapted from:** Math proofs → Code/design rationale
- **Benefit:** Learning, transparency, reduces re-litigating decisions

**Adapt #4:** Copy asynchronous standups from distributed teams
- **Adapted from:** Automattic, Basecamp practices → Your team workflow
- **Benefit:** No timezone conflicts, thoughtful updates, permanent record

### SolarSeva (India Home Solar)

**Adapt #1:** Borrow mobile money from M-Pesa
- **Adapted from:** Kenya mobile payments → Solar loan repayments
- **Benefit:** Cash-light, trackable, convenient, matches existing behavior

**Adapt #2:** Copy Netflix subscription tiers
- **Adapted from:** Basic/Standard/Premium video → Solar capacity tiers
- **Benefit:** Entry-level access, upsell path, clear value ladder

**Adapt #3:** Borrow community ownership from solar cooperatives
- **Adapted from:** Bangladesh solar co-ops → Indian village model
- **Benefit:** Shared investment, local maintenance, collective bargaining

**Adapt #4:** Copy SaaS customer success model
- **Adapted from:** Software onboarding → Solar installation & training
- **Benefit:** Ensures successful deployment, reduces churn, increases satisfaction

### Unbroken (Sweden Disaster Logistics)

**Adapt #1:** Borrow Bitcoin's consensus mechanism
- **Adapted from:** Blockchain proof-of-work → Distributed data validation
- **Benefit:** Truth without central authority, works offline

**Adapt #2:** Copy military supply chain resilience
- **Adapted from:** NATO logistics doctrine → Civilian disaster response
- **Benefit:** Proven under extreme conditions, redundancy built-in

**Adapt #3:** Borrow mesh networking from Firechat
- **Adapted from:** Protest communication tool → Disaster coordination
- **Benefit:** Works without infrastructure, device-to-device

**Adapt #4:** Copy version control from Git
- **Adapted from:** Code synchronization → Logistics data sync
- **Benefit:** Conflict resolution, merge strategies, offline-first

## Output Format

```markdown
# ADAPT Ideas: [Product/Service Name]

## Challenge Being Addressed
[Clearly state the problem you're solving]

## Adaptation Ideas

### Idea 1: [Short Name]
**Adapted from:** [Source: industry, nature, culture, history, analogy]
**Original context:** [How it works there]
**Core pattern:** [Abstract principle being borrowed]
**Adapted to our context:** [How it translates to your solution]
**Potential benefits:**
- [Benefit 1]
- [Benefit 2]
**Translation challenges:** [What might not carry over]

### Idea 2: [Short Name]
[Same structure]

[Continue for 5-10 ideas]

## Summary
**Total adaptation ideas:** [count]
**Most unexpected source:** [Note any surprising inspirations]
**Most promising:** [Top 3]
**Patterns observed:** [Any recurring themes]
```

## Tips for Success

**Do:**
- Look far afield—best adaptations come from distant domains
- Abstract the principle, not copy surface details
- Research deeply—understand why it works there
- Consider cultural context in adaptation
- Build adaptation library over time (collect examples)

**Don't:**
- Copy without understanding context
- Assume what works elsewhere works everywhere
- Ignore cultural fit (Western solutions may not work globally)
- Forget to credit sources (adaptation is honorable, plagiarism isn't)

## Common Pitfalls

- **Superficial copying:** Taking surface features without underlying logic
- **Context blindness:** Ignoring why it works in original setting
- **Not-invented-here syndrome:** Dismissing external ideas
- **Over-adaptation:** Changing so much you lose the original insight

## Building Your Adaptation Library

Keep a collection of interesting solutions:
- Industry case studies
- Biomimicry examples
- Cultural practices
- Historical innovations
- Analogies that worked

When you hit a problem, consult your library first.

## Integration Points

**Input from solution-definition:**
- PRFAQ describes problem to solve
- Customer context suggests relevant sources (e.g., informal economy solutions)
- Hard problems in FAQ benefit most from adaptation

**Output to idea-evaluation:**
- Adapted ideas with proof from other contexts
- Source credibility varies (proven vs speculative)
- Cultural fit considerations

**Used with other SCAMPER techniques:**
- Adapt then Modify (borrow then adjust to fit)
- Adapt + Combine (integrate multiple borrowed solutions)
- Adapt reveals what to Substitute (borrowed approach replaces current)

## Next Steps

After generating adaptation ideas:
1. **Research deeper:** Understand why adapted solutions work in source context
2. **Test cultural fit:** Validate borrowings make sense in your market
3. **Continue SCAMPER:** Use other techniques (Modify, Put to other uses, Eliminate, Reverse)
4. **Build case studies:** Document successful adaptations for future reference

Adaptation is often the fastest path to proven innovation—stand on shoulders of giants.
