---
name: scamper-combine
description: Generate innovative ideas by merging components in novel ways. Part of SCAMPER ideation toolkit. Explore integration, bundling, and synergies by bringing together features, services, data, or processes. Reveals ecosystem opportunities and value-add bundling. Can be used standalone or as part of ideation-scamper orchestration.
---

# SCAMPER: Combine - Merge Components

## Purpose

Generate innovative ideas by systematically exploring what can be brought together, integrated, or merged. Combination often creates new value through synergies, convenience, or bundled offerings.

## When to Use This Skill

Use this skill when:
- You want to explore bundling or integration opportunities
- Looking for ways to increase convenience or reduce friction
- Seeking ecosystem or platform plays
- Want to create value through synergies
- Exploring cross-selling or service expansion
- Part of comprehensive SCAMPER session (use ideation-scamper orchestrator)

## The Combine Technique

**Core question:** What can you bring together or integrate?

**Philosophy:** 1 + 1 can equal 3 when combined thoughtfully. Integration creates convenience, reveals platform opportunities, and generates new value that neither component offers alone.

## Types of Combination

### 1. Feature Integration
Merge multiple features into one offering
- Example: Phone + Camera + Computer = Smartphone
- Example: Ride-sharing + Food delivery = Super app

### 2. Service Bundling
Package complementary services together
- Example: Internet + TV + Phone = Triple play
- Example: Gym + Nutrition + Coaching = Wellness platform

### 3. Data Fusion
Combine multiple data sources for new insights
- Example: Credit score + Social graph + Transactions = Alternative credit
- Example: Weather + Traffic + Events = Smart routing

### 4. User Role Merging
Blur lines between roles
- Example: Consumer + Creator = Prosumer (YouTube, Airbnb)
- Example: Buyer + Seller = Marketplace participant

### 5. Process Integration
Merge separate processes into single flow
- Example: Shop + Pay + Ship = One-click ordering
- Example: Diagnose + Treat + Follow-up = Integrated care

### 6. Purpose Combination
Fulfill multiple jobs simultaneously
- Example: Furniture + Storage = Multi-purpose design
- Example: Exercise + Transportation = Bike commuting

### 7. Channel Convergence
Merge online + offline experiences
- Example: Browse online + Try in store + Ship home = Omnichannel
- Example: Learn online + Practice offline = Blended learning

## Workflow

### Step 1: Review Your Closed World
Identify all components (internal and external) from solution-definition.

### Step 2: Pair Components
Systematically consider pairs:
- Component A + Component B = ?
- What new capability emerges?
- What's more convenient together?

### Step 3: Consider Multi-way Combinations
Beyond pairs, explore 3+ component integrations.

### Step 4: Look for Synergies
Ask: What can the combination do that components alone cannot?

### Step 5: Generate 5-10 Ideas
Document each combination with potential benefits.

## Prompting Questions

**Feature/Service:**
- What features could work together?
- What complementary services fit naturally?
- What does customer often do before/after this?
- What do they currently buy separately that we could bundle?

**Data:**
- What data sources could yield new insights together?
- Can we combine user data with environmental data?
- What information together tells a better story?

**Process:**
- What steps could happen simultaneously?
- What processes could merge into single flow?
- Where do handoffs create friction we could eliminate?

**Roles:**
- Can users be both consumers and creators?
- Can customers also be distributors?
- What happens if roles blur?

**Ecosystem:**
- What partners could we integrate with?
- What adjacent products fit naturally?
- What platform opportunities exist?

## Examples from Case Studies

### FairCredit (Nigeria Micro-Lending)

**Combine #1:** Merge loan approval with savings account creation
- **What's combined:** Borrowing + Saving
- **Benefit:** Builds financial health, asset base, customer lifetime value, cross-selling

**Combine #2:** Integrate repayment with mobile airtime purchase
- **What's combined:** Debt payment + Essential service (phone credit)
- **Benefit:** Convenient single transaction, guaranteed repayment (airtime is necessary)

**Combine #3:** Bundle loan with business training
- **What's combined:** Capital + Knowledge/Skills
- **Benefit:** Higher success rates, customer loyalty, social impact, differentiation

**Combine #4:** Merge credit scoring with health insurance enrollment
- **What's combined:** Financial profile + Health risk assessment
- **Benefit:** Comprehensive financial protection, new revenue stream, holistic offering

**Combine #5:** Integrate transaction history with inventory management
- **What's combined:** Payment tracking + Stock management
- **Benefit:** Help traders run business better, increase revenue, improve repayment capacity

### AsyncFlow (Remote Collaboration)

**Combine #1:** Merge status updates with timezone-aware scheduling
- **What's combined:** Availability indicator + Auto-scheduling
- **Benefit:** Reduces coordination overhead, respects work-life boundaries

**Combine #2:** Integrate task completion with automatic documentation
- **What's combined:** Work execution + Knowledge capture
- **Benefit:** Documentation happens as byproduct, searchable history

**Combine #3:** Bundle messaging with meeting summaries
- **What's combined:** Async discussion + Sync meeting notes
- **Benefit:** Complete context, nothing lost, easier onboarding

**Combine #4:** Merge notifications with priority scoring
- **What's combined:** Alerts + Importance ranking
- **Benefit:** Reduces noise, surfaces what matters, respects focus time

### SolarSeva (India Home Solar)

**Combine #1:** Merge solar system with water purification
- **What's combined:** Electricity generation + Water treatment
- **Benefit:** Complete household utility solution, shared installation cost, bundled value

**Combine #2:** Integrate monitoring with micro-insurance
- **What's combined:** Performance tracking + Failure protection
- **Benefit:** Risk mitigation, customer peace of mind, data for actuarial

**Combine #3:** Bundle installation with appliance financing
- **What's combined:** Solar panels + Efficient appliances
- **Benefit:** Maximize solar value, complete solution, cross-selling

**Combine #4:** Merge energy production with excess sale to neighbors
- **What's combined:** Personal use + Micro-trading
- **Benefit:** Revenue opportunity, community resilience, network effects

### Unbroken (Sweden Disaster Logistics)

**Combine #1:** Merge logistics tracking with crisis communication
- **What's combined:** Supply chain + Team coordination
- **Benefit:** Single platform for disaster response, reduces tool-switching

**Combine #2:** Integrate inventory with predictive disaster modeling
- **What's combined:** Stock levels + Risk forecasting
- **Benefit:** Proactive positioning, better preparedness

**Combine #3:** Bundle routing optimization with vehicle maintenance
- **What's combined:** Path planning + Fleet management
- **Benefit:** Comprehensive operations tool, prevents breakdowns during crisis

**Combine #4:** Merge offline sync with mesh networking
- **What's combined:** Data persistence + Device-to-device communication
- **Benefit:** Works even without any internet infrastructure

## Output Format

```markdown
# COMBINE Ideas: [Product/Service Name]

## Components Being Analyzed
[List components from Closed World being considered for combination]

## Combination Ideas

### Idea 1: [Short Name]
**What's combined:** [Component A] + [Component B] [+ Component C if applicable]
**Type of combination:** [Feature/Service/Data/Process/Role/Purpose]
**New capability created:** [What's possible together that wasn't possible separately]
**Potential benefits:**
- [Benefit 1: usually convenience, synergy, or new value]
- [Benefit 2]
**Integration complexity:** [High/Medium/Low]

### Idea 2: [Short Name]
[Same structure]

[Continue for 5-10 ideas]

## Summary
**Total combination ideas:** [count]
**Platform opportunities identified:** [List any]
**Most promising:** [Top 3]
**Ready for:** Evaluation or continue with other SCAMPER techniques
```

## Tips for Success

**Do:**
- Look for natural adjacencies (what customers do before/after)
- Consider timing (what happens together in time)
- Think ecosystem (who else participates)
- Look for data synergies (what data together is more valuable)
- Consider cultural bundling preferences (vary by market)

**Don't:**
- Force unnatural combinations (just because you can doesn't mean you should)
- Ignore integration costs (combining creates complexity)
- Forget user mental models (some things users expect separate)
- Overcomplicate (combination should simplify, not confuse)

## Common Pitfalls

- **Feature bloat:** Combining everything creates complexity, not value
- **Ignoring unbundling:** Sometimes market wants things separated (see music singles vs albums)
- **Missing platform potential:** Combination might reveal marketplace/platform opportunity
- **Forgetting culture:** Bundling preferences vary (US likes bundles, some markets prefer à la carte)

## Integration Points

**Input from solution-definition:**
- Closed World components ready for combination
- Customer journey reveals natural combination points
- PRFAQ FAQ might show adjacent needs

**Output to idea-evaluation:**
- Combination ideas with synergy hypotheses
- Integration feasibility notes
- Platform/ecosystem potential flagged

**Used with other SCAMPER techniques:**
- Combine with Substitute (combine after replacing components)
- Combine then Modify (merge then adjust the merged entity)
- Combine reveals what to Eliminate (redundant parts after merge)

## Next Steps

After generating combination ideas:
1. **Continue SCAMPER:** Use other techniques (Adapt, Modify, Put to other uses, Eliminate, Reverse)
2. **Identify platform plays:** Do combinations suggest marketplace/platform opportunity?
3. **Evaluate:** Rate integration value vs complexity
4. **Test assumptions:** Validate that users want things combined (not always obvious)

Combination often reveals ecosystem and expansion opportunities—pay attention to platform potential.
