---
name: scamper-eliminate
description: Generate innovative ideas by removing components to simplify. Part of SCAMPER ideation toolkit. Often the most powerful technique—discover what happens when you subtract features, steps, requirements, or intermediaries. Simplification frequently reveals breakthrough innovations and competitive advantages. Can be used standalone or as part of ideation-scamper orchestration.
---

# SCAMPER: Eliminate - Remove to Simplify

## Purpose

Generate innovative ideas by systematically removing components, features, steps, or requirements. Elimination often reveals the most innovative and disruptive ideas through radical simplification.

## When to Use This Skill

Use this skill when:
- Seeking breakthrough simplification opportunities
- Want to challenge industry assumptions about "necessary" features
- Looking for ways to reduce costs dramatically
- Exploring minimalism or accessibility improvements
- Part of comprehensive SCAMPER session (use ideation-scamper orchestrator)

## The Eliminate Technique

**Core question:** What can you remove or simplify?

**Philosophy:** Less is often more. Every component has costs—complexity, maintenance, user confusion, expense. Elimination forces creativity: how can this still work without X? The answer often reveals breakthrough innovation.

## Why Eliminate is Powerful

**Challenges assumptions:** Forces you to question what's truly necessary

**Reveals core value:** Stripping away reveals essence

**Reduces costs:** Fewer components = lower costs

**Increases accessibility:** Simpler = more people can use

**Creates differentiation:** "Does less but better" can win markets

**Exposes bloat:** Industries accumulate unnecessary features over time

## Types of Elimination

### 1. Feature Elimination
Remove functionality
- Example: Google homepage—eliminated clutter, just search
- Example: Craigslist—eliminated fancy design
- Example: Dollar Shave Club—eliminated retail stores

### 2. Process Steps
Remove steps in workflows
- Example: One-click buying—eliminated checkout steps
- Example: Instant approval—eliminated waiting/review
- Example: Pre-filled forms—eliminated data entry

### 3. Physical Components
Remove parts
- Example: Wireless headphones—eliminated cord
- Example: Tesla fewer moving parts than combustion engine
- Example: Digital books—eliminated paper

### 4. Requirements
Remove barriers to entry
- Example: No credit check loans
- Example: No minimum balance accounts
- Example: No contract services

### 5. Intermediaries (Disintermediation)
Remove middlemen
- Example: Direct-to-consumer brands—eliminated retailers
- Example: Airbnb—eliminated hotel company
- Example: Cryptocurrency—eliminated banks (in theory)

### 6. Options/Choices
Remove decision paralysis
- Example: Costco limited SKUs vs supermarket
- Example: Apple limited models vs competitors
- Example: Set menus vs à la carte

### 7. Time/Waiting
Remove delays
- Example: Instant messaging—eliminated mail delay
- Example: Streaming—eliminated wait for download
- Example: Just-in-time—eliminated inventory wait

## Workflow

### Step 1: Review Components
List all components from your Closed World.

### Step 2: Systematic Removal
For each component, ask: What if we removed this entirely?

### Step 3: Challenge Necessity
Question assumptions: Is this really needed? By whom? Why?

### Step 4: Find Workarounds
If we remove X, how could it still function?

### Step 5: Identify Benefits
What do we gain from removal? Cost? Simplicity? Speed? Accessibility?

### Step 6: Generate 5-10 Ideas
Document eliminations with how-it-still-works explanations.

## Prompting Questions

**Features:**
- What if we removed this feature entirely?
- What's the minimal viable version?
- What features do users ignore?
- Can we do less but better?

**Process:**
- What steps can we skip?
- Where's unnecessary friction?
- What if approval/review was automatic?
- Can we eliminate forms, signups, authentication?

**Requirements:**
- What barriers could we remove?
- What if no credit check? No ID? No minimum?
- What requirements exclude people unnecessarily?

**Intermediaries:**
- Can we go direct?
- What middlemen add cost not value?
- Can peer-to-peer replace centralized?

**Choices:**
- What if we offered one option only?
- Can we eliminate configuration complexity?
- What if we made decisions for users?

**Physical:**
- What components aren't essential?
- Can we eliminate packaging?
- What if entirely digital vs physical?

**Time:**
- Can we eliminate waiting?
- What if instant instead of eventual?
- Can we remove scheduling/appointments?

## Examples from Case Studies

### FairCredit (Nigeria Micro-Lending)

**Eliminate #1:** Remove mobile app entirely—pure SMS/USSD
- **What's eliminated:** Smartphone requirement
- **How it works:** All interactions via simple SMS commands
- **Benefit:** Universal access, truly inclusive, 10x market expansion, simplicity

**Eliminate #2:** Remove loan approval waiting period
- **What's eliminated:** Manual review, delay
- **How it works:** Pre-approved amounts based on history, instant disbursement
- **Benefit:** Emergency access, instant gratification, reduced operational cost

**Eliminate #3:** Remove interest calculation—flat fee only
- **What's eliminated:** Compound interest complexity
- **How it works:** Simple ₦500 fee regardless of size/duration
- **Benefit:** Transparency, trust, simplicity, culturally appropriate

**Eliminate #4:** Remove individual accounts—family/group only
- **What's eliminated:** Personal liability isolation
- **How it works:** Shared responsibility within trusted group
- **Benefit:** Cultural fit, lower risk, social bonds strengthen repayment

**Eliminate #5:** Remove repayment reminders entirely
- **What's eliminated:** SMS notifications, push alerts
- **How it works:** Users take responsibility, contact only if late
- **Benefit:** Respect, dignity, lower costs, adult treatment

**Eliminate #6:** Remove credit checks completely
- **What's eliminated:** Scoring algorithm, data requirements
- **How it works:** Start everyone small, grow with behavior
- **Benefit:** True inclusion, simplicity, speed, trust-based

**Eliminate #7:** Remove customer support staff—peer community only
- **What's eliminated:** Dedicated support team
- **How it works:** Experienced borrowers help new ones
- **Benefit:** Cost savings, community building, scalability, authenticity

**Eliminate #8:** Remove product variety—one standard loan only
- **What's eliminated:** Choice complexity, decision paralysis
- **How it works:** Single amount, single term, simple
- **Benefit:** Clarity, speed, reduced confusion, operational simplicity

### AsyncFlow (Remote Collaboration)

**Eliminate #1:** Remove real-time presence indicators
- **What's eliminated:** Green/yellow/red status dots
- **How it works:** Assume async, scheduled sync windows only
- **Benefit:** Reduces FOMO, supports deep work, respects boundaries

**Eliminate #2:** Remove "urgent" flag option
- **What's eliminated:** Ability to mark anything urgent
- **How it works:** Everything is async by default, plan accordingly
- **Benefit:** Forces proper planning, reduces false urgency, calm work

**Eliminate #3:** Remove synchronous meetings default
- **What's eliminated:** Easy meeting scheduling
- **How it works:** Require written justification for any live meeting
- **Benefit:** Dramatic reduction in meetings, thoughtful sync time

**Eliminate #4:** Remove notification sounds/badges
- **What's eliminated:** Interruption mechanisms
- **How it works:** Users check on their schedule, not tool's schedule
- **Benefit:** Deep work protection, user control, reduced anxiety

### SolarSeva (India Home Solar)

**Eliminate #1:** Remove inverter—DC appliances only
- **What's eliminated:** AC conversion component
- **How it works:** Use DC-native appliances (LEDs, fans, phones)
- **Benefit:** Simpler system, cheaper, more efficient, fewer failure points

**Eliminate #2:** Remove installation appointment—ship pre-assembled
- **What's eliminated:** Scheduling, technician visit for setup
- **How it works:** User installs following simple instructions
- **Benefit:** Faster deployment, lower cost, user empowerment

**Eliminate #3:** Remove upfront payment—pure subscription
- **What's eliminated:** Capital requirement
- **How it works:** SolarSeva owns system, user pays for electricity
- **Benefit:** Zero barrier, immediate adoption, predictable revenue

**Eliminate #4:** Remove sales representatives—community referral only
- **What's eliminated:** Sales team and cost
- **How it works:** Users recruit neighbors, earn referral credits
- **Benefit:** Lower CAC, authentic testimonials, viral growth

### Unbroken (Sweden Disaster Logistics)

**Eliminate #1:** Remove cloud server dependency entirely
- **What's eliminated:** Central infrastructure
- **How it works:** Fully distributed, peer-to-peer only
- **Benefit:** Works without any internet, no single failure point

**Eliminate #2:** Remove real-time analytics dashboards
- **What's eliminated:** Live reporting, pretty visualizations
- **How it works:** Batch processing, focus on actions not monitoring
- **Benefit:** Lower bandwidth, works offline, simpler

**Eliminate #3:** Remove user authentication during crisis
- **What's eliminated:** Login requirements
- **How it works:** Open access during disaster, audit later
- **Benefit:** Speed, accessibility, removes barrier when seconds matter

**Eliminate #4:** Remove data validation rules
- **What's eliminated:** Format checking, required fields
- **How it works:** Accept anything, clean up later
- **Benefit:** Speed, flexibility, works with damaged/partial data

## Output Format

```markdown
# ELIMINATE Ideas: [Product/Service Name]

## Components Considered for Removal
[List all components being analyzed]

## Elimination Ideas

### Idea 1: [Short Name]
**What's eliminated:** [Component/feature/step/requirement]
**Type of elimination:** [Feature/Process/Component/Requirement/Intermediary/Choice/Time]
**How it still works without this:** [Brief explanation of alternative approach]
**Potential benefits:**
- [Benefit 1: usually simplicity, cost, accessibility]
- [Benefit 2]
- [Benefit 3]
**What we lose:** [Honest assessment of trade-offs]
**Bold level:** [🔥 Radical | ⚡ Significant | ✓ Incremental]

### Idea 2: [Short Name]
[Same structure]

[Continue for 5-10 ideas]

## Summary
**Total elimination ideas:** [count]
**Most radical:** [The boldest elimination]
**Most practical:** [Easiest to implement]
**Assumptions challenged:** [List industry assumptions questioned]
**Most promising:** [Top 3]
```

## Tips for Success

**Do:**
- Start with "sacred cows"—challenge what everyone assumes is necessary
- Ask "what's the minimum viable version?"
- Look for industry-wide bloat to eliminate
- Consider cultural context (what's optional varies by market)
- Think about who's excluded by current requirements

**Don't:**
- Stop at small simplifications—push to radical eliminations
- Dismiss ideas as "too simple"—that's often where differentiation hides
- Forget that less can be more profitable (lower costs)
- Ignore accessibility gains from removing requirements

## Common Pitfalls

- **Assuming necessity:** Just because everyone does it doesn't mean it's needed
- **Fear of simplicity:** "Too simple" can be a competitive moat
- **Forgetting trade-offs:** Every elimination loses something—be honest
- **Not testing assumptions:** Remove and see what breaks (might be nothing)

## The Power of "No"

**Successful eliminations:**
- **Google:** Eliminated portal clutter → just search
- **Craigslist:** Eliminated modern design → ugly but fast and free
- **Costco:** Eliminated SKU variety → buying power
- **Southwest:** Eliminated assigned seats, meals, hubs → low cost
- **Basecamp:** Eliminated endless features → calm software

**Pattern:** Clear elimination creates clear positioning

## Integration Points

**Input from solution-definition:**
- Closed World components all candidates for elimination
- Customer pains might be caused by complexity to eliminate
- PRFAQ FAQ might reveal unnecessary features

**Output to idea-evaluation:**
- Elimination ideas with simplicity benefits
- Cost savings quantified where possible
- Accessibility improvements noted
- Risk of "too simple" assessed

**Used with other SCAMPER techniques:**
- Eliminate then see what's left for other techniques
- Substitute then Eliminate (replace then remove original)
- Modify to minimum then Eliminate entirely (minify to zero)

## Elimination Heuristics

**Remove if:**
- <20% of users use it
- Adds complexity disproportionate to value
- Exists "because competitors have it"
- Creates barrier to entry
- Requires explanation or support
- Nobody would notice if gone

**Keep if:**
- Core to value proposition
- Used by power users
- Regulatory/safety requirement
- Competitive differentiation

## Next Steps

After generating elimination ideas:
1. **Prototype minimal version:** Actually remove and test
2. **Assess trade-offs:** Who does this hurt? Is it worth it?
3. **Continue SCAMPER:** Use Reverse technique (often pairs well with Eliminate)
4. **Position strategically:** "Does less, better" can be powerful messaging

Elimination is often the highest-impact SCAMPER technique—the ideas that seem too simple often win.
