---
name: scamper-modify
description: Generate innovative ideas by changing attributes, scale, or properties. Part of SCAMPER ideation toolkit. Explore magnifying, minifying, or altering characteristics like size, speed, frequency, strength, shape, or form. Variation often reveals optimizations and new market segments. Can be used standalone or as part of ideation-scamper orchestration.
---

# SCAMPER: Modify/Magnify/Minify - Change Attributes

## Purpose

Generate innovative ideas by systematically varying attributes, scale, or properties of components. Modification reveals optimizations, new market segments, and breakthrough innovations through parameter changes.

## When to Use This Skill

Use this skill when:
- Seeking optimization or improvement opportunities
- Want to explore different market segments (premium vs budget)
- Looking for simpler or more powerful versions
- Considering speed, size, or frequency variations
- Part of comprehensive SCAMPER session (use ideation-scamper orchestrator)

## The Modify Technique

**Core question:** What can you change, amplify, or reduce?

**Philosophy:** Sometimes innovation isn't about adding or removing—it's about adjusting the dial. Making something 10x bigger, smaller, faster, or slower can reveal entirely new use cases and markets.

## Types of Modification

### 1. Scale Changes (Magnify/Minify)
Bigger or smaller
- Example: Server → Smartphone (minify computing)
- Example: Personal trainer → Group fitness class (magnify reach)
- Example: Full meal → Tapas portions (minify serving)

### 2. Speed Changes
Faster or slower
- Example: 2-day delivery → 2-hour delivery (Amazon Prime Now)
- Example: Fast food → Slow food movement
- Example: Real-time → Batch processing

### 3. Frequency Changes
More often or less often
- Example: Annual subscription → Monthly → Daily micro-payments
- Example: Constant notifications → Daily digest
- Example: Weekly meetings → Quarterly offsites

### 4. Strength/Power Changes
Amplify or reduce intensity
- Example: Industrial vacuum → Dyson home vacuum (maintain power, reduce size)
- Example: Full security suite → Minimal antivirus
- Example: Strong authentication → Frictionless login

### 5. Form/Shape Changes
Different physical configuration
- Example: Desktop → Laptop → Tablet → Phone
- Example: Square → Round → Flexible
- Example: Rigid → Foldable

### 6. Flexibility Changes
More rigid or more adaptable
- Example: Fixed plans → Customizable
- Example: One-size → Tailored
- Example: Scheduled → On-demand

### 7. Sensory Changes
Color, texture, sound, taste
- Example: Silent features → Audible feedback
- Example: Monochrome → Color-coded
- Example: Text → Visual → Audio

## Workflow

### Step 1: Select Component
Choose a component from your Closed World to modify.

### Step 2: Choose Modification Dimension
Decide what to vary: scale, speed, frequency, strength, form, flexibility, sensory.

### Step 3: Explore Extremes
What if 10x more? 10x less? Maximum? Minimum? Zero?

### Step 4: Consider Gradations
Not just extremes—what about 2x? 5x? Half? Quarter?

### Step 5: Identify New Value
For each modification, ask: What new use case or market does this unlock?

### Step 6: Generate 5-10 Ideas
Document modifications with impacts.

## Prompting Questions

**Scale:**
- What if 10x bigger? 10x smaller?
- What's the smallest viable version?
- What's the largest practical version?
- Can we serve individuals vs enterprises (or vice versa)?

**Speed:**
- What if instant? What if we slowed down?
- Can we do this in real-time? In batches?
- What if we sped up 100x?

**Frequency:**
- What if multiple times per day? Once per year?
- What if continuous vs intermittent?
- Can we change from subscription to pay-per-use?

**Strength:**
- What if we amplified this capability?
- What's the minimal viable strength?
- Can we dial intensity up or down?

**Form:**
- What if we changed the shape?
- Can this be flexible instead of rigid?
- What if foldable, stretchable, modular?

**Flexibility:**
- Can we make this more customizable?
- What if one-size-fits-all vs highly tailored?
- Can users configure this themselves?

**Sensory:**
- What if we changed color, sound, texture?
- Can we add haptic feedback?
- What if we changed the aesthetic entirely?

## Examples from Case Studies

### FairCredit (Nigeria Micro-Lending)

**Modify #1:** Magnify loan frequency—multiple times per week
- **What's modified:** Frequency (monthly → weekly/daily)
- **Benefit:** Matches market trader cash flow, capital velocity

**Modify #2:** Minify loan application to 3 taps
- **What's modified:** Process length (20 min → 30 sec)
- **Benefit:** Frictionless, higher conversion, mobile-optimized

**Modify #3:** Amplify repayment flexibility—any amount, any time
- **What's modified:** Rigidity → Complete flexibility
- **Benefit:** Reduces stress, accommodates variable income

**Modify #4:** Reduce interest rate but add membership fee
- **What's modified:** Pricing structure (high % → low % + flat fee)
- **Benefit:** Fairness for larger loans, predictable revenue

**Modify #5:** Magnify social features—add community forums
- **What's modified:** Social component (minimal → extensive)
- **Benefit:** Peer support, knowledge sharing, retention

**Modify #6:** Reduce repayment period for discount (7 vs 30 days)
- **What's modified:** Time (shorter = lower total cost)
- **Benefit:** Faster capital recycling, rewards discipline

### AsyncFlow (Remote Collaboration)

**Modify #1:** Amplify context in every message automatically
- **What's modified:** Information density (minimal → rich context)
- **Benefit:** Faster understanding, better decisions, onboarding easier

**Modify #2:** Minify meeting length cap—25 minutes maximum enforced
- **What's modified:** Duration (unlimited → hard limit)
- **Benefit:** Forces focus, respects time, Parkinson's law

**Modify #3:** Reduce notification frequency to daily digest
- **What's modified:** Timing (real-time → batched)
- **Benefit:** Deep work protection, reduced context switching

**Modify #4:** Magnify thread depth—unlimited nesting
- **What's modified:** Discussion structure (flat → deeply nested)
- **Benefit:** Complex conversations organized, context preserved

### SolarSeva (India Home Solar)

**Modify #1:** Modular panels—start small, add capacity
- **What's modified:** Size (fixed → growable)
- **Benefit:** Lower entry barrier, upgrade path, affordability

**Modify #2:** Magnify battery storage for grid sellback
- **What's modified:** Capacity (personal use → surplus)
- **Benefit:** Revenue opportunity, ROI improvement

**Modify #3:** Minify installation time—4 hours to 1 hour
- **What's modified:** Speed (full day → minimal disruption)
- **Benefit:** Convenience, less intrusive, scalability

**Modify #4:** Amplify warranty from 1 year to 10 years
- **What's modified:** Coverage duration (standard → extended)
- **Benefit:** Trust signal, competitive differentiation

### Unbroken (Sweden Disaster Logistics)

**Modify #1:** Amplify offline capability—30 days without internet
- **What's modified:** Resilience duration (hours → weeks)
- **Benefit:** Extreme disaster readiness, competitive moat

**Modify #2:** Minify data payload—extreme compression
- **What's modified:** Bandwidth requirement (high → minimal)
- **Benefit:** Works on satellite, radio, any connection

**Modify #3:** Reduce sync frequency to conserve battery
- **What's modified:** Update timing (continuous → periodic)
- **Benefit:** Longer device life in field, efficiency

**Modify #4:** Magnify user count—10,000 concurrent users
- **What's modified:** Scale (hundreds → thousands)
- **Benefit:** National disaster coordination, not just local

## Output Format

```markdown
# MODIFY Ideas: [Product/Service Name]

## Component Being Modified
[Component from Closed World]

## Modification Ideas

### Idea 1: [Short Name - Magnify/Minify/Modify X]
**What's modified:** [Attribute/property] → [Direction/amount of change]
**Type of modification:** [Scale/Speed/Frequency/Strength/Form/Flexibility/Sensory]
**New capability or market:** [What does this change enable?]
**Potential benefits:**
- [Benefit 1]
- [Benefit 2]
**Trade-offs:** [What do you lose or risk?]

### Idea 2: [Short Name]
[Same structure]

[Continue for 5-10 ideas]

## Summary
**Total modification ideas:** [count]
**Optimization vs new market:** [How many improve existing vs open new segments]
**Most promising:** [Top 3]
**Extremes worth exploring:** [Any 10x or zero modifications to test]
```

## Tips for Success

**Do:**
- Push to extremes first (10x, zero) then moderate
- Consider non-linear changes (sometimes 2x isn't interesting but 10x is)
- Look for new markets opened by modifications
- Think about combinations of modifications (smaller AND faster)
- Consider cultural context (size preferences vary globally)

**Don't:**
- Stop at obvious optimizations (5% improvement)
- Ignore market segmentation opportunities (premium vs budget)
- Forget physics/economics constraints (some modifications infeasible)
- Modify arbitrarily (changes should serve purpose)

## Common Pitfalls

- **Incremental thinking:** 10% better isn't innovation, 10x different might be
- **Missing market implications:** Minify might open entirely new segment
- **Forgetting trade-offs:** Every change has costs
- **One-dimensional:** Modify multiple attributes simultaneously for breakthroughs

## Power of Extremes

**10x thinking reveals breakthroughs:**
- 10x faster: Drives different technology choices
- 10x smaller: Opens new markets
- 10x cheaper: Changes who can afford it
- 10x more frequent: Changes usage patterns

**Zero thinking forces creativity:**
- Zero cost: How?
- Zero time: Instant?
- Zero setup: Automatic?

## Integration Points

**Input from solution-definition:**
- Closed World attributes can all be modified
- Customer pains suggest what to amplify/reduce
- PRFAQ constraints guide feasible modifications

**Output to idea-evaluation:**
- Modification ideas with clear value hypotheses
- Market segment implications noted
- Feasibility considerations flagged

**Used with other SCAMPER techniques:**
- Modify then Combine (adjust then merge)
- Substitute then Modify (replace then fine-tune)
- Modify reveals what to Eliminate (reduce to zero)

## Next Steps

After generating modification ideas:
1. **Test extremes:** Prototype 10x versions to explore feasibility
2. **Segment analysis:** Do modifications open new markets?
3. **Continue SCAMPER:** Use other techniques (Put to other uses, Eliminate, Reverse)
4. **Evaluate trade-offs:** Every modification has costs—are they worth benefits?

Modification is often most accessible technique for incremental innovation, but don't forget to push to extremes for breakthroughs.
